/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.util.DataUtils;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import java.util.ArrayList;

@UsedByReflection(value="GamesGmsClientImpl.java")
public final class LeaderboardEntity
implements Leaderboard {
    private final String zza;
    private final String zzb;
    private final Uri zzc;
    private final int zzd;
    private final ArrayList zze;
    private final Game zzf;
    private final String zzg;

    @Override
    public final int getScoreOrder() {
        return this.zzd;
    }

    public final int hashCode() {
        return LeaderboardEntity.zzb(this);
    }

    @Override
    @NonNull
    public final Uri getIconImageUri() {
        return this.zzc;
    }

    @Override
    @NonNull
    public final String getDisplayName() {
        return this.zzb;
    }

    @Override
    @NonNull
    public String getIconImageUrl() {
        return this.zzg;
    }

    @Override
    @NonNull
    public final String getLeaderboardId() {
        return this.zza;
    }

    @NonNull
    public final String toString() {
        return LeaderboardEntity.zzc(this);
    }

    @Override
    @NonNull
    public final ArrayList<LeaderboardVariant> getVariants() {
        ArrayList<LeaderboardVariant> arrayList = new ArrayList<LeaderboardVariant>(this.zze);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public LeaderboardEntity(@NonNull Leaderboard arrayList) {
        this.zza = arrayList.getLeaderboardId();
        this.zzb = arrayList.getDisplayName();
        this.zzc = arrayList.getIconImageUri();
        this.zzg = arrayList.getIconImageUrl();
        this.zzd = arrayList.getScoreOrder();
        Object object = arrayList.zza();
        if (object == null) {
            object = null;
        } else {
            GameEntity gameEntity = new GameEntity((Game)object);
            object = gameEntity;
        }
        this.zzf = object;
        object = arrayList.getVariants();
        int n = ((ArrayList)object).size();
        this.zze = arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.zze.add(((LeaderboardVariant)((ArrayList)object).get(n2)).freeze());
            ++n2;
        }
        return;
    }

    @Override
    public final void getDisplayName(@NonNull CharArrayBuffer charArrayBuffer) {
        DataUtils.copyStringToBuffer((String)this.zzb, (CharArrayBuffer)charArrayBuffer);
    }

    public final boolean equals(@Nullable Object object) {
        return LeaderboardEntity.zzd(this, object);
    }

    public final boolean isDataValid() {
        return true;
    }

    static int zzb(Leaderboard leaderboard) {
        Object[] objectArray = new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    @NonNull
    public final Game zza() {
        throw null;
    }

    static String zzc(Leaderboard leaderboard) {
        return Objects.toStringHelper((Object)leaderboard).add("LeaderboardId", (Object)leaderboard.getLeaderboardId()).add("DisplayName", (Object)leaderboard.getDisplayName()).add("IconImageUri", (Object)leaderboard.getIconImageUri()).add("IconImageUrl", (Object)leaderboard.getIconImageUrl()).add("ScoreOrder", (Object)leaderboard.getScoreOrder()).add("Variants", leaderboard.getVariants()).toString();
    }

    static boolean zzd(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        return Objects.equal((Object)(object = (Leaderboard)object).getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && Objects.equal((Object)object.getDisplayName(), (Object)leaderboard.getDisplayName()) && Objects.equal((Object)object.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && Objects.equal((Object)object.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && Objects.equal(object.getVariants(), leaderboard.getVariants());
    }
}

