/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.FriendsResolutionRequiredException;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesClientStatusCodes;
import com.google.android.gms.games.GamesStatusUtils;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzaa;
import com.google.android.gms.games.internal.zzab;
import com.google.android.gms.games.internal.zzac;
import com.google.android.gms.games.internal.zzag;
import com.google.android.gms.games.internal.zzai;
import com.google.android.gms.games.internal.zzak;
import com.google.android.gms.games.internal.zzal;
import com.google.android.gms.games.internal.zzan;
import com.google.android.gms.games.internal.zzap;
import com.google.android.gms.games.internal.zzar;
import com.google.android.gms.games.internal.zzas;
import com.google.android.gms.games.internal.zzat;
import com.google.android.gms.games.internal.zzau;
import com.google.android.gms.games.internal.zzav;
import com.google.android.gms.games.internal.zzbh;
import com.google.android.gms.games.internal.zzbi;
import com.google.android.gms.games.internal.zzbj;
import com.google.android.gms.games.internal.zzbk;
import com.google.android.gms.games.internal.zzbm;
import com.google.android.gms.games.internal.zzbn;
import com.google.android.gms.games.internal.zzbo;
import com.google.android.gms.games.internal.zzbp;
import com.google.android.gms.games.internal.zzbs;
import com.google.android.gms.games.internal.zzbt;
import com.google.android.gms.games.internal.zzbv;
import com.google.android.gms.games.internal.zzbw;
import com.google.android.gms.games.internal.zzcb;
import com.google.android.gms.games.internal.zzce;
import com.google.android.gms.games.internal.zzcf;
import com.google.android.gms.games.internal.zzcg;
import com.google.android.gms.games.internal.zzf;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzh;
import com.google.android.gms.games.internal.zzi;
import com.google.android.gms.games.internal.zzj;
import com.google.android.gms.games.internal.zzk;
import com.google.android.gms.games.internal.zzl;
import com.google.android.gms.games.internal.zzn;
import com.google.android.gms.games.internal.zzp;
import com.google.android.gms.games.internal.zzt;
import com.google.android.gms.games.internal.zzu;
import com.google.android.gms.games.internal.zzv;
import com.google.android.gms.games.internal.zzw;
import com.google.android.gms.games.internal.zzx;
import com.google.android.gms.games.internal.zzy;
import com.google.android.gms.games.internal.zzz;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.zzd;
import com.google.android.gms.internal.games.zzfo;
import com.google.android.gms.internal.games.zzft;
import com.google.android.gms.signin.internal.SignInClientImpl;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Locale;
import java.util.Set;

public final class zzbz
extends GmsClient {
    private final zzfo zzf;
    private final String zzg;
    private PlayerEntity zzh;
    private GameEntity zzi;
    private final zzcf zzj;
    private boolean zzk;
    private final long zzl;
    private final Games.GamesOptions zzm;
    private final zzcg zzn;
    public static final /* synthetic */ int zze;

    public final int zzp() throws RemoteException {
        return ((zzce)this.getService()).zzd();
    }

    public final int zzq() {
        try {
            int n = this.zzp();
            return n;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return -1;
        }
    }

    public final int zzr() throws RemoteException {
        return ((zzce)this.getService()).zze();
    }

    public final int zzs() {
        try {
            int n = this.zzr();
            return n;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return -1;
        }
    }

    public final int getMinApkVersion() {
        return 12451000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Intent zzt() {
        try {
            return ((zzce)this.getService()).zzg();
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    @Nullable
    public final Intent zzu() {
        try {
            zzbz zzbz2 = ((zzce)zzbz2.getService()).zzh();
            return zzbz2;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    public final Intent zzv() throws RemoteException {
        return ((zzce)this.getService()).zzo();
    }

    @Nullable
    public final Intent zzw() {
        try {
            zzbz zzbz2 = zzbz2.zzv();
            return zzbz2;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    @Nullable
    public final Intent zzx(PlayerEntity playerEntity) {
        try {
            zzbz zzbz2 = ((zzce)zzbz2.getService()).zzi(playerEntity);
            return zzbz2;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Intent zzy(String string, int n, int n2) {
        try {
            return ((zzce)this.getService()).zzk(string, n, n2);
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    public final Intent zzz() throws RemoteException {
        return ((zzce)this.getService()).zzl();
    }

    @Nullable
    public final Intent zzA() {
        try {
            zzbz zzbz2 = zzbz2.zzz();
            return zzbz2;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    public final Intent zzB(String string, boolean bl, boolean bl2, int n) throws RemoteException {
        return ((zzce)this.getService()).zzm(string, bl, bl2, n);
    }

    @Nullable
    public final Intent zzC(String string, boolean bl, boolean bl2, int n) {
        try {
            zzbz zzbz2 = zzbz2.zzB(string, bl, bl2, n);
            return zzbz2;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    @Nullable
    public final Bundle getConnectionHint() {
        return null;
    }

    protected final Bundle getGetServiceRequestExtraArgs() {
        Object object = this.getContext();
        object = object.getResources();
        object = object.getConfiguration();
        object = ((Configuration)object).locale;
        object = ((Locale)object).toString();
        Bundle bundle = this.zzm.zza();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzg);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", (String)object);
        object = new BinderWrapper(this.zzj.zzb());
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)object);
        if (!bundle.containsKey("com.google.android.gms.games.key.API_VERSION")) {
            bundle.putInt("com.google.android.gms.games.key.API_VERSION", 9);
        }
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", SignInClientImpl.createBundleFromClientSettings((ClientSettings)this.getClientSettings()));
        return bundle;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        void var0_2;
        void var1_6;
        if (var1_6 == null) {
            return var0_2;
        }
        IInterface iInterface = var1_6.queryLocalInterface("com.google.android.gms.games.internal.IGamesService");
        if (iInterface instanceof zzce) {
            zzce zzce2 = (zzce)iInterface;
            return var0_2;
        }
        zzce zzce3 = new zzce((IBinder)var1_6);
        return var0_2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Game zzD() throws RemoteException {
        this.checkConnected();
        synchronized (this) {
            Throwable throwable2;
            Object object;
            block9: {
                object = this.zzi;
                if (object == null) {
                    block8: {
                        object = new GameBuffer(((zzce)this.getService()).zzp());
                        try {
                            GameEntity gameEntity;
                            int n = object.getCount();
                            if (n <= 0) break block8;
                            Game game = ((GameBuffer)((Object)object)).get(0);
                            this.zzi = gameEntity = new GameEntity(game);
                        }
                        catch (Throwable throwable2) {
                            break block9;
                        }
                    }
                    object.release();
                }
                return this.zzi;
            }
            object.release();
            throw throwable2;
        }
    }

    @Nullable
    public final Game zzE() {
        try {
            Object object = object.zzD();
            return object;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Player zzF() throws RemoteException {
        this.checkConnected();
        synchronized (this) {
            Throwable throwable2;
            Object object;
            block9: {
                object = this.zzh;
                if (object == null) {
                    block8: {
                        object = new PlayerBuffer(((zzce)this.getService()).zzq());
                        try {
                            PlayerEntity playerEntity;
                            int n = object.getCount();
                            if (n <= 0) break block8;
                            Player player = ((PlayerBuffer)((Object)object)).get(0);
                            this.zzh = playerEntity = new PlayerEntity(player);
                        }
                        catch (Throwable throwable2) {
                            break block9;
                        }
                    }
                    object.release();
                }
                return this.zzh;
            }
            object.release();
            throw throwable2;
        }
    }

    @Nullable
    public final Player zzG() {
        try {
            Object object = object.zzF();
            return object;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    public final String zzH() throws RemoteException {
        return ((zzce)this.getService()).zzs();
    }

    @Nullable
    public final String zzI() {
        try {
            Object object = object.zzH();
            return object;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    public final String zzJ(boolean bl) throws RemoteException {
        PlayerEntity playerEntity = this.zzh;
        if (playerEntity != null) {
            return playerEntity.getPlayerId();
        }
        return ((zzce)this.getService()).zzt();
    }

    @Nullable
    public final String zzK(boolean bl) {
        try {
            Object object = object.zzJ(true);
            return object;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return null;
        }
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.games.service.START";
    }

    public final Set getScopesForConnectionlessNonSignIn() {
        return this.getScopes();
    }

    static /* bridge */ /* synthetic */ void zzL(zzbz zzbz2, TaskCompletionSource taskCompletionSource) {
        try {
            taskCompletionSource.setException((Exception)((Object)FriendsResolutionRequiredException.zza(GamesClientStatusCodes.zzb(26703, ((zzce)zzbz2.getService()).zzf()))));
            return;
        }
        catch (RemoteException remoteException) {
            taskCompletionSource.setException((Exception)((Object)remoteException));
            return;
        }
    }

    static /* bridge */ /* synthetic */ void zzM(RemoteException remoteException) {
        zzbz.zzbf(remoteException);
    }

    public zzbz(Context context, Looper object, ClientSettings clientSettings, Games.GamesOptions gamesOptions, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener, zzcg zzcg2) {
        super(context, object, 1, clientSettings, connectionCallbacks, onConnectionFailedListener);
        super(this);
        this.zzf = object;
        this.zzk = false;
        this.zzg = clientSettings.getRealClientPackageName();
        this.zzn = (zzcg)Preconditions.checkNotNull((Object)zzcg2);
        this.zzj = zzcf.zzc(this, clientSettings.getGravityForPopups());
        this.zzl = ((Object)((Object)this)).hashCode();
        this.zzm = gamesOptions;
        boolean cfr_ignored_0 = this.zzm.zzh;
        if (clientSettings.getViewForPopups() != null || context instanceof Activity) {
            context = clientSettings.getViewForPopups();
            this.zzj.zze((View)context);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void zzN() {
        if (!this.isConnected()) return;
        try {
            ((zzce)this.getService()).zzu();
            return;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return;
        }
    }

    public final void zzO(BaseImplementation.ResultHolder resultHolder, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        Object object = snapshot.getSnapshotContents();
        Preconditions.checkState((boolean)(object.isClosed() ^ true), (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zza();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(zzce2.getContext().getCacheDir());
        }
        bitmapTeleporter = object.zza();
        object.zzb();
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            object = new zzh(resultHolder);
            zzce2.zzw((zzcb)object, snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, (Contents)bitmapTeleporter);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzP(TaskCompletionSource taskCompletionSource, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        Object object = snapshot.getSnapshotContents();
        Preconditions.checkState((boolean)(object.isClosed() ^ true), (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zza();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(zzce2.getContext().getCacheDir());
        }
        bitmapTeleporter = object.zza();
        object.zzb();
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            object = new zzag(taskCompletionSource);
            zzce2.zzw((zzcb)object, snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, (Contents)bitmapTeleporter);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void connect(BaseGmsClient.ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        this.zzh = null;
        this.zzi = null;
        super.connect(connectionProgressReportCallbacks);
    }

    public final void zzQ(BaseImplementation.ResultHolder resultHolder, String string) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzi zzi2 = new zzi(resultHolder);
            zzce2.zzx(zzi2, string);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzR(TaskCompletionSource taskCompletionSource, String string) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzai zzai2 = new zzai(taskCompletionSource);
            zzce2.zzx(zzai2, string);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzS(Snapshot object) throws RemoteException {
        object = object.getSnapshotContents();
        Preconditions.checkState((boolean)(object.isClosed() ^ true), (Object)"Snapshot already closed");
        Contents contents = object.zza();
        object.zzb();
        ((zzce)this.getService()).zzy(contents);
    }

    public final void zzT(Snapshot snapshot) {
        try {
            this.zzS(snapshot);
            return;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void disconnect() {
        this.zzk = false;
        if (this.isConnected()) {
            try {
                this.zzf.zzb();
                ((zzce)this.getService()).zzv(this.zzl);
            }
            catch (RemoteException remoteException) {
                zzft.zzd("GamesGmsClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    public final void zzU(BaseImplementation.ResultHolder resultHolder) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzj zzj2 = new zzj(resultHolder);
            zzce2.zzB(zzj2);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzV(TaskCompletionSource taskCompletionSource) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbk zzbk2 = new zzbk(taskCompletionSource);
            zzce2.zzB(zzbk2);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzW(BaseImplementation.ResultHolder resultHolder) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzk zzk2 = new zzk(resultHolder);
            zzce2.zzz(zzk2);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzX(TaskCompletionSource taskCompletionSource) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbh zzbh2 = new zzbh(taskCompletionSource);
            zzce2.zzz(zzbh2);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzY(TaskCompletionSource taskCompletionSource, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbp zzbp2 = new zzbp(taskCompletionSource);
            zzce2.zzQ(zzbp2, null, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzZ(BaseImplementation.ResultHolder resultHolder, String string, int n) throws RemoteException {
        zzz zzz2 = resultHolder == null ? null : new zzz(resultHolder);
        try {
            ((zzce)this.getService()).zzC(zzz2, string, n, this.zzj.zzb(), this.zzj.zza());
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzaa(@Nullable TaskCompletionSource taskCompletionSource, String string, int n) throws RemoteException {
        zzaa zzaa2 = taskCompletionSource == null ? null : new zzaa(taskCompletionSource);
        try {
            ((zzce)this.getService()).zzC(zzaa2, string, n, this.zzj.zzb(), this.zzj.zza());
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzab(String string, int n) {
        this.zzf.zzc(string, n);
    }

    public final void zzac(BaseImplementation.ResultHolder resultHolder, int n) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzl zzl2 = new zzl(resultHolder);
            zzce2.zzE(zzl2, n);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzad(TaskCompletionSource taskCompletionSource, int n) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbj zzbj2 = new zzbj(taskCompletionSource);
            zzce2.zzE(zzbj2, n);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzae(BaseImplementation.ResultHolder resultHolder, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzv zzv2 = new zzv(resultHolder);
            zzce2.zzF(zzv2, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaf(TaskCompletionSource taskCompletionSource, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzac zzac2 = new zzac(taskCompletionSource);
            zzce2.zzF(zzac2, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzag(BaseImplementation.ResultHolder resultHolder, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbn zzbn2 = new zzbn(resultHolder);
            zzce2.zzG(zzbn2, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzah(TaskCompletionSource taskCompletionSource, String string, int n, int n2) throws RemoteException {
        try {
            zzce zzce2 = (zzce)this.getService();
            zzar zzar2 = new zzar(this, taskCompletionSource);
            zzce2.zzA(zzar2, null, string, n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzai(BaseImplementation.ResultHolder resultHolder, boolean bl) throws RemoteException {
        ((zzbz)((Object)zzce2)).zzf.zzb();
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzak zzak2 = new zzak(resultHolder);
            zzce2.zzH(zzak2, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaj(TaskCompletionSource taskCompletionSource, boolean bl) throws RemoteException {
        ((zzbz)((Object)zzce2)).zzf.zzb();
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzal zzal2 = new zzal(taskCompletionSource);
            zzce2.zzH(zzal2, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzak(BaseImplementation.ResultHolder resultHolder, boolean bl, String ... stringArray) throws RemoteException {
        ((zzbz)((Object)zzce2)).zzf.zzb();
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzak zzak2 = new zzak(resultHolder);
            zzce2.zzI(zzak2, bl, stringArray);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzal(TaskCompletionSource taskCompletionSource, boolean bl, String ... stringArray) throws RemoteException {
        ((zzbz)((Object)zzce2)).zzf.zzb();
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzal zzal2 = new zzal(taskCompletionSource);
            zzce2.zzI(zzal2, bl, stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzam(BaseImplementation.ResultHolder resultHolder) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzw zzw2 = new zzw(resultHolder);
            zzce2.zzJ(zzw2);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzan(TaskCompletionSource taskCompletionSource) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzan zzan2 = new zzan(taskCompletionSource);
            zzce2.zzJ(zzan2);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzao(BaseImplementation.ResultHolder resultHolder, int n, boolean bl, boolean bl2) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbn zzbn2 = new zzbn(resultHolder);
            zzce2.zzK(zzbn2, n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzap(BaseImplementation.ResultHolder resultHolder, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzau zzau2 = new zzau(resultHolder);
            zzce2.zzM(zzau2, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaq(BaseImplementation.ResultHolder resultHolder, String string, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzau zzau2 = new zzau(resultHolder);
            zzce2.zzL(zzau2, string, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzar(TaskCompletionSource taskCompletionSource, String string, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzap zzap2 = new zzap(taskCompletionSource);
            zzce2.zzL(zzap2, string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzas(TaskCompletionSource taskCompletionSource, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzav zzav2 = new zzav(taskCompletionSource);
            zzce2.zzM(zzav2, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzat(BaseImplementation.ResultHolder resultHolder, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzas zzas2 = new zzas(resultHolder);
            zzce2.zzN(zzas2, leaderboardScoreBuffer.zza().zza(), n, n2);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzau(TaskCompletionSource taskCompletionSource, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        try {
            zzce zzce2 = (zzce)this.getService();
            zzat zzat2 = new zzat(this, taskCompletionSource);
            zzce2.zzN(zzat2, leaderboardScoreBuffer.zza().zza(), n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzav(BaseImplementation.ResultHolder resultHolder, String string, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbn zzbn2 = new zzbn(resultHolder);
            zzce2.zzQ(zzbn2, string, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaw(TaskCompletionSource taskCompletionSource, String string, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbp zzbp2 = new zzbp(taskCompletionSource);
            zzce2.zzQ(zzbp2, string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzax(BaseImplementation.ResultHolder resultHolder, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzas zzas2 = new zzas(resultHolder);
            zzce2.zzO(zzas2, string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzay(TaskCompletionSource taskCompletionSource, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)this.getService();
            zzat zzat2 = new zzat(this, taskCompletionSource);
            zzce2.zzO(zzat2, string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzaz(BaseImplementation.ResultHolder resultHolder, String object, String string, int n, int n2) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            object = new zzt(resultHolder);
            zzce2.zzA((zzcb)object, null, string, n, n2);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaA(BaseImplementation.ResultHolder resultHolder, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzg zzg2 = new zzg(resultHolder);
            zzce2.zzP(zzg2, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaB(TaskCompletionSource taskCompletionSource, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbm zzbm2 = new zzbm(taskCompletionSource);
            zzce2.zzP(zzbm2, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzaC(BaseImplementation.ResultHolder resultHolder, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        string = "played_with";
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbn zzbn2 = new zzbn(resultHolder);
            zzce2.zzR(zzbn2, string, n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzaD(TaskCompletionSource taskCompletionSource, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        Object object;
        if (!string.equals("played_with") && !string.equals("friends_all")) {
            object = new IllegalArgumentException("Invalid player collection: ".concat(string));
            throw object;
        }
        try {
            zzce zzce2 = (zzce)object.getService();
            zzbo zzbo2 = new zzbo((zzbz)((Object)object), taskCompletionSource);
            zzce2.zzR(zzbo2, string, n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzaE(BaseImplementation.ResultHolder resultHolder, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbw zzbw2 = new zzbw(resultHolder);
            zzce2.zzS(zzbw2, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaF(TaskCompletionSource taskCompletionSource, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbi zzbi2 = new zzbi(taskCompletionSource);
            zzce2.zzS(zzbi2, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzaG(BaseImplementation.ResultHolder resultHolder, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzas zzas2 = new zzas(resultHolder);
            zzce2.zzT(zzas2, string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaH(TaskCompletionSource taskCompletionSource, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            zzce zzce2 = (zzce)this.getService();
            zzat zzat2 = new zzat(this, taskCompletionSource);
            zzce2.zzT(zzat2, string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzk = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0) {
            if (bundle != null) {
                bundle.setClassLoader(zzbz.class.getClassLoader());
                this.zzk = bundle.getBoolean("show_welcome_popup");
                this.zzh = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
                this.zzi = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
                n = 0;
            } else {
                n = 0;
            }
        }
        super.onPostInitHandler(n, iBinder, bundle, n2);
    }

    public final void onUserSignOut(@NonNull BaseGmsClient.SignOutCallbacks signOutCallbacks) {
        try {
            zzx zzx2 = new zzx(signOutCallbacks);
            this.zzaV(zzx2);
            return;
        }
        catch (RemoteException remoteException) {
            signOutCallbacks.onSignOutComplete();
            return;
        }
    }

    public final void zzaI(BaseImplementation.ResultHolder resultHolder, String string, boolean bl, int n) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbt zzbt2 = new zzbt(resultHolder);
            zzce2.zzU(zzbt2, string, bl, n);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaJ(TaskCompletionSource taskCompletionSource, String string, boolean bl, int n) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbv zzbv2 = new zzbv(taskCompletionSource);
            zzce2.zzU(zzbv2, string, bl, n);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    private static void zzbf(RemoteException remoteException) {
        zzft.zze("GamesGmsClientImpl", "service died", remoteException);
    }

    public final void zzaK(ListenerHolder listenerHolder) {
        try {
            IInterface iInterface = this.getService();
            iInterface = (zzce)iInterface;
            zzp zzp2 = new zzp(listenerHolder);
            iInterface.zzV(zzp2, this.zzl);
            return;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return;
        }
    }

    public final void zzaL(ListenerHolder listenerHolder) throws RemoteException {
        IInterface iInterface = this.getService();
        iInterface = (zzce)iInterface;
        zzn zzn2 = new zzn(listenerHolder);
        iInterface.zzV(zzn2, this.zzl);
    }

    public final void zzaM(BaseImplementation.ResultHolder resultHolder, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents object) throws RemoteException {
        Preconditions.checkState((boolean)(object.isClosed() ^ true), (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zza();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(zzce2.getContext().getCacheDir());
        }
        bitmapTeleporter = object.zza();
        object.zzb();
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            object = new zzbt(resultHolder);
            zzce2.zzX((zzcb)object, string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, (Contents)bitmapTeleporter);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaN(TaskCompletionSource taskCompletionSource, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents object) throws RemoteException {
        Preconditions.checkState((boolean)(object.isClosed() ^ true), (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zza();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(zzce2.getContext().getCacheDir());
        }
        bitmapTeleporter = object.zza();
        object.zzb();
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            object = new zzbv(taskCompletionSource);
            zzce2.zzX((zzcb)object, string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, (Contents)bitmapTeleporter);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzaO(BaseImplementation.ResultHolder resultHolder, String string) throws RemoteException {
        zzz zzz2 = resultHolder == null ? null : new zzz(resultHolder);
        try {
            ((zzce)this.getService()).zzY(zzz2, string, this.zzj.zzb(), this.zzj.zza());
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzaP(@Nullable TaskCompletionSource taskCompletionSource, String string) throws RemoteException {
        zzab zzab2 = taskCompletionSource == null ? null : new zzab(taskCompletionSource);
        try {
            ((zzce)this.getService()).zzY(zzab2, string, this.zzj.zzb(), this.zzj.zza());
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzaQ(BaseImplementation.ResultHolder resultHolder, String string, int n) throws RemoteException {
        zzz zzz2 = resultHolder == null ? null : new zzz(resultHolder);
        try {
            ((zzce)this.getService()).zzZ(zzz2, string, n, this.zzj.zzb(), this.zzj.zza());
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzaR(@Nullable TaskCompletionSource taskCompletionSource, String string, int n) throws RemoteException {
        zzaa zzaa2 = taskCompletionSource == null ? null : new zzaa(taskCompletionSource);
        try {
            ((zzce)this.getService()).zzZ(zzaa2, string, n, this.zzj.zzb(), this.zzj.zza());
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzaS(int n) {
        this.zzj.zzf(n);
    }

    public final void zzaT(View view) {
        this.zzj.zze(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void zzaU(IBinder iBinder, Bundle bundle) {
        if (!this.isConnected()) return;
        zzf cfr_ignored_0 = this.zzm.zzo;
        try {
            ((zzce)this.getService()).zzaa(iBinder, bundle);
            this.zzn.zzb();
            return;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return;
        }
    }

    public final void zzaV(BaseImplementation.ResultHolder resultHolder) throws RemoteException {
        ((zzbz)((Object)zzce2)).zzf.zzb();
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzy zzy2 = new zzy(resultHolder);
            zzce2.zzab(zzy2);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaW(String string, long l, @Nullable String string2) throws RemoteException {
        try {
            ((zzce)this.getService()).zzac(null, string, l, string2);
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzaX(BaseImplementation.ResultHolder resultHolder, String string, long l, String string2) throws RemoteException {
        zzu zzu2 = resultHolder == null ? null : new zzu(resultHolder);
        try {
            ((zzce)this.getService()).zzac(zzu2, string, l, string2);
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    public final void zzaY(TaskCompletionSource taskCompletionSource, String string, long l, @Nullable String string2) throws RemoteException {
        try {
            zzce zzce2 = (zzce)zzce2.getService();
            zzbs zzbs2 = new zzbs(taskCompletionSource);
            zzce2.zzac(zzbs2, string, l, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    private static void zzbg(BaseImplementation.ResultHolder resultHolder, SecurityException securityException) {
        if (resultHolder != null) {
            resultHolder.setFailedResult(GamesClientStatusCodes.zza(4));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzaZ(BaseImplementation.ResultHolder resultHolder, String string) throws RemoteException {
        zzz zzz2 = resultHolder == null ? null : new zzz(resultHolder);
        try {
            ((zzce)this.getService()).zzad(zzz2, string, this.zzj.zzb(), this.zzj.zza());
            return;
        }
        catch (SecurityException securityException) {
            zzbz.zzbg(resultHolder, securityException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzba(@Nullable TaskCompletionSource taskCompletionSource, String string) throws RemoteException {
        zzab zzab2 = taskCompletionSource == null ? null : new zzab(taskCompletionSource);
        try {
            ((zzce)this.getService()).zzad(zzab2, string, this.zzj.zzb(), this.zzj.zza());
            return;
        }
        catch (SecurityException securityException) {
            GamesStatusUtils.zzb(taskCompletionSource, securityException);
            return;
        }
    }

    public final void zzbb() throws RemoteException {
        ((zzce)this.getService()).zzae(this.zzl);
    }

    public final void zzbc() {
        try {
            this.zzbb();
            return;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return;
        }
    }

    public final boolean zzbd() throws RemoteException {
        return ((zzce)this.getService()).zzaf();
    }

    public final boolean zzbe() {
        try {
            boolean bl = this.zzbd();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzbz.zzbf(remoteException);
            return false;
        }
    }

    public final boolean requiresAccount() {
        return true;
    }

    public final boolean requiresSignIn() {
        Object object = object.zzm;
        return true;
    }

    public final boolean usesClientTelemetry() {
        return true;
    }

    public final Feature[] getApiFeatures() {
        return zzd.zzf;
    }
}

