/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.experience;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.experience.ExperienceEvent;
import com.google.android.gms.games.internal.experience.zza;
import com.google.android.gms.games.internal.zzc;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ExperienceEventEntityCreator")
@UsedByReflection(value="GamesGmsClientImpl.java")
public final class ExperienceEventEntity
extends zzc
implements ExperienceEvent {
    @NonNull
    public static final Parcelable.Creator<ExperienceEventEntity> CREATOR;
    @SafeParcelable.Field(id=1, getter="getExperienceId")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getGame")
    private final GameEntity zzb;
    @SafeParcelable.Field(id=3, getter="getDisplayTitle")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getDisplayDescription")
    private final String zzd;
    @SafeParcelable.Field(id=5, getter="getIconImageUrl")
    private final String zze;
    @SafeParcelable.Field(id=6, getter="getIconImageUri")
    private final Uri zzf;
    @SafeParcelable.Field(id=7, getter="getCreatedTimestamp")
    private final long zzg;
    @SafeParcelable.Field(id=8, getter="getXpEarned")
    private final long zzh;
    @SafeParcelable.Field(id=9, getter="getCurrentXp")
    private final long zzi;
    @SafeParcelable.Field(id=10, getter="getType")
    private final int zzj;
    @SafeParcelable.Field(id=11, getter="getNewLevel")
    private final int zzk;

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.getIconImageUrl(), this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    @NonNull
    public String getIconImageUrl() {
        return this.zze;
    }

    @NonNull
    public final String toString() {
        return Objects.toStringHelper((Object)this).add("ExperienceId", (Object)this.zza).add("Game", (Object)this.zzb).add("DisplayTitle", (Object)this.zzc).add("DisplayDescription", (Object)this.zzd).add("IconImageUrl", (Object)this.getIconImageUrl()).add("IconImageUri", (Object)this.zzf).add("CreatedTimestamp", (Object)this.zzg).add("XpEarned", (Object)this.zzh).add("CurrentXp", (Object)this.zzi).add("Type", (Object)this.zzj).add("NewLevel", (Object)this.zzk).toString();
    }

    static {
        zza zza2;
        CREATOR = zza2 = new zza();
    }

    @SafeParcelable.Constructor
    ExperienceEventEntity(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) GameEntity gameEntity, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) Uri uri, @SafeParcelable.Param(id=7) long l, @SafeParcelable.Param(id=8) long l2, @SafeParcelable.Param(id=9) long l3, @SafeParcelable.Param(id=10) int n, @SafeParcelable.Param(id=11) int n2) {
        this.zza = string;
        this.zzb = gameEntity;
        this.zzc = string2;
        this.zzd = string3;
        this.zze = string4;
        this.zzf = uri;
        this.zzg = l;
        this.zzh = l2;
        this.zzi = l3;
        this.zzj = n;
        this.zzk = n2;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)2, (Parcelable)this.zzb, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.getIconImageUrl(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)6, (Parcelable)this.zzf, (int)n, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)7, (long)this.zzg);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)8, (long)this.zzh);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)9, (long)this.zzi);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)10, (int)this.zzj);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)11, (int)this.zzk);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Object object) {
        if (!(object instanceof ExperienceEvent)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!Objects.equal((Object)(object = (ExperienceEvent)object).zzj(), (Object)this.zza)) return false;
        if (!Objects.equal((Object)object.zzg(), (Object)this.zzb)) return false;
        if (!Objects.equal((Object)object.zzi(), (Object)this.zzc)) return false;
        if (!Objects.equal((Object)object.zzh(), (Object)this.zzd)) return false;
        if (!Objects.equal((Object)object.getIconImageUrl(), (Object)this.getIconImageUrl())) return false;
        if (!Objects.equal((Object)object.zzf(), (Object)this.zzf)) return false;
        if (!Objects.equal((Object)object.zzc(), (Object)this.zzg)) return false;
        if (!Objects.equal((Object)object.zze(), (Object)this.zzh)) return false;
        if (!Objects.equal((Object)object.zzd(), (Object)this.zzi)) return false;
        if (!Objects.equal((Object)object.zzb(), (Object)this.zzj)) return false;
        if (Objects.equal((Object)object.zza(), (Object)this.zzk)) return true;
        return false;
    }

    public final boolean isDataValid() {
        return true;
    }

    @Override
    public final int zza() {
        return this.zzk;
    }

    @Override
    public final int zzb() {
        return this.zzj;
    }

    @Override
    public final long zzc() {
        return this.zzg;
    }

    @Override
    public final long zzd() {
        return this.zzi;
    }

    @Override
    public final long zze() {
        return this.zzh;
    }

    @Override
    @NonNull
    public final Uri zzf() {
        return this.zzf;
    }

    @Override
    @NonNull
    public final Game zzg() {
        return this.zzb;
    }

    @Override
    @NonNull
    public final String zzh() {
        return this.zzd;
    }

    @Override
    @NonNull
    public final String zzi() {
        return this.zzc;
    }

    @Override
    @NonNull
    public final String zzj() {
        return this.zza;
    }
}

