/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DataUtils;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.zza;
import com.google.android.gms.games.internal.zzc;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="EventEntityCreator")
@UsedByReflection(value="GamesGmsClientImpl.java")
public final class EventEntity
extends zzc
implements Event {
    @NonNull
    public static final Parcelable.Creator<EventEntity> CREATOR;
    @SafeParcelable.Field(id=1, getter="getEventId")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getName")
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getDescription")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getIconImageUri")
    private final Uri zzd;
    @SafeParcelable.Field(id=5, getter="getIconImageUrl")
    private final String zze;
    @SafeParcelable.Field(id=6, getter="getPlayer")
    private final PlayerEntity zzf;
    @SafeParcelable.Field(id=7, getter="getValue")
    private final long zzg;
    @SafeParcelable.Field(id=8, getter="getFormattedValue")
    private final String zzh;
    @SafeParcelable.Field(id=9, getter="isVisible")
    private final boolean zzi;

    public int hashCode() {
        return EventEntity.zza(this);
    }

    @Override
    public long getValue() {
        return this.zzg;
    }

    @Override
    @NonNull
    public Uri getIconImageUri() {
        return this.zzd;
    }

    @Override
    @NonNull
    public Player getPlayer() {
        return this.zzf;
    }

    @NonNull
    public Event freeze() {
        return this;
    }

    @Override
    @NonNull
    public String getDescription() {
        return this.zzc;
    }

    @Override
    @NonNull
    public String getEventId() {
        return this.zza;
    }

    @Override
    @NonNull
    public String getFormattedValue() {
        return this.zzh;
    }

    @Override
    @NonNull
    public String getIconImageUrl() {
        return this.zze;
    }

    @Override
    @NonNull
    public String getName() {
        return this.zzb;
    }

    @NonNull
    public String toString() {
        return EventEntity.zzb(this);
    }

    static {
        zza zza2;
        CREATOR = zza2 = new zza();
    }

    /*
     * WARNING - void declaration
     */
    public EventEntity(@NonNull Event event) {
        void var1_1;
        this.zza = var1_1.getEventId();
        this.zzb = var1_1.getName();
        this.zzc = var1_1.getDescription();
        this.zzd = var1_1.getIconImageUri();
        this.zze = var1_1.getIconImageUrl();
        this.zzf = (PlayerEntity)var1_1.getPlayer().freeze();
        this.zzg = var1_1.getValue();
        this.zzh = var1_1.getFormattedValue();
        this.zzi = var1_1.isVisible();
    }

    @SafeParcelable.Constructor
    EventEntity(@SafeParcelable.Param(id=1) String object, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Uri uri, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Player player, @SafeParcelable.Param(id=7) long l, @SafeParcelable.Param(id=8) String string4, @SafeParcelable.Param(id=9) boolean bl) {
        this.zza = object;
        this.zzb = string;
        this.zzc = string2;
        this.zzd = uri;
        this.zze = string3;
        this.zzf = object = new PlayerEntity(player);
        this.zzg = l;
        this.zzh = string4;
        this.zzi = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getDescription(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzc, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getFormattedValue(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzh, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getName(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzb, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getEventId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getDescription(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.getIconImageUri(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getIconImageUrl(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.getPlayer(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)7, (long)this.getValue());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.getFormattedValue(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.isVisible());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        void var1_1;
        return EventEntity.zzc(this, var1_1);
    }

    public boolean isDataValid() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return this.zzi;
    }

    static int zza(Event event) {
        Object[] objectArray = new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()};
        return Objects.hashCode((Object[])objectArray);
    }

    static String zzb(Event event) {
        return Objects.toStringHelper((Object)event).add("Id", (Object)event.getEventId()).add("Name", (Object)event.getName()).add("Description", (Object)event.getDescription()).add("IconImageUri", (Object)event.getIconImageUri()).add("IconImageUrl", (Object)event.getIconImageUrl()).add("Player", (Object)event.getPlayer()).add("Value", (Object)event.getValue()).add("FormattedValue", (Object)event.getFormattedValue()).add("isVisible", (Object)event.isVisible()).toString();
    }

    static boolean zzc(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        return Objects.equal((Object)(object = (Event)object).getEventId(), (Object)event.getEventId()) && Objects.equal((Object)object.getName(), (Object)event.getName()) && Objects.equal((Object)object.getDescription(), (Object)event.getDescription()) && Objects.equal((Object)object.getIconImageUri(), (Object)event.getIconImageUri()) && Objects.equal((Object)object.getIconImageUrl(), (Object)event.getIconImageUrl()) && Objects.equal((Object)object.getPlayer(), (Object)event.getPlayer()) && Objects.equal((Object)object.getValue(), (Object)event.getValue()) && Objects.equal((Object)object.getFormattedValue(), (Object)event.getFormattedValue()) && Objects.equal((Object)object.isVisible(), (Object)event.isVisible());
    }
}

