/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.data.DataBufferRef;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntity;

public final class AchievementRef
extends DataBufferRef
implements Achievement {
    public final int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final int getCurrentSteps() {
        boolean bl = this.getInteger("type") == 1;
        Asserts.checkState((boolean)bl);
        return this.getInteger("current_steps");
    }

    @Override
    public final int getState() {
        return this.getInteger("state");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final int getTotalSteps() {
        boolean bl = this.getInteger("type") == 1;
        Asserts.checkState((boolean)bl);
        return this.getInteger("total_steps");
    }

    @Override
    public final int getType() {
        return this.getInteger("type");
    }

    public final int hashCode() {
        return AchievementEntity.zzd(this);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.getLong("last_updated_timestamp");
    }

    @Override
    public final long getXpValue() {
        if (!this.hasColumn("instance_xp_value") || this.hasNull("instance_xp_value")) {
            return this.getLong("definition_xp_value");
        }
        return this.getLong("instance_xp_value");
    }

    @Override
    @NonNull
    public final Uri getRevealedImageUri() {
        return this.parseUri("revealed_icon_image_uri");
    }

    @Override
    @NonNull
    public final Uri getUnlockedImageUri() {
        return this.parseUri("unlocked_icon_image_uri");
    }

    @Override
    @NonNull
    public final Player getPlayer() {
        return (Player)Preconditions.checkNotNull((Object)this.zzb());
    }

    @NonNull
    public final /* synthetic */ Object freeze() {
        AchievementEntity achievementEntity = new AchievementEntity(this);
        return achievementEntity;
    }

    @Override
    @NonNull
    public final String getAchievementId() {
        return this.getString("external_achievement_id");
    }

    @Override
    @NonNull
    public final String getDescription() {
        return this.getString("description");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NonNull
    public final String getFormattedCurrentSteps() {
        boolean bl = this.getInteger("type") == 1;
        Asserts.checkState((boolean)bl);
        return this.getString("formatted_current_steps");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NonNull
    public final String getFormattedTotalSteps() {
        boolean bl = this.getInteger("type") == 1;
        Asserts.checkState((boolean)bl);
        return this.getString("formatted_total_steps");
    }

    @Override
    @NonNull
    public final String getName() {
        return this.getString("name");
    }

    @Override
    @NonNull
    public String getRevealedImageUrl() {
        return this.getString("revealed_icon_image_url");
    }

    @Override
    @NonNull
    public String getUnlockedImageUrl() {
        return this.getString("unlocked_icon_image_url");
    }

    @NonNull
    public final String toString() {
        return AchievementEntity.zze(this);
    }

    AchievementRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
    }

    @Override
    public final void getDescription(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer("description", charArrayBuffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void getFormattedCurrentSteps(@NonNull CharArrayBuffer charArrayBuffer) {
        boolean bl = this.getInteger("type") == 1;
        Asserts.checkState((boolean)bl);
        this.copyToBuffer("formatted_current_steps", charArrayBuffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void getFormattedTotalSteps(@NonNull CharArrayBuffer charArrayBuffer) {
        boolean bl = this.getInteger("type") == 1;
        Asserts.checkState((boolean)bl);
        this.copyToBuffer("formatted_total_steps", charArrayBuffer);
    }

    @Override
    public final void getName(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer("name", charArrayBuffer);
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        AchievementEntity achievementEntity = new AchievementEntity(this);
        achievementEntity.writeToParcel(parcel, n);
    }

    public final boolean equals(@Nullable Object object) {
        return AchievementEntity.zzf(this, object);
    }

    @Override
    public final float zza() {
        if (!this.hasColumn("rarity_percent") || this.hasNull("rarity_percent")) {
            return -1.0f;
        }
        return this.getFloat("rarity_percent");
    }

    @Override
    @Nullable
    public final Player zzb() {
        if (this.hasNull("external_player_id")) {
            return null;
        }
        PlayerRef playerRef = new PlayerRef(this.mDataHolder, this.mDataRow, null);
        return playerRef;
    }

    @Override
    @NonNull
    public final String zzc() {
        return this.getString("external_game_id");
    }
}

