/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DataUtils;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="AchievementEntityCreator")
@UsedByReflection(value="GamesGmsClientImpl.java")
public final class AchievementEntity
extends zzc
implements Achievement {
    @NonNull
    public static final Parcelable.Creator<AchievementEntity> CREATOR;
    @SafeParcelable.Field(id=1, getter="getAchievementId")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getType")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getName")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getDescription")
    private final String zzd;
    @SafeParcelable.Field(id=5, getter="getUnlockedImageUri")
    @Nullable
    private final Uri zze;
    @SafeParcelable.Field(id=6, getter="getUnlockedImageUrl")
    @Nullable
    private final String zzf;
    @SafeParcelable.Field(id=7, getter="getRevealedImageUri")
    @Nullable
    private final Uri zzg;
    @SafeParcelable.Field(id=8, getter="getRevealedImageUrl")
    @Nullable
    private final String zzh;
    @SafeParcelable.Field(id=9, getter="getTotalStepsRaw")
    private final int zzi;
    @SafeParcelable.Field(id=10, getter="getFormattedTotalStepsRaw")
    @Nullable
    private final String zzj;
    @SafeParcelable.Field(id=11, getter="getPlayerInternal")
    @Nullable
    private final PlayerEntity zzk;
    @SafeParcelable.Field(id=12, getter="getState")
    private final int zzl;
    @SafeParcelable.Field(id=13, getter="getCurrentStepsRaw")
    private final int zzm;
    @SafeParcelable.Field(id=14, getter="getFormattedCurrentStepsRaw")
    @Nullable
    private final String zzn;
    @SafeParcelable.Field(id=15, getter="getLastUpdatedTimestamp")
    private final long zzo;
    @SafeParcelable.Field(id=16, getter="getXpValue")
    private final long zzp;
    @SafeParcelable.Field(id=17, getter="getRarityPercent", defaultValue="-1.0f")
    private final float zzq;
    @SafeParcelable.Field(id=18, getter="getApplicationId")
    private final String zzr;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getCurrentSteps() {
        boolean bl = this.getType() == 1;
        Asserts.checkState((boolean)bl);
        return this.zzm;
    }

    @Override
    public int getState() {
        return this.zzl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getTotalSteps() {
        boolean bl = this.getType() == 1;
        Asserts.checkState((boolean)bl);
        return this.zzi;
    }

    @Override
    public int getType() {
        return this.zzb;
    }

    public int hashCode() {
        return AchievementEntity.zzd(this);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzo;
    }

    @Override
    public long getXpValue() {
        return this.zzp;
    }

    @Override
    @Nullable
    public Uri getRevealedImageUri() {
        return this.zzg;
    }

    @Override
    @Nullable
    public Uri getUnlockedImageUri() {
        return this.zze;
    }

    @Override
    @NonNull
    public Player getPlayer() {
        return (Player)Preconditions.checkNotNull((Object)this.zzk);
    }

    @NonNull
    public Achievement freeze() {
        return this;
    }

    @Override
    @NonNull
    public String getAchievementId() {
        return this.zza;
    }

    @Override
    @NonNull
    public String getDescription() {
        return this.zzd;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public String getFormattedCurrentSteps() {
        boolean bl = this.getType() == 1;
        Asserts.checkState((boolean)bl);
        return this.zzn;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public String getFormattedTotalSteps() {
        boolean bl = this.getType() == 1;
        Asserts.checkState((boolean)bl);
        return this.zzj;
    }

    @Override
    @NonNull
    public String getName() {
        return this.zzc;
    }

    @Override
    @Nullable
    public String getRevealedImageUrl() {
        return this.zzh;
    }

    @Override
    @Nullable
    public String getUnlockedImageUrl() {
        return this.zzf;
    }

    @NonNull
    public String toString() {
        return AchievementEntity.zze(this);
    }

    static {
        zza zza2;
        CREATOR = zza2 = new zza();
    }

    /*
     * Enabled aggressive block sorting
     */
    public AchievementEntity(@NonNull Achievement achievement) {
        PlayerEntity playerEntity;
        this.zza = achievement.getAchievementId();
        this.zzb = achievement.getType();
        this.zzc = achievement.getName();
        this.zzd = achievement.getDescription();
        this.zze = achievement.getUnlockedImageUri();
        this.zzf = achievement.getUnlockedImageUrl();
        this.zzg = achievement.getRevealedImageUri();
        this.zzh = achievement.getRevealedImageUrl();
        Player player = achievement.zzb();
        this.zzk = player != null ? (playerEntity = new PlayerEntity(player)) : null;
        this.zzl = achievement.getState();
        this.zzo = achievement.getLastUpdatedTimestamp();
        this.zzp = achievement.getXpValue();
        this.zzq = achievement.zza();
        this.zzr = achievement.zzc();
        if (achievement.getType() == 1) {
            this.zzi = achievement.getTotalSteps();
            this.zzj = achievement.getFormattedTotalSteps();
            this.zzm = achievement.getCurrentSteps();
            this.zzn = achievement.getFormattedCurrentSteps();
        } else {
            this.zzi = 0;
            this.zzj = null;
            this.zzm = 0;
            this.zzn = null;
        }
        Asserts.checkNotNull((Object)this.zza);
        Asserts.checkNotNull((Object)this.zzd);
    }

    @SafeParcelable.Constructor
    AchievementEntity(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) Uri uri, @SafeParcelable.Param(id=6) String string4, @SafeParcelable.Param(id=7) Uri uri2, @SafeParcelable.Param(id=8) String string5, @SafeParcelable.Param(id=9) int n2, @SafeParcelable.Param(id=10) String string6, @SafeParcelable.Param(id=11) @Nullable PlayerEntity playerEntity, @SafeParcelable.Param(id=12) int n3, @SafeParcelable.Param(id=13) int n4, @SafeParcelable.Param(id=14) String string7, @SafeParcelable.Param(id=15) long l, @SafeParcelable.Param(id=16) long l2, @SafeParcelable.Param(id=17) float f, @SafeParcelable.Param(id=18) String string8) {
        this.zza = string;
        this.zzb = n;
        this.zzc = string2;
        this.zzd = string3;
        this.zze = uri;
        this.zzf = string4;
        this.zzg = uri2;
        this.zzh = string5;
        this.zzi = n2;
        this.zzj = string6;
        this.zzk = playerEntity;
        this.zzl = n3;
        this.zzm = n4;
        this.zzn = string7;
        this.zzo = l;
        this.zzp = l2;
        this.zzq = f;
        this.zzr = string8;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getDescription(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzd, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void getFormattedCurrentSteps(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        boolean bl = this.getType() == 1;
        Asserts.checkState((boolean)bl);
        DataUtils.copyStringToBuffer((String)this.zzn, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void getFormattedTotalSteps(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        boolean bl = this.getType() == 1;
        Asserts.checkState((boolean)bl);
        DataUtils.copyStringToBuffer((String)this.zzj, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getName(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzc, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getAchievementId(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getType());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getDescription(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.getUnlockedImageUri(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getUnlockedImageUrl(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.getRevealedImageUri(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.getRevealedImageUrl(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)9, (int)this.zzi);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)10, (String)this.zzj, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)11, (Parcelable)this.zzk, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)12, (int)this.getState());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)13, (int)this.zzm);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)14, (String)this.zzn, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)15, (long)this.getLastUpdatedTimestamp());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)16, (long)this.getXpValue());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)17, (float)this.zzq);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)18, (String)this.zzr, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        void var1_1;
        return AchievementEntity.zzf(this, var1_1);
    }

    public boolean isDataValid() {
        return true;
    }

    @Override
    public final float zza() {
        return this.zzq;
    }

    /*
     * Enabled aggressive block sorting
     */
    static int zzd(Achievement achievement) {
        int n;
        int n2;
        if (achievement.getType() == 1) {
            n2 = achievement.getCurrentSteps();
            n = achievement.getTotalSteps();
        } else {
            n2 = 0;
            n = 0;
        }
        Object[] objectArray = new Object[]{achievement.getAchievementId(), achievement.zzc(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.zzb(), n2, n};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    @Nullable
    public final Player zzb() {
        return this.zzk;
    }

    @Override
    @NonNull
    public final String zzc() {
        return this.zzr;
    }

    static String zze(Achievement achievement) {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)achievement).add("Id", (Object)achievement.getAchievementId()).add("Game Id", (Object)achievement.zzc()).add("Type", (Object)achievement.getType()).add("Name", (Object)achievement.getName()).add("Description", (Object)achievement.getDescription()).add("Player", (Object)achievement.zzb()).add("State", (Object)achievement.getState()).add("Rarity Percent", (Object)Float.valueOf(achievement.zza()));
        if (achievement.getType() == 1) {
            toStringHelper.add("CurrentSteps", (Object)achievement.getCurrentSteps());
            toStringHelper.add("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return toStringHelper.toString();
    }

    static boolean zzf(Achievement achievement, @Nullable Object object) {
        block8: {
            block7: {
                if (!(object instanceof Achievement)) {
                    return false;
                }
                if (achievement == object) {
                    return true;
                }
                if ((object = (Achievement)object).getType() != achievement.getType()) {
                    return false;
                }
                if (achievement.getType() != 1) break block7;
                if (object.getCurrentSteps() != achievement.getCurrentSteps()) {
                    return false;
                }
                if (object.getTotalSteps() != achievement.getTotalSteps()) break block8;
            }
            return object.getXpValue() == achievement.getXpValue() && object.getState() == achievement.getState() && object.getLastUpdatedTimestamp() == achievement.getLastUpdatedTimestamp() && Objects.equal((Object)object.getAchievementId(), (Object)achievement.getAchievementId()) && Objects.equal((Object)object.zzc(), (Object)achievement.zzc()) && Objects.equal((Object)object.getName(), (Object)achievement.getName()) && Objects.equal((Object)object.getDescription(), (Object)achievement.getDescription()) && Objects.equal((Object)object.zzb(), (Object)achievement.zzb()) && object.zza() == achievement.zza();
        }
        return false;
    }
}

