/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.Freezable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.games.Player;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@VisibleForTesting
public interface Achievement
extends Freezable<Achievement>,
Parcelable {
    public static final int STATE_UNLOCKED = 0;
    public static final int STATE_REVEALED = 1;
    public static final int STATE_HIDDEN = 2;
    public static final int TYPE_STANDARD = 0;
    public static final int TYPE_INCREMENTAL = 1;

    public int getCurrentSteps();

    public int getState();

    public int getTotalSteps();

    public int getType();

    public long getLastUpdatedTimestamp();

    public long getXpValue();

    @Nullable
    public Uri getRevealedImageUri();

    @Nullable
    public Uri getUnlockedImageUri();

    @NonNull
    public Player getPlayer();

    @NonNull
    public String getAchievementId();

    @NonNull
    public String getDescription();

    @Nullable
    public String getFormattedCurrentSteps();

    @Nullable
    public String getFormattedTotalSteps();

    @NonNull
    public String getName();

    @Deprecated
    @KeepName
    @Nullable
    public String getRevealedImageUrl();

    @Deprecated
    @KeepName
    @Nullable
    public String getUnlockedImageUrl();

    public void getDescription(@NonNull CharArrayBuffer var1);

    public void getFormattedCurrentSteps(@NonNull CharArrayBuffer var1);

    public void getFormattedTotalSteps(@NonNull CharArrayBuffer var1);

    public void getName(@NonNull CharArrayBuffer var1);

    public float zza();

    @Nullable
    public Player zzb();

    @NonNull
    public String zzc();

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AchievementType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AchievementState {
    }
}

