/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.tasks.Task;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface SnapshotsClient {
    @NonNull
    public static final String EXTRA_SNAPSHOT_METADATA = "com.google.android.gms.games.SNAPSHOT_METADATA";
    @NonNull
    public static final String EXTRA_SNAPSHOT_NEW = "com.google.android.gms.games.SNAPSHOT_NEW";
    public static final int DISPLAY_LIMIT_NONE = -1;
    public static final int RESOLUTION_POLICY_MANUAL = -1;
    public static final int RESOLUTION_POLICY_LONGEST_PLAYTIME = 1;
    public static final int RESOLUTION_POLICY_LAST_KNOWN_GOOD = 2;
    public static final int RESOLUTION_POLICY_MOST_RECENTLY_MODIFIED = 3;
    public static final int RESOLUTION_POLICY_HIGHEST_PROGRESS = 4;

    @NonNull
    public Task<SnapshotMetadata> commitAndClose(@NonNull Snapshot var1, @NonNull SnapshotMetadataChange var2);

    @NonNull
    public Task<String> delete(@NonNull SnapshotMetadata var1);

    @NonNull
    public Task<Void> discardAndClose(@NonNull Snapshot var1);

    @NonNull
    public Task<Integer> getMaxCoverImageSize();

    @NonNull
    public Task<Integer> getMaxDataSize();

    @NonNull
    public Task<Intent> getSelectSnapshotIntent(@NonNull String var1, boolean var2, boolean var3, int var4);

    @NonNull
    public Task<AnnotatedData<SnapshotMetadataBuffer>> load(boolean var1);

    @NonNull
    public Task<DataOrConflict<Snapshot>> open(@NonNull SnapshotMetadata var1);

    @NonNull
    public Task<DataOrConflict<Snapshot>> open(@NonNull SnapshotMetadata var1, int var2);

    @NonNull
    public Task<DataOrConflict<Snapshot>> open(@NonNull String var1, boolean var2);

    @NonNull
    public Task<DataOrConflict<Snapshot>> open(@NonNull String var1, boolean var2, int var3);

    @NonNull
    public Task<DataOrConflict<Snapshot>> resolveConflict(@NonNull String var1, @NonNull Snapshot var2);

    @NonNull
    public Task<DataOrConflict<Snapshot>> resolveConflict(@NonNull String var1, @NonNull String var2, @NonNull SnapshotMetadataChange var3, @NonNull SnapshotContents var4);

    public static final class SnapshotContentUnavailableApiException
    extends ApiException {
        @NonNull
        protected final SnapshotMetadata metadata;

        @NonNull
        public SnapshotMetadata getSnapshotMetadata() {
            return this.metadata;
        }

        public SnapshotContentUnavailableApiException(@NonNull Status status, @NonNull SnapshotMetadata snapshotMetadata) {
            super(status);
            this.metadata = snapshotMetadata;
        }
    }

    public static final class DataOrConflict<T> {
        private final Object zza;
        private final SnapshotConflict zzb;

        @Nullable
        public SnapshotConflict getConflict() {
            if (!((DataOrConflict)this_).isConflict()) {
                Object this_ = new IllegalStateException("getConflict called when there is no conflict.");
                throw this_;
            }
            return ((DataOrConflict)this_).zzb;
        }

        @Nullable
        public T getData() {
            if (((DataOrConflict)this_).isConflict()) {
                Object this_ = new IllegalStateException("getData called when there is a conflict.");
                throw this_;
            }
            return (T)((DataOrConflict)this_).zza;
        }

        public DataOrConflict(@Nullable Object object, @Nullable SnapshotConflict snapshotConflict) {
            this.zza = object;
            this.zzb = snapshotConflict;
        }

        public boolean isConflict() {
            return this.zzb != null;
        }
    }

    public static final class SnapshotConflict {
        private final Snapshot zza;
        private final String zzb;
        private final Snapshot zzc;
        private final SnapshotContents zzd;

        @NonNull
        public Snapshot getConflictingSnapshot() {
            return this.zzc;
        }

        @NonNull
        public Snapshot getSnapshot() {
            return this.zza;
        }

        @NonNull
        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzd;
        }

        @NonNull
        public String getConflictId() {
            return this.zzb;
        }

        public SnapshotConflict(@NonNull Snapshot snapshot, @NonNull String string, @NonNull Snapshot snapshot2, @NonNull SnapshotContents snapshotContents) {
            this.zza = snapshot;
            this.zzb = string;
            this.zzc = snapshot2;
            this.zzd = snapshotContents;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResolutionPolicy {
    }
}

