/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.annotation.SuppressLint;
import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.CurrentPlayerInfo;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.PlayerRelationshipInfo;
import com.google.android.gms.games.internal.player.zza;
import com.google.android.gms.games.internal.player.zzc;
import com.google.android.gms.games.internal.player.zzd;
import com.google.android.gms.games.zzq;
import com.google.android.gms.games.zzx;

@SuppressLint(value={"ParcelCreator"})
public final class PlayerRef
extends zzq
implements Player {
    private final zzd zza;
    private final PlayerLevelInfo zzb;
    private final zzc zzc;
    private final zzx zzd;
    private final com.google.android.gms.games.zzc zze;

    public final int describeContents() {
        return 0;
    }

    public final int hashCode() {
        return PlayerEntity.zzj(this);
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        if (!this.hasColumn(this.zza.zzj) || this.hasNull(this.zza.zzj)) {
            return -1L;
        }
        return this.getLong(this.zza.zzj);
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.getLong(this.zza.zzh);
    }

    @Override
    @NonNull
    public final Uri getBannerImageLandscapeUri() {
        return this.parseUri(this.zza.zzC);
    }

    @Override
    @NonNull
    public final Uri getBannerImagePortraitUri() {
        return this.parseUri(this.zza.zzE);
    }

    @Override
    @NonNull
    public final Uri getHiResImageUri() {
        return this.parseUri(this.zza.zzf);
    }

    @Override
    @NonNull
    public final Uri getIconImageUri() {
        return this.parseUri(this.zza.zzd);
    }

    @Override
    @Nullable
    public final CurrentPlayerInfo getCurrentPlayerInfo() {
        if (this.zze.zza()) {
            return this.zze;
        }
        return null;
    }

    @Override
    @NonNull
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzb;
    }

    @Override
    @Nullable
    public final PlayerRelationshipInfo getRelationshipInfo() {
        zzx zzx2 = this.zzd;
        if (zzx2.getFriendStatus() != -1 || zzx2.zzb() != null || zzx2.zza() != null) {
            return this.zzd;
        }
        return null;
    }

    @NonNull
    public final /* synthetic */ Object freeze() {
        PlayerEntity playerEntity = new PlayerEntity(this);
        return playerEntity;
    }

    @Override
    @NonNull
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.zza.zzD);
    }

    @Override
    @NonNull
    public String getBannerImagePortraitUrl() {
        return this.getString(this.zza.zzF);
    }

    @Override
    @NonNull
    public final String getDisplayName() {
        return this.getString(this.zza.zzc);
    }

    @Override
    @NonNull
    public String getHiResImageUrl() {
        return this.getString(this.zza.zzg);
    }

    @Override
    @NonNull
    public String getIconImageUrl() {
        return this.getString(this.zza.zze);
    }

    @Override
    @NonNull
    public final String getPlayerId() {
        return this.getString(this.zza.zza);
    }

    @Override
    @NonNull
    public final String getTitle() {
        return this.getString(this.zza.zzr);
    }

    @NonNull
    public final String toString() {
        return PlayerEntity.zzl(this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public PlayerRef(@NonNull DataHolder dataHolder, int n, @NonNull String object) {
        super(dataHolder, n2);
        void var1_4;
        PlayerLevelInfo playerLevelInfo;
        com.google.android.gms.games.zzc zzc2;
        zzx zzx2;
        zzc zzc3;
        zzd zzd2;
        int n2;
        this.zza = zzd2 = new zzd(null);
        this.zzc = zzc3 = new zzc(dataHolder, n2, this.zza);
        this.zzd = zzx2 = new zzx(dataHolder, n2, this.zza);
        this.zze = zzc2 = new com.google.android.gms.games.zzc(dataHolder, n2, this.zza);
        if (this.hasNull(this.zza.zzk) || this.getLong(this.zza.zzk) == -1L) {
            this.zzb = null;
            return;
        }
        int n3 = this.getInteger(this.zza.zzl);
        n2 = this.getInteger(this.zza.zzo);
        PlayerLevel playerLevel = new PlayerLevel(n3, this.getLong(this.zza.zzm), this.getLong(this.zza.zzn));
        if (n3 != n2) {
            PlayerLevel playerLevel2 = new PlayerLevel(n2, this.getLong(this.zza.zzn), this.getLong(this.zza.zzp));
        } else {
            PlayerLevel playerLevel3 = playerLevel;
        }
        this.zzb = playerLevelInfo = new PlayerLevelInfo(this.getLong(this.zza.zzk), this.getLong(this.zza.zzq), playerLevel, (PlayerLevel)var1_4);
    }

    @Override
    public final void getDisplayName(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer(this.zza.zzc, charArrayBuffer);
    }

    @Override
    public final void getTitle(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer(this.zza.zzr, charArrayBuffer);
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        PlayerEntity playerEntity = new PlayerEntity(this);
        playerEntity.writeToParcel(parcel, n);
    }

    public final boolean equals(@Nullable Object object) {
        return PlayerEntity.zzo(this, object);
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final int zza() {
        return this.getInteger(this.zza.zzi);
    }

    @Override
    public final long zzb() {
        String string = this.zza.zzG;
        if (!this.hasColumn(string) || this.hasNull(string)) {
            return -1L;
        }
        return this.getLong(string);
    }

    @Override
    @Nullable
    public final zza zzc() {
        if (this.hasNull(this.zza.zzt)) {
            return null;
        }
        return this.zzc;
    }

    @Override
    @Nullable
    public final String zzd() {
        return this.zzr(this.zza.zzb, null);
    }

    @Override
    @NonNull
    public final String zze() {
        return this.getString(this.zza.zzA);
    }

    @Override
    @NonNull
    public final String zzf() {
        return this.getString(this.zza.zzB);
    }

    @Override
    public final boolean zzg() {
        return this.getBoolean(this.zza.zzz);
    }

    @Override
    public final boolean zzh() {
        return this.hasColumn(this.zza.zzM) && this.getBoolean(this.zza.zzM);
    }

    @Override
    public final boolean zzi() {
        return this.getBoolean(this.zza.zzs);
    }
}

