/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.zzu;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="PlayerLevelInfoCreator")
public final class PlayerLevelInfo
extends zzc {
    @NonNull
    public static final Parcelable.Creator<PlayerLevelInfo> CREATOR;
    @SafeParcelable.Field(id=1, getter="getCurrentXpTotal")
    private final long zza;
    @SafeParcelable.Field(id=2, getter="getLastLevelUpTimestamp")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getCurrentLevel")
    private final PlayerLevel zzc;
    @SafeParcelable.Field(id=4, getter="getNextLevel")
    private final PlayerLevel zzd;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getCurrentXpTotal() {
        return this.zza;
    }

    public long getLastLevelUpTimestamp() {
        return this.zzb;
    }

    @NonNull
    public PlayerLevel getCurrentLevel() {
        return this.zzc;
    }

    @NonNull
    public PlayerLevel getNextLevel() {
        return this.zzd;
    }

    static {
        zzu zzu2;
        CREATOR = zzu2 = new zzu();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public PlayerLevelInfo(@SafeParcelable.Param(id=1) long l, @SafeParcelable.Param(id=2) long l2, @SafeParcelable.Param(id=3) @NonNull PlayerLevel playerLevel, @SafeParcelable.Param(id=4) @NonNull PlayerLevel playerLevel2) {
        boolean bl = l != -1L;
        Preconditions.checkState((boolean)bl);
        Preconditions.checkNotNull((Object)((Object)playerLevel));
        Preconditions.checkNotNull((Object)((Object)playerLevel2));
        this.zza = l;
        this.zzb = l2;
        this.zzc = playerLevel;
        this.zzd = playerLevel2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)1, (long)this.getCurrentXpTotal());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getLastLevelUpTimestamp());
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getCurrentLevel(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.getNextLevel(), (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object obj) {
        PlayerLevelInfo playerLevelInfo;
        if (!(obj instanceof PlayerLevelInfo)) {
            return false;
        }
        if (playerLevelInfo == this) {
            return true;
        }
        playerLevelInfo = playerLevelInfo;
        return Objects.equal((Object)this.zza, (Object)playerLevelInfo.zza) && Objects.equal((Object)this.zzb, (Object)playerLevelInfo.zzb) && Objects.equal((Object)((Object)this.zzc), (Object)((Object)playerLevelInfo.zzc)) && Objects.equal((Object)((Object)this.zzd), (Object)((Object)playerLevelInfo.zzd));
    }

    public boolean isMaxLevel() {
        return this.zzc.equals((Object)this.zzd);
    }
}

