/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.zzt;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="PlayerLevelCreator")
public final class PlayerLevel
extends zzc {
    @NonNull
    public static final Parcelable.Creator<PlayerLevel> CREATOR;
    @SafeParcelable.Field(id=1, getter="getLevelNumber")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getMinXp")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getMaxXp")
    private final long zzc;

    public int getLevelNumber() {
        return this.zza;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getMaxXp() {
        return this.zzc;
    }

    public long getMinXp() {
        return this.zzb;
    }

    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("LevelNumber", (Object)this.getLevelNumber()).add("MinXp", (Object)this.getMinXp()).add("MaxXp", (Object)this.getMaxXp()).toString();
    }

    static {
        zzt zzt2;
        CREATOR = zzt2 = new zzt();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public PlayerLevel(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2) {
        boolean bl = l >= 0L;
        Preconditions.checkState((boolean)bl, (Object)"Min XP must be positive!");
        bl = l2 > l;
        Preconditions.checkState((boolean)bl, (Object)"Max XP must be more than min XP!");
        this.zza = n;
        this.zzb = l;
        this.zzc = l2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getLevelNumber());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getMinXp());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.getMaxXp());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object obj) {
        PlayerLevel playerLevel;
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == playerLevel) {
            return true;
        }
        return Objects.equal((Object)(playerLevel = (PlayerLevel)playerLevel).getLevelNumber(), (Object)this.getLevelNumber()) && Objects.equal((Object)playerLevel.getMinXp(), (Object)this.getMinXp()) && Objects.equal((Object)playerLevel.getMaxXp(), (Object)this.getMaxXp());
    }
}

