/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DataUtils;
import com.google.android.gms.common.util.RetainForClient;
import com.google.android.gms.games.CurrentPlayerInfo;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.PlayerRelationshipInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.games.internal.player.zza;
import com.google.android.gms.games.zzr;
import com.google.android.gms.games.zzv;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="PlayerEntityCreator")
@RetainForClient
@UsedByReflection(value="GamesGmsClientImpl.java")
public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    @NonNull
    public static final Parcelable.Creator<PlayerEntity> CREATOR;
    @SafeParcelable.Field(id=1, getter="getPlayerId")
    private String zza;
    @SafeParcelable.Field(id=2, getter="getDisplayName")
    private String zzb;
    @SafeParcelable.Field(id=3, getter="getIconImageUri")
    @Nullable
    private final Uri zzc;
    @SafeParcelable.Field(id=4, getter="getHiResImageUri")
    @Nullable
    private final Uri zzd;
    @SafeParcelable.Field(id=5, getter="getRetrievedTimestamp")
    private final long zze;
    @SafeParcelable.Field(id=6, getter="isInCircles")
    private final int zzf;
    @SafeParcelable.Field(id=7, getter="getLastPlayedWithTimestamp")
    private final long zzg;
    @SafeParcelable.Field(id=8, getter="getIconImageUrl")
    @Nullable
    private final String zzh;
    @SafeParcelable.Field(id=9, getter="getHiResImageUrl")
    @Nullable
    private final String zzi;
    @SafeParcelable.Field(id=14, getter="getTitle")
    @Nullable
    private final String zzj;
    @SafeParcelable.Field(id=15, getter="getMostRecentGameInfo")
    @Nullable
    private final MostRecentGameInfoEntity zzk;
    @SafeParcelable.Field(id=16, getter="getLevelInfo")
    @Nullable
    private final PlayerLevelInfo zzl;
    @SafeParcelable.Field(id=18, getter="isProfileVisible")
    private final boolean zzm;
    @SafeParcelable.Field(id=19, getter="hasDebugAccess")
    private final boolean zzn;
    @SafeParcelable.Field(id=20, getter="getGamerTag")
    @Nullable
    private final String zzo;
    @SafeParcelable.Field(id=21, getter="getName")
    private final String zzp;
    @SafeParcelable.Field(id=22, getter="getBannerImageLandscapeUri")
    @Nullable
    private final Uri zzq;
    @SafeParcelable.Field(id=23, getter="getBannerImageLandscapeUrl")
    @Nullable
    private final String zzr;
    @SafeParcelable.Field(id=24, getter="getBannerImagePortraitUri")
    @Nullable
    private final Uri zzs;
    @SafeParcelable.Field(id=25, getter="getBannerImagePortraitUrl")
    @Nullable
    private final String zzt;
    @SafeParcelable.Field(id=29, getter="getTotalUnlockedAchievement", defaultValue="-1")
    private long zzu;
    @SafeParcelable.Field(id=33, getter="getRelationshipInfo")
    @Nullable
    private final zzv zzv;
    @SafeParcelable.Field(id=35, getter="getCurrentPlayerInfo")
    @Nullable
    private final com.google.android.gms.games.zza zzw;
    @SafeParcelable.Field(id=36, getter="isAlwaysAutoSignIn")
    private boolean zzx;
    @SafeParcelable.Field(id=37, getter="getGamePlayerId")
    @Nullable
    private final String zzy;

    public int hashCode() {
        return PlayerEntity.zzj(this);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzg;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zze;
    }

    @Override
    @Nullable
    public Uri getBannerImageLandscapeUri() {
        return this.zzq;
    }

    @Override
    @Nullable
    public Uri getBannerImagePortraitUri() {
        return this.zzs;
    }

    @Override
    @Nullable
    public Uri getHiResImageUri() {
        return this.zzd;
    }

    @Override
    @Nullable
    public Uri getIconImageUri() {
        return this.zzc;
    }

    @Override
    @NonNull
    public CurrentPlayerInfo getCurrentPlayerInfo() {
        return this.zzw;
    }

    @NonNull
    public Player freeze() {
        return this;
    }

    @Override
    @Nullable
    public PlayerLevelInfo getLevelInfo() {
        return this.zzl;
    }

    @Override
    @Nullable
    public PlayerRelationshipInfo getRelationshipInfo() {
        return this.zzv;
    }

    @Override
    @Nullable
    public String getBannerImageLandscapeUrl() {
        return this.zzr;
    }

    @Override
    @Nullable
    public String getBannerImagePortraitUrl() {
        return this.zzt;
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return this.zzb;
    }

    @Override
    @Nullable
    public String getHiResImageUrl() {
        return this.zzi;
    }

    @Override
    @Nullable
    public String getIconImageUrl() {
        return this.zzh;
    }

    @Override
    @NonNull
    public String getPlayerId() {
        return this.zza;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.zzj;
    }

    @NonNull
    public String toString() {
        return PlayerEntity.zzl(this);
    }

    static {
        zzr zzr2;
        CREATOR = zzr2 = new zzr();
    }

    /*
     * Enabled aggressive block sorting
     */
    public PlayerEntity(@NonNull Player player) {
        this.zza = player.getPlayerId();
        this.zzb = player.getDisplayName();
        this.zzc = player.getIconImageUri();
        this.zzh = player.getIconImageUrl();
        this.zzd = player.getHiResImageUri();
        this.zzi = player.getHiResImageUrl();
        this.zze = player.getRetrievedTimestamp();
        this.zzf = player.zza();
        this.zzg = player.getLastPlayedWithTimestamp();
        this.zzj = player.getTitle();
        this.zzm = player.zzi();
        Object object = player.zzc();
        if (object == null) {
            object = null;
        } else {
            MostRecentGameInfoEntity mostRecentGameInfoEntity = new MostRecentGameInfoEntity((zza)object);
            object = mostRecentGameInfoEntity;
        }
        this.zzk = object;
        this.zzl = player.getLevelInfo();
        this.zzn = player.zzg();
        this.zzo = player.zze();
        this.zzp = player.zzf();
        this.zzq = player.getBannerImageLandscapeUri();
        this.zzr = player.getBannerImageLandscapeUrl();
        this.zzs = player.getBannerImagePortraitUri();
        this.zzt = player.getBannerImagePortraitUrl();
        this.zzu = player.zzb();
        object = player.getRelationshipInfo();
        if (object == null) {
            object = null;
        } else {
            zzv zzv2 = new zzv((PlayerRelationshipInfo)object.freeze());
            object = zzv2;
        }
        this.zzv = object;
        object = player.getCurrentPlayerInfo();
        object = object == null ? null : object.freeze();
        this.zzw = (com.google.android.gms.games.zza)object;
        this.zzx = player.zzh();
        this.zzy = player.zzd();
        Asserts.checkNotNull((Object)this.zza);
        Asserts.checkNotNull((Object)this.zzb);
        boolean bl = this.zze > 0L;
        Asserts.checkState((boolean)bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getDisplayName(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzb, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getTitle(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzj, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_8;
        void var2_5;
        void var1_1;
        if (!this.shouldDowngrade()) {
            void var2_2;
            int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getPlayerId(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getDisplayName(), (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getIconImageUri(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.getHiResImageUri(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeLong((Parcel)var1_1, (int)5, (long)this.getRetrievedTimestamp());
            SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.zzf);
            SafeParcelWriter.writeLong((Parcel)var1_1, (int)7, (long)this.getLastPlayedWithTimestamp());
            SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.getIconImageUrl(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)9, (String)this.getHiResImageUrl(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)14, (String)this.getTitle(), (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)15, (Parcelable)this.zzk, (int)var2_2, (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)16, (Parcelable)this.getLevelInfo(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)18, (boolean)this.zzm);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)19, (boolean)this.zzn);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)20, (String)this.zzo, (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)21, (String)this.zzp, (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)22, (Parcelable)this.getBannerImageLandscapeUri(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)23, (String)this.getBannerImageLandscapeUrl(), (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)24, (Parcelable)this.getBannerImagePortraitUri(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)25, (String)this.getBannerImagePortraitUrl(), (boolean)false);
            SafeParcelWriter.writeLong((Parcel)var1_1, (int)29, (long)this.zzu);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)33, (Parcelable)this.getRelationshipInfo(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)35, (Parcelable)this.getCurrentPlayerInfo(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)36, (boolean)this.zzx);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)37, (String)this.zzy, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
            return;
        }
        var1_1.writeString(this.zza);
        var1_1.writeString(this.zzb);
        Uri uri = this.zzc;
        if (uri == null) {
            Object var2_4 = null;
        } else {
            String string = uri.toString();
        }
        var1_1.writeString((String)var2_5);
        Uri uri2 = this.zzd;
        if (uri2 == null) {
            Object var2_7 = null;
        } else {
            String string = uri2.toString();
        }
        var1_1.writeString((String)var2_8);
        var1_1.writeLong(this.zze);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        void var1_1;
        return PlayerEntity.zzo(this, var1_1);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    public boolean isDataValid() {
        return true;
    }

    static int zzj(Player player) {
        Object[] objectArray = new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzg(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zze(), player.zzf(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzb(), player.getRelationshipInfo(), player.getCurrentPlayerInfo(), player.zzh(), player.zzd()};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    public final int zza() {
        return this.zzf;
    }

    @Override
    public final long zzb() {
        return this.zzu;
    }

    @Override
    @Nullable
    public final zza zzc() {
        return this.zzk;
    }

    static /* synthetic */ Integer zzk() {
        return PlayerEntity.getUnparcelClientVersion();
    }

    @Override
    @Nullable
    public final String zzd() {
        return this.zzy;
    }

    @Override
    @Nullable
    public final String zze() {
        return this.zzo;
    }

    @Override
    @NonNull
    public final String zzf() {
        return this.zzp;
    }

    static String zzl(Player player) {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)player).add("PlayerId", (Object)player.getPlayerId()).add("DisplayName", (Object)player.getDisplayName()).add("HasDebugAccess", (Object)player.zzg()).add("IconImageUri", (Object)player.getIconImageUri()).add("IconImageUrl", (Object)player.getIconImageUrl()).add("HiResImageUri", (Object)player.getHiResImageUri()).add("HiResImageUrl", (Object)player.getHiResImageUrl()).add("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).add("Title", (Object)player.getTitle()).add("LevelInfo", (Object)player.getLevelInfo()).add("GamerTag", (Object)player.zze()).add("Name", (Object)player.zzf()).add("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).add("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).add("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).add("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).add("CurrentPlayerInfo", (Object)player.getCurrentPlayerInfo()).add("TotalUnlockedAchievement", (Object)player.zzb());
        if (player.zzh()) {
            toStringHelper.add("AlwaysAutoSignIn", (Object)player.zzh());
        }
        if (player.getRelationshipInfo() != null) {
            toStringHelper.add("RelationshipInfo", (Object)player.getRelationshipInfo());
        }
        if (player.zzd() != null) {
            toStringHelper.add("GamePlayerId", (Object)player.zzd());
        }
        return toStringHelper.toString();
    }

    @SafeParcelable.Constructor
    PlayerEntity(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) @Nullable Uri uri, @SafeParcelable.Param(id=4) @Nullable Uri uri2, @SafeParcelable.Param(id=5) long l, @SafeParcelable.Param(id=6) int n, @SafeParcelable.Param(id=7) long l2, @SafeParcelable.Param(id=8) @Nullable String string3, @SafeParcelable.Param(id=9) @Nullable String string4, @SafeParcelable.Param(id=14) @Nullable String string5, @SafeParcelable.Param(id=15) @Nullable MostRecentGameInfoEntity mostRecentGameInfoEntity, @SafeParcelable.Param(id=16) @Nullable PlayerLevelInfo playerLevelInfo, @SafeParcelable.Param(id=18) boolean bl, @SafeParcelable.Param(id=19) boolean bl2, @SafeParcelable.Param(id=20) @Nullable String string6, @SafeParcelable.Param(id=21) String string7, @SafeParcelable.Param(id=22) @Nullable Uri uri3, @SafeParcelable.Param(id=23) @Nullable String string8, @SafeParcelable.Param(id=24) @Nullable Uri uri4, @SafeParcelable.Param(id=25) @Nullable String string9, @SafeParcelable.Param(id=29) long l3, @SafeParcelable.Param(id=33) @Nullable zzv zzv2, @SafeParcelable.Param(id=35) @Nullable com.google.android.gms.games.zza zza2, @SafeParcelable.Param(id=36) boolean bl3, @SafeParcelable.Param(id=37) @Nullable String string10) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = uri;
        this.zzh = string3;
        this.zzd = uri2;
        this.zzi = string4;
        this.zze = l;
        this.zzf = n;
        this.zzg = l2;
        this.zzj = string5;
        this.zzm = bl;
        this.zzk = mostRecentGameInfoEntity;
        this.zzl = playerLevelInfo;
        this.zzn = bl2;
        this.zzo = string6;
        this.zzp = string7;
        this.zzq = uri3;
        this.zzr = string8;
        this.zzs = uri4;
        this.zzt = string9;
        this.zzu = l3;
        this.zzv = zzv2;
        this.zzw = zza2;
        this.zzx = bl3;
        this.zzy = string10;
    }

    static /* synthetic */ boolean zzm(Integer n) {
        return PlayerEntity.zzp(n);
    }

    static /* synthetic */ boolean zzn(String string) {
        return PlayerEntity.canUnparcelSafely((String)string);
    }

    static boolean zzo(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        return Objects.equal((Object)(object = (Player)object).getPlayerId(), (Object)player.getPlayerId()) && Objects.equal((Object)object.getDisplayName(), (Object)player.getDisplayName()) && Objects.equal((Object)object.zzg(), (Object)player.zzg()) && Objects.equal((Object)object.getIconImageUri(), (Object)player.getIconImageUri()) && Objects.equal((Object)object.getHiResImageUri(), (Object)player.getHiResImageUri()) && Objects.equal((Object)object.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && Objects.equal((Object)object.getTitle(), (Object)player.getTitle()) && Objects.equal((Object)((Object)object.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && Objects.equal((Object)object.zze(), (Object)player.zze()) && Objects.equal((Object)object.zzf(), (Object)player.zzf()) && Objects.equal((Object)object.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && Objects.equal((Object)object.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && Objects.equal((Object)object.zzb(), (Object)player.zzb()) && Objects.equal((Object)object.getCurrentPlayerInfo(), (Object)player.getCurrentPlayerInfo()) && Objects.equal((Object)object.getRelationshipInfo(), (Object)player.getRelationshipInfo()) && Objects.equal((Object)object.zzh(), (Object)player.zzh()) && Objects.equal((Object)object.zzd(), (Object)player.zzd());
    }

    @Override
    public final boolean zzg() {
        return this.zzn;
    }

    @Override
    public final boolean zzh() {
        return this.zzx;
    }

    @Override
    public final boolean zzi() {
        return this.zzm;
    }
}

