/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Intent;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.tasks.Task;

public interface LeaderboardsClient {
    @NonNull
    public Task<Intent> getAllLeaderboardsIntent();

    @NonNull
    public Task<Intent> getLeaderboardIntent(@NonNull String var1);

    @NonNull
    public Task<Intent> getLeaderboardIntent(@NonNull String var1, int var2);

    @NonNull
    public Task<Intent> getLeaderboardIntent(@NonNull String var1, int var2, int var3);

    @NonNull
    public Task<AnnotatedData<LeaderboardScore>> loadCurrentPlayerLeaderboardScore(@NonNull String var1, int var2, int var3);

    @NonNull
    public Task<AnnotatedData<LeaderboardBuffer>> loadLeaderboardMetadata(boolean var1);

    @NonNull
    public Task<AnnotatedData<Leaderboard>> loadLeaderboardMetadata(@NonNull String var1, boolean var2);

    @NonNull
    public Task<AnnotatedData<LeaderboardScores>> loadMoreScores(@NonNull LeaderboardScoreBuffer var1, @IntRange(from=1L, to=25L) int var2, int var3);

    @NonNull
    public Task<AnnotatedData<LeaderboardScores>> loadPlayerCenteredScores(@NonNull String var1, int var2, int var3, @IntRange(from=1L, to=25L) int var4);

    @NonNull
    public Task<AnnotatedData<LeaderboardScores>> loadPlayerCenteredScores(@NonNull String var1, int var2, int var3, @IntRange(from=1L, to=25L) int var4, boolean var5);

    @NonNull
    public Task<AnnotatedData<LeaderboardScores>> loadTopScores(@NonNull String var1, int var2, int var3, @IntRange(from=1L, to=25L) int var4);

    @NonNull
    public Task<AnnotatedData<LeaderboardScores>> loadTopScores(@NonNull String var1, int var2, int var3, @IntRange(from=1L, to=25L) int var4, boolean var5);

    @NonNull
    public Task<ScoreSubmissionData> submitScoreImmediate(@NonNull String var1, long var2);

    @NonNull
    public Task<ScoreSubmissionData> submitScoreImmediate(@NonNull String var1, long var2, @NonNull String var4);

    public void submitScore(@NonNull String var1, long var2);

    public void submitScore(@NonNull String var1, long var2, @NonNull String var4);

    public static class LeaderboardScores
    implements Releasable {
        private final Leaderboard zza;
        private final LeaderboardScoreBuffer zzb;

        @Nullable
        public Leaderboard getLeaderboard() {
            return this.zza;
        }

        @NonNull
        public LeaderboardScoreBuffer getScores() {
            return this.zzb;
        }

        public LeaderboardScores(@Nullable Leaderboard leaderboard, @NonNull LeaderboardScoreBuffer leaderboardScoreBuffer) {
            this.zza = leaderboard;
            this.zzb = leaderboardScoreBuffer;
        }

        public void release() {
            this.zzb.release();
        }
    }
}

