/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.data.DataBufferRef;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;

public final class GameRef
extends DataBufferRef
implements Game {
    public final int describeContents() {
        return 0;
    }

    @Override
    public final int getAchievementTotalCount() {
        return this.getInteger("achievement_total_count");
    }

    @Override
    public final int getLeaderboardCount() {
        return this.getInteger("leaderboard_count");
    }

    public final int hashCode() {
        return GameEntity.zzh(this);
    }

    @Override
    @NonNull
    public final Uri getFeaturedImageUri() {
        return this.parseUri("featured_image_uri");
    }

    @Override
    @NonNull
    public final Uri getHiResImageUri() {
        return this.parseUri("game_hi_res_image_uri");
    }

    @Override
    @NonNull
    public final Uri getIconImageUri() {
        return this.parseUri("game_icon_image_uri");
    }

    @NonNull
    public final /* synthetic */ Object freeze() {
        GameEntity gameEntity = new GameEntity(this);
        return gameEntity;
    }

    @Override
    @NonNull
    public final String getApplicationId() {
        return this.getString("external_game_id");
    }

    @Override
    @NonNull
    public final String getDescription() {
        return this.getString("game_description");
    }

    @Override
    @NonNull
    public final String getDeveloperName() {
        return this.getString("developer_name");
    }

    @Override
    @NonNull
    public final String getDisplayName() {
        return this.getString("display_name");
    }

    @Override
    @NonNull
    public String getFeaturedImageUrl() {
        return this.getString("featured_image_url");
    }

    @Override
    @NonNull
    public String getHiResImageUrl() {
        return this.getString("game_hi_res_image_url");
    }

    @Override
    @NonNull
    public String getIconImageUrl() {
        return this.getString("game_icon_image_url");
    }

    @Override
    @NonNull
    public final String getPrimaryCategory() {
        return this.getString("primary_category");
    }

    @Override
    @NonNull
    public final String getSecondaryCategory() {
        return this.getString("secondary_category");
    }

    @Override
    @NonNull
    public final String getThemeColor() {
        return this.getString("theme_color");
    }

    @NonNull
    public final String toString() {
        return GameEntity.zzj(this);
    }

    public GameRef(@NonNull DataHolder dataHolder, int n) {
        super(dataHolder, n);
    }

    @Override
    public final void getDescription(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer("game_description", charArrayBuffer);
    }

    @Override
    public final void getDeveloperName(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer("developer_name", charArrayBuffer);
    }

    @Override
    public final void getDisplayName(@NonNull CharArrayBuffer charArrayBuffer) {
        this.copyToBuffer("display_name", charArrayBuffer);
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        GameEntity gameEntity = new GameEntity(this);
        gameEntity.writeToParcel(parcel, n);
    }

    @Override
    public final boolean areSnapshotsEnabled() {
        return this.getInteger("snapshots_enabled") > 0;
    }

    public final boolean equals(@Nullable Object object) {
        return GameEntity.zzm(this, object);
    }

    @Override
    public final boolean hasGamepadSupport() {
        return this.getInteger("gamepad_support") > 0;
    }

    @Override
    @NonNull
    public final String zza() {
        return this.getString("package_name");
    }

    @Override
    public final boolean zzb() {
        return this.getBoolean("identity_sharing_confirmed");
    }

    @Override
    public final boolean zzc() {
        return this.getInteger("installed") > 0;
    }

    @Override
    public final boolean zzd() {
        return this.getBoolean("muted");
    }

    @Override
    public final boolean zze() {
        return this.getBoolean("play_enabled_game");
    }

    @Override
    public final boolean zzf() {
        return this.getInteger("real_time_support") > 0;
    }

    @Override
    public final boolean zzg() {
        return this.getInteger("turn_based_support") > 0;
    }
}

