/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DataUtils;
import com.google.android.gms.common.util.RetainForClient;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.zze;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="GameEntityCreator")
@RetainForClient
@UsedByReflection(value="GamesGmsClientImpl.java")
public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    @NonNull
    public static final Parcelable.Creator<GameEntity> CREATOR;
    @SafeParcelable.Field(id=1, getter="getApplicationId")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getDisplayName")
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getPrimaryCategory")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getSecondaryCategory")
    private final String zzd;
    @SafeParcelable.Field(id=5, getter="getDescription")
    private final String zze;
    @SafeParcelable.Field(id=6, getter="getDeveloperName")
    private final String zzf;
    @SafeParcelable.Field(id=7, getter="getIconImageUri")
    private final Uri zzg;
    @SafeParcelable.Field(id=8, getter="getHiResImageUri")
    private final Uri zzh;
    @SafeParcelable.Field(id=9, getter="getFeaturedImageUri")
    private final Uri zzi;
    @SafeParcelable.Field(id=10, getter="isPlayEnabledGame")
    private final boolean zzj;
    @SafeParcelable.Field(id=11, getter="isInstanceInstalled")
    private final boolean zzk;
    @SafeParcelable.Field(id=12, getter="getInstancePackageName")
    private final String zzl;
    @SafeParcelable.Field(id=13, getter="getGameplayAclStatus")
    private final int zzm;
    @SafeParcelable.Field(id=14, getter="getAchievementTotalCount")
    private final int zzn;
    @SafeParcelable.Field(id=15, getter="getLeaderboardCount")
    private final int zzo;
    @SafeParcelable.Field(id=16, getter="isRealTimeMultiplayerEnabled")
    private final boolean zzp;
    @SafeParcelable.Field(id=17, getter="isTurnBasedMultiplayerEnabled")
    private final boolean zzq;
    @SafeParcelable.Field(id=18, getter="getIconImageUrl")
    private final String zzr;
    @SafeParcelable.Field(id=19, getter="getHiResImageUrl")
    private final String zzs;
    @SafeParcelable.Field(id=20, getter="getFeaturedImageUrl")
    private final String zzt;
    @SafeParcelable.Field(id=21, getter="isMuted")
    private final boolean zzu;
    @SafeParcelable.Field(id=22, getter="isIdentitySharingConfirmed")
    private final boolean zzv;
    @SafeParcelable.Field(id=23, getter="areSnapshotsEnabled")
    private final boolean zzw;
    @SafeParcelable.Field(id=24, getter="getThemeColor")
    private final String zzx;
    @SafeParcelable.Field(id=25, getter="hasGamepadSupport")
    private final boolean zzy;

    @Override
    public int getAchievementTotalCount() {
        return this.zzn;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzo;
    }

    public int hashCode() {
        return GameEntity.zzh(this);
    }

    @Override
    @NonNull
    public Uri getFeaturedImageUri() {
        return this.zzi;
    }

    @Override
    @NonNull
    public Uri getHiResImageUri() {
        return this.zzh;
    }

    @Override
    @NonNull
    public Uri getIconImageUri() {
        return this.zzg;
    }

    @NonNull
    public Game freeze() {
        return this;
    }

    @Override
    @NonNull
    public String getApplicationId() {
        return this.zza;
    }

    @Override
    @NonNull
    public String getDescription() {
        return this.zze;
    }

    @Override
    @NonNull
    public String getDeveloperName() {
        return this.zzf;
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return this.zzb;
    }

    @Override
    @NonNull
    public String getFeaturedImageUrl() {
        return this.zzt;
    }

    @Override
    @NonNull
    public String getHiResImageUrl() {
        return this.zzs;
    }

    @Override
    @NonNull
    public String getIconImageUrl() {
        return this.zzr;
    }

    @Override
    @NonNull
    public String getPrimaryCategory() {
        return this.zzc;
    }

    @Override
    @NonNull
    public String getSecondaryCategory() {
        return this.zzd;
    }

    @Override
    @NonNull
    public String getThemeColor() {
        return this.zzx;
    }

    @NonNull
    public String toString() {
        return GameEntity.zzj(this);
    }

    static {
        zze zze2;
        CREATOR = zze2 = new zze();
    }

    public GameEntity(@NonNull Game game) {
        this.zza = game.getApplicationId();
        this.zzc = game.getPrimaryCategory();
        this.zzd = game.getSecondaryCategory();
        this.zze = game.getDescription();
        this.zzf = game.getDeveloperName();
        this.zzb = game.getDisplayName();
        this.zzg = game.getIconImageUri();
        this.zzr = game.getIconImageUrl();
        this.zzh = game.getHiResImageUri();
        this.zzs = game.getHiResImageUrl();
        this.zzi = game.getFeaturedImageUri();
        this.zzt = game.getFeaturedImageUrl();
        this.zzj = game.zze();
        this.zzk = game.zzc();
        this.zzl = game.zza();
        this.zzm = 1;
        this.zzn = game.getAchievementTotalCount();
        this.zzo = game.getLeaderboardCount();
        this.zzp = game.zzf();
        this.zzq = game.zzg();
        this.zzu = game.zzd();
        this.zzv = game.zzb();
        this.zzw = game.areSnapshotsEnabled();
        this.zzx = game.getThemeColor();
        this.zzy = game.hasGamepadSupport();
    }

    @SafeParcelable.Constructor
    GameEntity(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) String string3, @SafeParcelable.Param(id=4) String string4, @SafeParcelable.Param(id=5) String string5, @SafeParcelable.Param(id=6) String string6, @SafeParcelable.Param(id=7) Uri uri, @SafeParcelable.Param(id=8) Uri uri2, @SafeParcelable.Param(id=9) Uri uri3, @SafeParcelable.Param(id=10) boolean bl, @SafeParcelable.Param(id=11) boolean bl2, @SafeParcelable.Param(id=12) String string7, @SafeParcelable.Param(id=13) int n, @SafeParcelable.Param(id=14) int n2, @SafeParcelable.Param(id=15) int n3, @SafeParcelable.Param(id=16) boolean bl3, @SafeParcelable.Param(id=17) boolean bl4, @SafeParcelable.Param(id=18) String string8, @SafeParcelable.Param(id=19) String string9, @SafeParcelable.Param(id=20) String string10, @SafeParcelable.Param(id=21) boolean bl5, @SafeParcelable.Param(id=22) boolean bl6, @SafeParcelable.Param(id=23) boolean bl7, @SafeParcelable.Param(id=24) String string11, @SafeParcelable.Param(id=25) boolean bl8) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = string3;
        this.zzd = string4;
        this.zze = string5;
        this.zzf = string6;
        this.zzg = uri;
        this.zzr = string8;
        this.zzh = uri2;
        this.zzs = string9;
        this.zzi = uri3;
        this.zzt = string10;
        this.zzj = bl;
        this.zzk = bl2;
        this.zzl = string7;
        this.zzm = n;
        this.zzn = n2;
        this.zzo = n3;
        this.zzp = bl3;
        this.zzq = bl4;
        this.zzu = bl5;
        this.zzv = bl6;
        this.zzw = bl7;
        this.zzx = string11;
        this.zzy = bl8;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getDescription(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zze, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getDeveloperName(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzf, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getDisplayName(@NonNull CharArrayBuffer dataOut) {
        void var1_1;
        DataUtils.copyStringToBuffer((String)this.zzb, (CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_11;
        void var2_8;
        void var2_5;
        void var1_1;
        if (!this.shouldDowngrade()) {
            void var2_2;
            int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getApplicationId(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getDisplayName(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getPrimaryCategory(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getSecondaryCategory(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getDescription(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getDeveloperName(), (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.getIconImageUri(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)8, (Parcelable)this.getHiResImageUri(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)9, (Parcelable)this.getFeaturedImageUri(), (int)var2_2, (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)10, (boolean)this.zzj);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)11, (boolean)this.zzk);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)12, (String)this.zzl, (boolean)false);
            SafeParcelWriter.writeInt((Parcel)var1_1, (int)13, (int)this.zzm);
            SafeParcelWriter.writeInt((Parcel)var1_1, (int)14, (int)this.getAchievementTotalCount());
            SafeParcelWriter.writeInt((Parcel)var1_1, (int)15, (int)this.getLeaderboardCount());
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)16, (boolean)this.zzp);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)17, (boolean)this.zzq);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)18, (String)this.getIconImageUrl(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)19, (String)this.getHiResImageUrl(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)20, (String)this.getFeaturedImageUrl(), (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)21, (boolean)this.zzu);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)22, (boolean)this.zzv);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)23, (boolean)this.areSnapshotsEnabled());
            SafeParcelWriter.writeString((Parcel)var1_1, (int)24, (String)this.getThemeColor(), (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)25, (boolean)this.hasGamepadSupport());
            SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
            return;
        }
        var1_1.writeString(this.zza);
        var1_1.writeString(this.zzb);
        var1_1.writeString(this.zzc);
        var1_1.writeString(this.zzd);
        var1_1.writeString(this.zze);
        var1_1.writeString(this.zzf);
        Uri uri = this.zzg;
        if (uri == null) {
            Object var2_4 = null;
        } else {
            String string = uri.toString();
        }
        var1_1.writeString((String)var2_5);
        Uri uri2 = this.zzh;
        if (uri2 == null) {
            Object var2_7 = null;
        } else {
            String string = uri2.toString();
        }
        var1_1.writeString((String)var2_8);
        Uri uri3 = this.zzi;
        if (uri3 == null) {
            Object var2_10 = null;
        } else {
            String string = uri3.toString();
        }
        var1_1.writeString((String)var2_11);
        var1_1.writeInt(this.zzj ? 1 : 0);
        var1_1.writeInt(this.zzk ? 1 : 0);
        var1_1.writeString(this.zzl);
        var1_1.writeInt(this.zzm);
        var1_1.writeInt(this.zzn);
        var1_1.writeInt(this.zzo);
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzw;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        void var1_1;
        return GameEntity.zzm(this, var1_1);
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzy;
    }

    public boolean isDataValid() {
        return true;
    }

    static int zzh(Game game) {
        Object[] objectArray = new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zze(), game.zzc(), game.zza(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.zzf(), game.zzg(), game.zzd(), game.zzb(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()};
        return Objects.hashCode((Object[])objectArray);
    }

    static /* synthetic */ Integer zzi() {
        return GameEntity.getUnparcelClientVersion();
    }

    @Override
    @NonNull
    public final String zza() {
        return this.zzl;
    }

    static String zzj(Game game) {
        return Objects.toStringHelper((Object)game).add("ApplicationId", (Object)game.getApplicationId()).add("DisplayName", (Object)game.getDisplayName()).add("PrimaryCategory", (Object)game.getPrimaryCategory()).add("SecondaryCategory", (Object)game.getSecondaryCategory()).add("Description", (Object)game.getDescription()).add("DeveloperName", (Object)game.getDeveloperName()).add("IconImageUri", (Object)game.getIconImageUri()).add("IconImageUrl", (Object)game.getIconImageUrl()).add("HiResImageUri", (Object)game.getHiResImageUri()).add("HiResImageUrl", (Object)game.getHiResImageUrl()).add("FeaturedImageUri", (Object)game.getFeaturedImageUri()).add("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).add("PlayEnabledGame", (Object)game.zze()).add("InstanceInstalled", (Object)game.zzc()).add("InstancePackageName", (Object)game.zza()).add("AchievementTotalCount", (Object)game.getAchievementTotalCount()).add("LeaderboardCount", (Object)game.getLeaderboardCount()).add("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).add("ThemeColor", (Object)game.getThemeColor()).add("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    static /* synthetic */ boolean zzk(Integer n) {
        return GameEntity.zzp(n);
    }

    static /* synthetic */ boolean zzl(String string) {
        return GameEntity.canUnparcelSafely((String)string);
    }

    static boolean zzm(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        return Objects.equal((Object)(object = (Game)object).getApplicationId(), (Object)game.getApplicationId()) && Objects.equal((Object)object.getDisplayName(), (Object)game.getDisplayName()) && Objects.equal((Object)object.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && Objects.equal((Object)object.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && Objects.equal((Object)object.getDescription(), (Object)game.getDescription()) && Objects.equal((Object)object.getDeveloperName(), (Object)game.getDeveloperName()) && Objects.equal((Object)object.getIconImageUri(), (Object)game.getIconImageUri()) && Objects.equal((Object)object.getHiResImageUri(), (Object)game.getHiResImageUri()) && Objects.equal((Object)object.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && Objects.equal((Object)object.zze(), (Object)game.zze()) && Objects.equal((Object)object.zzc(), (Object)game.zzc()) && Objects.equal((Object)object.zza(), (Object)game.zza()) && Objects.equal((Object)object.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && Objects.equal((Object)object.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && Objects.equal((Object)object.zzf(), (Object)game.zzf()) && Objects.equal((Object)object.zzg(), (Object)game.zzg()) && Objects.equal((Object)object.zzd(), (Object)game.zzd()) && Objects.equal((Object)object.zzb(), (Object)game.zzb()) && Objects.equal((Object)object.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && Objects.equal((Object)object.getThemeColor(), (Object)game.getThemeColor()) && Objects.equal((Object)object.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    @Override
    public final boolean zzb() {
        return this.zzv;
    }

    @Override
    public final boolean zzc() {
        return this.zzk;
    }

    @Override
    public final boolean zzd() {
        return this.zzu;
    }

    @Override
    public final boolean zze() {
        return this.zzj;
    }

    @Override
    public final boolean zzf() {
        return this.zzp;
    }

    @Override
    public final boolean zzg() {
        return this.zzq;
    }
}

