/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.video.zzb;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class VideoConfiguration
extends zzbgl {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zziiv;
    private final int zziio;
    private final String zziiw;
    private final String zziix;
    private final String zziiy;
    private final String zziiz;
    private final boolean zzija;

    @Hide
    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzbq.checkArgument((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzbq.checkArgument((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zziiv = n;
        this.zziio = n2;
        this.zzija = bl;
        if (n2 == 1) {
            this.zziix = string2;
            this.zziiw = string;
            this.zziiy = string3;
            this.zziiz = string4;
            return;
        }
        zzbq.checkArgument((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
        zzbq.checkArgument((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
        zzbq.checkArgument((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
        zzbq.checkArgument((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
        this.zziix = null;
        this.zziiw = null;
        this.zziiy = null;
        this.zziiz = null;
    }

    public final int getQualityLevel() {
        return this.zziiv;
    }

    public final int getCaptureMode() {
        return this.zziio;
    }

    @Hide
    public final String getStreamUrl() {
        return this.zziiw;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoConfiguration videoConfiguration = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, (int)videoConfiguration.getQualityLevel());
        zzbgo.zzc((Parcel)parcel2, (int)2, (int)videoConfiguration.getCaptureMode());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)videoConfiguration.getStreamUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)videoConfiguration.zziix, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)videoConfiguration.zziiy, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)videoConfiguration.zziiz, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)videoConfiguration.zzija);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zziiv;
        private int zziio;
        private boolean zzija;
        private String zziiw;
        private String zziix;
        private String zziiy;
        private String zziiz;

        public Builder(int n, int n2) {
            this.zziiv = n;
            this.zziio = n2;
            this.zzija = true;
            this.zziiw = null;
            this.zziix = null;
            this.zziiy = null;
            this.zziiz = null;
        }

        public final Builder setQualityLevel(int n) {
            this.zziiv = n;
            return this;
        }

        public final Builder setCaptureMode(int n) {
            this.zziio = n;
            return this;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zziiv, this.zziio, null, null, null, null, this.zzija);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ValidCaptureModes {
    }
}

