/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zze;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new zze();

    public String getDescription();

    public Long getPlayedTimeMillis();

    @Hide
    public BitmapTeleporter zzavy();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzdxh;
        private Long zzihm;
        private Long zzihn;
        private BitmapTeleporter zziho;
        private Uri zzihp;

        public Builder() {
        }

        public final Builder setDescription(String string) {
            this.zzdxh = string;
            return this;
        }

        public final Builder setPlayedTimeMillis(long l) {
            this.zzihm = l;
            return this;
        }

        public final Builder setProgressValue(long l) {
            this.zzihn = l;
            return this;
        }

        public final Builder setCoverImage(Bitmap bitmap) {
            this.zziho = new BitmapTeleporter(bitmap);
            this.zzihp = null;
            return this;
        }

        public final Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzdxh = snapshotMetadata.getDescription();
            this.zzihm = snapshotMetadata.getPlayedTime();
            this.zzihn = snapshotMetadata.getProgressValue();
            if (this.zzihm == -1L) {
                this.zzihm = null;
            }
            this.zzihp = snapshotMetadata.getCoverImageUri();
            if (this.zzihp != null) {
                this.zziho = null;
            }
            return this;
        }

        public final SnapshotMetadataChange build() {
            return new zze(this.zzdxh, this.zzihm, this.zziho, this.zzihp, this.zzihn);
        }
    }
}

