/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import java.util.Arrays;

@Hide
public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zziea;
    private final String zzieb;
    private final String zziec;
    private final long zzied;
    private final long zziee;
    private final String zzief;
    private final Uri zzieg;
    private final Uri zzieh;
    private final PlayerEntity zziei;
    private final String zziej;
    private final String zziek;
    private final String zziel;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zziea = leaderboardScore.getRank();
        this.zzieb = (String)zzbq.checkNotNull((Object)leaderboardScore.getDisplayRank());
        this.zziec = (String)zzbq.checkNotNull((Object)leaderboardScore.getDisplayScore());
        this.zzied = leaderboardScore.getRawScore();
        this.zziee = leaderboardScore.getTimestampMillis();
        this.zzief = leaderboardScore.getScoreHolderDisplayName();
        this.zzieg = leaderboardScore.getScoreHolderIconImageUri();
        this.zzieh = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zziei = player == null ? null : (PlayerEntity)player.freeze();
        this.zziej = leaderboardScore.getScoreTag();
        this.zziek = leaderboardScore.getScoreHolderIconImageUrl();
        this.zziel = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final long getRank() {
        return this.zziea;
    }

    @Override
    public final String getDisplayRank() {
        return this.zzieb;
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzieb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.zziec;
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zziec, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.zzied;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zziee;
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zziei == null) {
            return this.zzief;
        }
        return this.zziei.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zziei == null) {
            zzh.zzb((String)this.zzief, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zziei.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zziei == null) {
            return this.zzieg;
        }
        return this.zziei.getIconImageUri();
    }

    @Override
    @Hide
    public final String getScoreHolderIconImageUrl() {
        if (this.zziei == null) {
            return this.zziek;
        }
        return this.zziei.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zziei == null) {
            return this.zzieh;
        }
        return this.zziei.getHiResImageUri();
    }

    @Override
    @Hide
    public final String getScoreHolderHiResImageUrl() {
        if (this.zziei == null) {
            return this.zziel;
        }
        return this.zziei.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        return this.zziei;
    }

    @Override
    public final String getScoreTag() {
        return this.zziej;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return Arrays.hashCode(new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzbg.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzbg.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzbg.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzbg.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzbg.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzbg.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzbg.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzbg.zzx((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }
}

