/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.flags.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.flags.IFlagProvider;
import com.google.android.gms.flags.impl.DataUtils;
import com.google.android.gms.flags.impl.SharedPreferencesFactory;

@DynamiteApi
public class FlagProviderImpl
extends IFlagProvider.Stub {
    private boolean zzacf = false;
    private SharedPreferences zzacu;

    public FlagProviderImpl() {
    }

    @Override
    public void init(IObjectWrapper iObjectWrapper) {
        Context context = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        if (this.zzacf) {
            return;
        }
        try {
            Context context2 = context.createPackageContext("com.google.android.gms", 0);
            this.zzacu = SharedPreferencesFactory.getSharedPreferences(context2);
            this.zzacf = true;
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
        catch (Exception exception) {
            String string = String.valueOf(exception.getMessage());
            Log.w((String)"FlagProviderImpl", (String)(string.length() != 0 ? "Could not retrieve sdk flags, continuing with defaults: ".concat(string) : new String("Could not retrieve sdk flags, continuing with defaults: ")));
            return;
        }
    }

    @Override
    public boolean getBooleanFlagValue(String string, boolean bl, int n) {
        if (!this.zzacf) {
            return bl;
        }
        return DataUtils.BooleanUtils.getFromSharedPreferencesNoStrict(this.zzacu, string, bl);
    }

    @Override
    public int getIntFlagValue(String string, int n, int n2) {
        if (!this.zzacf) {
            return n;
        }
        return DataUtils.IntegerUtils.getFromSharedPreferencesNoStrict(this.zzacu, string, n);
    }

    @Override
    public long getLongFlagValue(String string, long l, int n) {
        if (!this.zzacf) {
            return l;
        }
        return DataUtils.LongUtils.getFromSharedPreferencesNoStrict(this.zzacu, string, l);
    }

    @Override
    public String getStringFlagValue(String string, String string2, int n) {
        if (!this.zzacf) {
            return string2;
        }
        return DataUtils.StringUtils.getFromSharedPreferencesNoStrict(this.zzacu, string, string2);
    }
}

