/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.util.zzz;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.drive.events.zzl;
import com.google.android.gms.internal.zzbly;
import com.google.android.gms.internal.zzbms;
import com.google.android.gms.internal.zzbnk;
import com.google.android.gms.internal.zzbnr;
import com.google.android.gms.internal.zzbns;
import com.google.android.gms.internal.zzbra;
import com.google.android.gms.internal.zzbrk;
import com.google.android.gms.internal.zzbrl;
import com.google.android.gms.internal.zzbti;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Hide
public final class zzbnq
extends zzab<zzbrk> {
    private final String zzehh;
    private final Bundle zzgpr;
    protected final boolean zzgtt;
    private volatile DriveId zzgtu;
    private volatile DriveId zzgtv;
    private volatile boolean zzgtw = false;
    private GoogleApiClient.ConnectionCallbacks zzgtx;
    private Map<DriveId, Map<ChangeListener, zzbra>> zzgty = new HashMap<DriveId, Map<ChangeListener, zzbra>>();
    private Map<zzd, zzbra> zzgtz = new HashMap<zzd, zzbra>();
    private Map<DriveId, Map<zzl, zzbra>> zzgua = new HashMap<DriveId, Map<zzl, zzbra>>();
    private Map<DriveId, Map<zzl, zzbra>> zzgub = new HashMap<DriveId, Map<zzl, zzbra>>();

    public zzbnq(Context context, Looper looper, zzr zzr2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzehh = zzr2.zzami();
        this.zzgtx = connectionCallbacks;
        this.zzgpr = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzgtt = false;
                return;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = serviceInfo.name;
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzgtt = true;
                return;
            }
        }
        String string = intent.getAction();
        throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
    }

    public final boolean zzacc() {
        return !this.getContext().getPackageName().equals(this.zzehh) || !zzz.zze((Context)this.getContext(), (int)Process.myUid());
    }

    public final boolean zzalx() {
        return true;
    }

    protected final String zzhn() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected final Bundle zzabt() {
        String string = this.getContext().getPackageName();
        zzbq.checkNotNull((Object)string);
        zzbq.checkState((!this.zzamr().zzamg().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzehh)) {
            bundle.putString("proxy_package_name", this.zzehh);
        }
        bundle.putAll(this.zzgpr);
        return bundle;
    }

    protected final String zzhm() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public final DriveId zzaqj() {
        return this.zzgtu;
    }

    public final DriveId zzaqk() {
        return this.zzgtv;
    }

    public final boolean zzaql() {
        return this.zzgtw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        if (this.isConnected()) {
            try {
                ((zzbrk)this.zzalw()).zza(new zzbms());
            }
            catch (RemoteException remoteException) {}
        }
        super.disconnect();
        Map<Object, Object> map = this.zzgty;
        synchronized (map) {
            this.zzgty.clear();
        }
        map = this.zzgtz;
        synchronized (map) {
            this.zzgtz.clear();
        }
        map = this.zzgua;
        synchronized (map) {
            this.zzgua.clear();
        }
        map = this.zzgub;
        synchronized (map) {
            this.zzgub.clear();
            return;
        }
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzgtu = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzgtv = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzgtw = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final boolean zzaqm() {
        return this.zzgtt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbq.checkArgument((boolean)zzj.zza(1, driveId));
        zzbq.checkNotNull((Object)changeListener, (Object)"listener");
        zzbq.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzbra>> map = this.zzgty;
        synchronized (map) {
            zzbra zzbra2;
            Map<ChangeListener, zzbra> map2 = this.zzgty.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzbra>();
                this.zzgty.put(driveId, map2);
            }
            if ((zzbra2 = map2.get(changeListener)) == null) {
                zzbra2 = new zzbra(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzbra2);
            } else if (zzbra2.zzcw(1)) {
                return new zzbnk(googleApiClient, Status.zzftq);
            }
            zzbra2.zzcv(1);
            zzbra zzbra3 = zzbra2;
            zzbly zzbly2 = new zzbly(1, driveId);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbnq zzbnq2 = this;
            return googleApiClient2.zze((zzm)new zzbnr(zzbnq2, googleApiClient2, zzbly2, zzbra3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbq.checkArgument((boolean)zzj.zza(1, driveId));
        zzbq.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzbq.checkNotNull((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzbra>> map = this.zzgty;
        synchronized (map) {
            Map<ChangeListener, zzbra> map2 = this.zzgty.get((Object)driveId);
            if (map2 == null) {
                return new zzbnk(googleApiClient, Status.zzftq);
            }
            zzbra zzbra2 = map2.remove(changeListener);
            if (zzbra2 == null) {
                return new zzbnk(googleApiClient, Status.zzftq);
            }
            if (map2.isEmpty()) {
                this.zzgty.remove((Object)driveId);
            }
            zzbra zzbra3 = zzbra2;
            zzbti zzbti2 = new zzbti(driveId, 1);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbnq zzbnq2 = this;
            return googleApiClient2.zze((zzm)new zzbns(zzbnq2, googleApiClient2, zzbti2, zzbra3));
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.drive.internal.IDriveService");
        if (iInterface instanceof zzbrk) {
            return (zzbrk)iInterface;
        }
        return new zzbrl(iBinder2);
    }
}

