/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.util.zzz;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzh;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.events.zzv;
import com.google.android.gms.internal.zzbrp;
import com.google.android.gms.internal.zzbsf;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzd,
zzi {
    private static final zzal zzgpv = new zzal("DriveEventService", "");
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzgsa;
    zza zzgsb;
    boolean zzgsc = false;
    private int zzgsd = -1;

    protected DriveEventService(String string) {
        this.mName = string;
    }

    protected DriveEventService() {
        this(DriveEventService.class.getSimpleName());
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzgsb == null && !this.zzgsc) {
                this.zzgsc = true;
                CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzgsa = new CountDownLatch(1);
                new zzh(this, countDownLatch).start();
                try {
                    if (!countDownLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                        zzgpv.zzw("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb(this).asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzgpv.zzu("DriveEventService", "onDestroy");
        if (this.zzgsb != null) {
            Message message = this.zzgsb.zzaqd();
            this.zzgsb.sendMessage(message);
            this.zzgsb = null;
            try {
                if (!this.zzgsa.await(5000L, TimeUnit.MILLISECONDS)) {
                    zzgpv.zzv("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {}
            this.zzgsa = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent changeEvent) {
        zzgpv.zzc("DriveEventService", "Unhandled change event in %s: %s", new Object[]{this.mName, changeEvent});
    }

    @Override
    @Hide
    public final void zza(com.google.android.gms.drive.events.zzb zzb2) {
        zzgpv.zzc("DriveEventService", "Unhandled changes available event in %s: %s", new Object[]{this.mName, zzb2});
    }

    @Override
    public void onCompletion(CompletionEvent completionEvent) {
        zzgpv.zzc("DriveEventService", "Unhandled completion event in %s: %s", new Object[]{this.mName, completionEvent});
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private final void zza(zzbsf zzbsf2) {
        DriveEvent driveEvent = zzbsf2.zzaqq();
        zzgpv.zzb("DriveEventService", "handleEventMessage: %s", new Object[]{driveEvent});
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    return;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    return;
                }
                case 4: {
                    this.zza((com.google.android.gms.drive.events.zzb)driveEvent);
                    return;
                }
                case 7: {
                    zzv zzv2 = (zzv)driveEvent;
                    DriveEventService driveEventService = this;
                    zzgpv.zzc("DriveEventService", "Unhandled transfer state event in %s: %s", new Object[]{driveEventService.mName, zzv2});
                    return;
                }
            }
            zzgpv.zzc("DriveEventService", "Unhandled event: %s", new Object[]{driveEvent});
            return;
        }
        catch (Exception exception) {
            zzgpv.zzd("DriveEventService", String.format("Error handling event in %s", this.mName), (Throwable)exception);
            return;
        }
    }

    private final void zzaqb() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzgsd) {
            return;
        }
        if (zzz.zze((Context)this, (int)n)) {
            this.zzgsd = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    static /* synthetic */ CountDownLatch zzb(DriveEventService driveEventService) {
        return driveEventService.zzgsa;
    }

    @Hide
    final class zzb
    extends zzbrp {
        private /* synthetic */ DriveEventService zzgsf;

        zzb(DriveEventService driveEventService) {
            this.zzgsf = driveEventService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zzc(zzbsf zzbsf2) throws RemoteException {
            DriveEventService driveEventService = this.zzgsf;
            synchronized (driveEventService) {
                zzgpv.zzb("DriveEventService", "onEvent: %s", new Object[]{zzbsf2});
                this.zzgsf.zzaqb();
                if (this.zzgsf.zzgsb != null) {
                    Message message = this.zzgsf.zzgsb.zzb(zzbsf2);
                    this.zzgsf.zzgsb.sendMessage(message);
                } else {
                    zzgpv.zzw("DriveEventService", "Receiving event before initialize is completed.");
                }
                return;
            }
        }
    }

    @Hide
    final class zza
    extends Handler {
        private /* synthetic */ DriveEventService zzgsf;

        zza(DriveEventService driveEventService) {
            this.zzgsf = driveEventService;
        }

        private final Message zzb(zzbsf zzbsf2) {
            return this.obtainMessage(1, (Object)zzbsf2);
        }

        private final Message zzaqd() {
            return this.obtainMessage(2);
        }

        public final void handleMessage(Message message) {
            zzgpv.zzb("DriveEventService", "handleMessage message type: %s", new Object[]{message.what});
            switch (message.what) {
                case 1: {
                    this.zzgsf.zza((zzbsf)((Object)message.obj));
                    return;
                }
                case 2: {
                    this.getLooper().quit();
                    return;
                }
            }
            zzgpv.zzc("DriveEventService", "Unexpected message type: %s", new Object[]{message.what});
        }
    }
}

