/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.zzaa;
import com.google.android.gms.cloudmessaging.zzab;
import com.google.android.gms.cloudmessaging.zzac;
import com.google.android.gms.cloudmessaging.zzad;
import com.google.android.gms.cloudmessaging.zzd;
import com.google.android.gms.cloudmessaging.zze;
import com.google.android.gms.cloudmessaging.zzu;
import com.google.android.gms.cloudmessaging.zzv;
import com.google.android.gms.cloudmessaging.zzw;
import com.google.android.gms.cloudmessaging.zzx;
import com.google.android.gms.cloudmessaging.zzy;
import com.google.android.gms.cloudmessaging.zzz;
import com.google.android.gms.internal.cloudmessaging.zza;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Rpc {
    private static int zza = 0;
    private static PendingIntent zzb;
    private static final Executor zzc;
    private static final Pattern zzd;
    private final SimpleArrayMap zze = new SimpleArrayMap();
    private final Context zzf;
    private final zzv zzg;
    private final ScheduledExecutorService zzh;
    private final Messenger zzi;
    private Messenger zzj;
    private zze zzk;

    @NonNull
    public Task<Void> messageHandled(@NonNull CloudMessage message) {
        if (this.zzg.zza() >= 233700000) {
            Integer n;
            Bundle bundle = new Bundle();
            String string = ((CloudMessage)((Object)n)).getMessageId();
            bundle.putString("google.message_id", string);
            n = ((CloudMessage)((Object)n)).zza();
            if (n != null) {
                bundle.putInt("google.product_id", n.intValue());
            }
            return zzu.zzb(this.zzf).zzc(3, bundle);
        }
        return Tasks.forException((Exception)new IOException("SERVICE_NOT_AVAILABLE"));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public Task<Bundle> send(@NonNull Bundle data) {
        void var1_1;
        if (this.zzg.zza() >= 12000000) return zzu.zzb(this.zzf).zzd(1, (Bundle)var1_1).continueWith(zzc, (Continuation)zzaa.zza);
        if (this.zzg.zzb() == 0) return Tasks.forException((Exception)new IOException("MISSING_INSTANCEID_SERVICE"));
        return this.zze((Bundle)var1_1).continueWithTask(zzc, (Continuation)new zzz(this, (Bundle)var1_1));
    }

    static {
        zzc = zzy.zza;
        zzd = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)");
    }

    /*
     * WARNING - void declaration
     */
    public Rpc(@NonNull Context context) {
        void var1_1;
        this.zzf = var1_1;
        this.zzg = new zzv((Context)var1_1);
        this.zzi = new Messenger((Handler)new zzad(this, Looper.getMainLooper()));
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        scheduledThreadPoolExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
        scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
        this.zzh = scheduledThreadPoolExecutor;
    }

    static /* synthetic */ Task zza(Bundle bundle) throws Exception {
        if (Rpc.zzi(bundle)) {
            return Tasks.forResult(null);
        }
        return Tasks.forResult((Object)bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ Task zzb(Bundle bundle, Task task) throws Exception {
        if (!task.isSuccessful() || !Rpc.zzi((Bundle)task.getResult())) {
            return task;
        }
        return this.zze(bundle).onSuccessTask(zzc, (SuccessContinuation)zzx.zza);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AnyThread
    private final Task zze(Bundle object) {
        TaskCompletionSource taskCompletionSource;
        String string;
        block14: {
            SimpleArrayMap simpleArrayMap;
            block15: {
                String string2;
                string = Rpc.zzf();
                taskCompletionSource = new TaskCompletionSource();
                simpleArrayMap = this.zze;
                synchronized (simpleArrayMap) {
                    this.zze.put((Object)string, (Object)taskCompletionSource);
                }
                simpleArrayMap = new Intent();
                simpleArrayMap.setPackage("com.google.android.gms");
                if (this.zzg.zzb() == 2) {
                    simpleArrayMap.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    simpleArrayMap.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                simpleArrayMap.putExtras(object);
                Rpc.zzg(this.zzf, (Intent)simpleArrayMap);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("|ID|");
                stringBuilder.append(string);
                stringBuilder.append("|");
                object = stringBuilder.toString();
                simpleArrayMap.putExtra("kid", (String)object);
                if (Log.isLoggable((String)"Rpc", (int)3)) {
                    object = String.valueOf(String.valueOf(simpleArrayMap.getExtras()));
                    string2 = "Sending ";
                    Log.d((String)"Rpc", (String)string2.concat((String)object));
                }
                object = this.zzi;
                simpleArrayMap.putExtra("google.messenger", (Parcelable)object);
                if (this.zzj != null || this.zzk != null) {
                    object = Message.obtain();
                    object.obj = simpleArrayMap;
                    try {
                        string2 = this.zzj;
                        if (string2 != null) {
                            string2.send((Message)object);
                            break block14;
                        } else {
                            this.zzk.zzb((Message)object);
                        }
                        break block14;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"Rpc", (int)3)) break block15;
                        Log.d((String)"Rpc", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (this.zzg.zzb() == 2) {
                this.zzf.sendBroadcast((Intent)simpleArrayMap);
            } else {
                this.zzf.startService((Intent)simpleArrayMap);
            }
        }
        object = this.zzh.schedule(new zzab(taskCompletionSource), 30L, TimeUnit.SECONDS);
        taskCompletionSource.getTask().addOnCompleteListener(zzc, (OnCompleteListener)new zzac(this, string, (ScheduledFuture)object));
        return taskCompletionSource.getTask();
    }

    private static synchronized String zzf() {
        return Integer.toString(zza++);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzc(Rpc object, Message object2) {
        if (object2 != null && ((Message)object2).obj instanceof Intent) {
            Intent intent = (Intent)((Message)object2).obj;
            intent.setExtrasClassLoader((ClassLoader)new zzd());
            if (intent.hasExtra("google.messenger")) {
                if ((intent = intent.getParcelableExtra("google.messenger")) instanceof zze) {
                    ((Rpc)object).zzk = (zze)intent;
                }
                if (intent instanceof Messenger) {
                    ((Rpc)object).zzj = (Messenger)intent;
                }
            }
            if (!zzw.zza(object2 = (intent = (Intent)((Message)object2).obj).getAction(), "com.google.android.c2dm.intent.REGISTRATION")) {
                if (!Log.isLoggable((String)"Rpc", (int)3)) return;
                object = String.valueOf(object2);
                object2 = "Unexpected response action: ";
                Log.d((String)"Rpc", (String)((String)object2).concat((String)object));
                return;
            }
            object2 = intent.getStringExtra("registration_id");
            if (object2 == null) {
                object2 = intent.getStringExtra("unregistered");
            }
            if (object2 == null) {
                String[] stringArray;
                object2 = intent.getStringExtra("error");
                if (object2 == null) {
                    object = String.valueOf(String.valueOf(intent.getExtras()));
                    object2 = "Unexpected response, no error or registration id ";
                    Log.w((String)"Rpc", (String)((String)object2).concat((String)object));
                    return;
                }
                if (Log.isLoggable((String)"Rpc", (int)3)) {
                    stringArray = "Received InstanceID error ".concat((String)object2);
                    Log.d((String)"Rpc", (String)stringArray);
                }
                if (((String)object2).startsWith("|")) {
                    stringArray = ((String)object2).split("\\|");
                    if (stringArray.length <= 2 || !zzw.zza(stringArray[1], "ID")) {
                        object = "Unexpected structured response ".concat((String)object2);
                        Log.w((String)"Rpc", (String)object);
                        return;
                    }
                    String string = stringArray[2];
                    object2 = stringArray[3];
                    if (((String)object2).startsWith(":")) {
                        object2 = ((String)object2).substring(1);
                    }
                    super.zzh(string, intent.putExtra("error", (String)object2).getExtras());
                    return;
                }
                stringArray = ((Rpc)object).zze;
                synchronized (stringArray) {
                    int n;
                    for (int i = 0; i < (n = ((Rpc)object).zze.size()); ++i) {
                        Object object3 = object;
                        super.zzh((String)((Rpc)object3).zze.keyAt(i), intent.getExtras());
                    }
                    return;
                }
            } else {
                Object object4 = zzd.matcher((CharSequence)object2);
                if (!((Matcher)object4).matches()) {
                    if (!Log.isLoggable((String)"Rpc", (int)3)) return;
                    object = "Unexpected response string: ".concat((String)object2);
                    Log.d((String)"Rpc", (String)object);
                    return;
                }
                object2 = ((Matcher)object4).group(1);
                object4 = ((Matcher)object4).group(2);
                if (object2 == null) return;
                Bundle bundle = intent.getExtras();
                bundle.putString("registration_id", (String)object4);
                super.zzh((String)object2, bundle);
                return;
            }
        }
        Log.w((String)"Rpc", (String)"Dropping invalid message");
        return;
        {
            finally {
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzd(String string, ScheduledFuture scheduledFuture, Task task) {
        task = this.zze;
        synchronized (task) {
            this.zze.remove((Object)string);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        scheduledFuture.cancel(false);
    }

    private static synchronized void zzg(Context context, Intent intent) {
        if (zzb == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzb = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)com.google.android.gms.internal.cloudmessaging.zza.zza);
        }
        intent.putExtra("app", (Parcelable)zzb);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzh(String string, @Nullable Bundle bundle) {
        SimpleArrayMap simpleArrayMap = rpc.zze;
        synchronized (simpleArrayMap) {
            Rpc rpc = (TaskCompletionSource)rpc.zze.remove((Object)string);
            if (rpc == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Missing callback for ");
                stringBuilder.append(string);
                Log.w((String)"Rpc", (String)stringBuilder.toString());
                return;
            }
            rpc.setResult(bundle);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    private static boolean zzi(Bundle bundle) {
        return bundle != null && bundle.containsKey("google.messenger");
    }
}

