/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.zze;
import com.google.android.gms.cloudmessaging.zzs;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class CloudMessagingReceiver
extends BroadcastReceiver {
    private final ExecutorService zza;

    @WorkerThread
    protected abstract int onMessageReceive(@NonNull Context var1, @NonNull CloudMessage var2);

    @NonNull
    protected Executor getBroadcastExecutor() {
        return this.zza;
    }

    public CloudMessagingReceiver() {
        com.google.android.gms.internal.cloudmessaging.zze.zza();
        NamedThreadFactory namedThreadFactory = new NamedThreadFactory("firebase-iid-executor");
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60L, timeUnit, linkedBlockingQueue, (ThreadFactory)namedThreadFactory);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.zza = Executors.unconfigurableExecutorService(threadPoolExecutor);
    }

    @WorkerThread
    protected void onNotificationDismissed(@NonNull Context context, @NonNull Bundle bundle) {
    }

    /*
     * WARNING - void declaration
     */
    public final void onReceive(@NonNull Context context, @NonNull Intent intent) {
        void var1_1;
        void var2_2;
        if (intent == null) {
            return;
        }
        boolean bl = this.isOrderedBroadcast();
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        Executor executor = this.getBroadcastExecutor();
        zze zze2 = new zze(this, (Intent)var2_2, (Context)var1_1, bl, pendingResult);
        executor.execute(zze2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final int zzb(@NonNull Context context, @NonNull Intent object) {
        if (object.getExtras() == null) {
            return 500;
        }
        Object object2 = object.getStringExtra("google.message_id");
        if (TextUtils.isEmpty((CharSequence)object2)) {
            object2 = Tasks.forResult(null);
        } else {
            Bundle bundle = new Bundle();
            bundle.putString("google.message_id", (String)object2);
            object2 = zzs.zzb(context).zzc(2, bundle);
        }
        CloudMessage cloudMessage = new CloudMessage((Intent)object);
        int n = this.onMessageReceive(context, cloudMessage);
        try {
            long l = TimeUnit.SECONDS.toMillis(1L);
            Tasks.await(object2, (long)l, (TimeUnit)TimeUnit.MILLISECONDS);
            return n;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            String string = String.valueOf(exception);
            object = String.valueOf(string);
            int n2 = ((String)object).length();
            object2 = new StringBuilder(n2 + 20);
            ((StringBuilder)object2).append("Message ack failed: ");
            ((StringBuilder)object2).append(string);
            Log.w((String)"CloudMessagingReceiver", (String)((StringBuilder)object2).toString());
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final int zzc(@NonNull Context context, @NonNull Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("pending_intent");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"CloudMessagingReceiver", (String)"Notification pending intent canceled");
            }
        }
        if ((pendingIntent = intent.getExtras()) != null) {
            pendingIntent.remove("pending_intent");
        } else {
            pendingIntent = new Bundle();
        }
        if ("com.google.firebase.messaging.NOTIFICATION_DISMISS".equals(intent.getAction())) {
            this.onNotificationDismissed(context, (Bundle)pendingIntent);
            return -1;
        }
        Log.e((String)"CloudMessagingReceiver", (String)"Unknown notification action");
        return 500;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final /* synthetic */ void zza(@NonNull Intent intent, @NonNull Context context, boolean bl, @NonNull BroadcastReceiver.PendingResult pendingResult) {
        try {
            Object object = intent.getParcelableExtra("wrapped_intent");
            boolean bl2 = object instanceof Intent;
            object = bl2 ? (Intent)object : null;
            int n = object != null ? this.zzc(context, (Intent)object) : this.zzb(context, intent);
            if (bl) {
                pendingResult.setResultCode(n);
            }
            return;
        }
        finally {
            pendingResult.finish();
        }
    }

    public static final class IntentKeys {
        @NonNull
        public static final String PENDING_INTENT = "pending_intent";
        @NonNull
        public static final String WRAPPED_INTENT = "wrapped_intent";

        private IntentKeys() {
        }
    }

    public static final class IntentActionKeys {
        @NonNull
        public static final String NOTIFICATION_OPEN = "com.google.firebase.messaging.NOTIFICATION_OPEN";
        @NonNull
        public static final String NOTIFICATION_DISMISS = "com.google.firebase.messaging.NOTIFICATION_DISMISS";

        private IntentActionKeys() {
        }
    }
}

