/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.clearcut;

import com.google.android.gms.internal.clearcut.zzbn;
import com.google.android.gms.internal.clearcut.zzdo;
import com.google.android.gms.internal.clearcut.zzft;
import com.google.android.gms.internal.clearcut.zzfz;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzfs {
    private final ByteBuffer zzgd;
    private zzbn zzrh;
    private int zzri;

    private zzfs(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzfs(ByteBuffer byteBuffer) {
        this.zzgd = byteBuffer;
        this.zzgd.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzfs zzg(byte[] byArray) {
        return zzfs.zzh(byArray, 0, byArray.length);
    }

    public static zzfs zzh(byte[] byArray, int n, int n2) {
        return new zzfs(byArray, 0, n2);
    }

    public final void zzi(int n, long l) throws IOException {
        this.zzb(n, 0);
        long l2 = l;
        this.zzn(l2);
    }

    public final void zzc(int n, int n2) throws IOException {
        this.zzb(n, 0);
        int n3 = n2;
        zzfs zzfs2 = this;
        if (n3 >= 0) {
            zzfs2.zzap(n3);
            return;
        }
        zzfs2.zzn(n3);
    }

    public final void zzb(int n, boolean bl) throws IOException {
        this.zzb(25, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzfs zzfs2 = this;
        if (!zzfs2.zzgd.hasRemaining()) {
            throw new zzft(zzfs2.zzgd.position(), zzfs2.zzgd.limit());
        }
        zzfs2.zzgd.put(by);
    }

    public final void zza(int n, String string) throws IOException {
        this.zzb(n, 2);
        String string2 = string;
        zzfs zzfs2 = this;
        try {
            int n2 = zzfs.zzz(string2.length());
            int n3 = zzfs.zzz(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzfs2.zzgd.position();
                if (zzfs2.zzgd.remaining() < n2) {
                    throw new zzft(n4 + n2, zzfs2.zzgd.limit());
                }
                zzfs2.zzgd.position(n4 + n2);
                zzfs.zzd(string2, zzfs2.zzgd);
                int n5 = zzfs2.zzgd.position();
                zzfs2.zzgd.position(n4);
                zzfs2.zzap(n5 - n4 - n2);
                zzfs2.zzgd.position(n5);
                return;
            }
            zzfs2.zzap(zzfs.zza(string2));
            zzfs.zzd(string2, zzfs2.zzgd);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzft zzft2 = new zzft(zzfs2.zzgd.position(), zzfs2.zzgd.limit());
            zzft2.initCause(bufferOverflowException);
            throw zzft2;
        }
    }

    public final void zza(int n, zzfz zzfz2) throws IOException {
        this.zzb(n, 2);
        zzfz zzfz3 = zzfz2;
        zzfs zzfs2 = this;
        zzfz zzfz4 = zzfz3;
        if (zzfz4.zzrs < 0) {
            zzfz4.zzas();
        }
        zzfs2.zzap(zzfz4.zzrs);
        zzfz3.zza(zzfs2);
    }

    public final void zze(int n, zzdo zzdo2) throws IOException {
        zzfs zzfs2 = this;
        if (zzfs2.zzrh == null) {
            zzfs2.zzrh = zzbn.zza(zzfs2.zzgd);
            zzfs2.zzri = zzfs2.zzgd.position();
        } else if (zzfs2.zzri != zzfs2.zzgd.position()) {
            zzfs2.zzrh.write(zzfs2.zzgd.array(), zzfs2.zzri, zzfs2.zzgd.position() - zzfs2.zzri);
            zzfs2.zzri = zzfs2.zzgd.position();
        }
        zzbn zzbn2 = zzfs2.zzrh;
        zzbn2.zza(n, zzdo2);
        zzbn2.flush();
        this.zzri = this.zzgd.position();
    }

    public final void zza(int n, byte[] byArray) throws IOException {
        this.zzb(n, 2);
        byte[] byArray2 = byArray;
        zzfs zzfs2 = this;
        zzfs2.zzap(byArray2.length);
        byte[] byArray3 = byArray2;
        int n2 = byArray3.length;
        byte[] byArray4 = byArray2;
        zzfs zzfs3 = zzfs2;
        if (zzfs3.zzgd.remaining() >= n2) {
            zzfs3.zzgd.put(byArray4, 0, n2);
            return;
        }
        throw new zzft(zzfs3.zzgd.position(), zzfs3.zzgd.limit());
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zzd(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public static int zzd(int n, long l) {
        return zzfs.zzr(n) + zzfs.zzo(l);
    }

    public static int zzb(int n, String string) {
        return zzfs.zzr(n) + zzfs.zzh(string);
    }

    public static int zzb(int n, zzfz zzfz2) {
        int n2 = zzfz2.zzas();
        return zzfs.zzr(n) + (zzfs.zzz(n2) + n2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzfs.zzr(n) + zzfs.zzh(byArray);
    }

    public static int zzs(int n) {
        if (n >= 0) {
            return zzfs.zzz(n);
        }
        return 10;
    }

    public static int zzh(String string) {
        int n = zzfs.zza(string);
        return zzfs.zzz(n) + n;
    }

    public static int zzh(byte[] byArray) {
        return zzfs.zzz(byArray.length) + byArray.length;
    }

    public final void zzem() {
        if (this.zzgd.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zzgd.remaining()));
        }
    }

    private final void zzao(int n) throws IOException {
        byte by = (byte)n;
        zzfs zzfs2 = this;
        if (!zzfs2.zzgd.hasRemaining()) {
            throw new zzft(zzfs2.zzgd.position(), zzfs2.zzgd.limit());
        }
        zzfs2.zzgd.put(by);
    }

    public final void zzb(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzap(n << 3 | n3);
    }

    public static int zzr(int n) {
        return zzfs.zzz(n << 3);
    }

    private final void zzap(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzao(n);
                return;
            }
            this.zzao(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    private static int zzz(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public final void zzn(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzao((int)l);
                return;
            }
            this.zzao((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzo(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public static long zzj(long l) {
        return l << 1 ^ l >> 63;
    }
}

