/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.clearcut;

import com.google.android.gms.internal.clearcut.zzav;
import com.google.android.gms.internal.clearcut.zzci;
import com.google.android.gms.internal.clearcut.zzcn;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdc
extends zzav<Long>
implements zzcn<Long>,
RandomAccess {
    private static final zzdc zzlw = new zzdc();
    private long[] zzlx;
    private int size;

    public static zzdc zzbx() {
        return zzlw;
    }

    zzdc() {
        this(new long[10], 0);
    }

    private zzdc(long[] lArray, int n) {
        this.zzlx = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzlx, n2, this.zzlx, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdc)) {
            return super.equals(object);
        }
        zzdc zzdc2 = (zzdc)object;
        if (this.size != zzdc2.size) {
            return false;
        }
        long[] lArray = zzdc2.zzlx;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzlx[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzci.zzl(this.zzlx[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzg(n);
        return this.zzlx[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzm(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
        if (this.size < this.zzlx.length) {
            System.arraycopy(this.zzlx, n, this.zzlx, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzlx, 0, lArray, 0, n);
            System.arraycopy(this.zzlx, n, lArray, n + 1, this.size - n);
            this.zzlx = lArray;
        }
        this.zzlx[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzw();
        zzci.checkNotNull(collection);
        if (!(collection instanceof zzdc)) {
            return super.addAll(collection);
        }
        zzdc zzdc2 = (zzdc)collection;
        if (zzdc2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdc2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdc2.size;
        if (n > this.zzlx.length) {
            this.zzlx = Arrays.copyOf(this.zzlx, n);
        }
        System.arraycopy(zzdc2.zzlx, 0, this.zzlx, this.size, zzdc2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzlx[i])) continue;
            System.arraycopy(this.zzlx, i + 1, this.zzlx, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzg(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
    }

    private final String zzh(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdc zzdc2 = this;
        zzdc2.zzw();
        zzdc2.zzg(n);
        long l3 = zzdc2.zzlx[n];
        zzdc2.zzlx[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdc zzdc2 = this;
        zzdc2.zzw();
        zzdc2.zzg(n);
        long l = zzdc2.zzlx[n];
        if (n < zzdc2.size - 1) {
            System.arraycopy(zzdc2.zzlx, n + 1, zzdc2.zzlx, n, zzdc2.size - n);
        }
        --zzdc2.size;
        ++zzdc2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzcn zzi(int n) {
        int n2 = n;
        zzdc zzdc2 = this;
        if (n2 < zzdc2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdc(Arrays.copyOf(zzdc2.zzlx, n2), zzdc2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzlw.zzv();
    }
}

