/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.clearcut;

import com.google.android.gms.internal.clearcut.zzav;
import com.google.android.gms.internal.clearcut.zzci;
import com.google.android.gms.internal.clearcut.zzcn;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzce
extends zzav<Float>
implements zzcn<Float>,
RandomAccess {
    private static final zzce zzjm = new zzce();
    private float[] zzjn;
    private int size;

    zzce() {
        this(new float[10], 0);
    }

    private zzce(float[] fArray, int n) {
        this.zzjn = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzjn, n2, this.zzjn, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzce)) {
            return super.equals(object);
        }
        zzce zzce2 = (zzce)object;
        if (this.size != zzce2.size) {
            return false;
        }
        float[] fArray = zzce2.zzjn;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzjn[i] == fArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzjn[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
        if (this.size < this.zzjn.length) {
            System.arraycopy(this.zzjn, n, this.zzjn, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzjn, 0, fArray, 0, n);
            System.arraycopy(this.zzjn, n, fArray, n + 1, this.size - n);
            this.zzjn = fArray;
        }
        this.zzjn[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzw();
        zzci.checkNotNull(collection);
        if (!(collection instanceof zzce)) {
            return super.addAll(collection);
        }
        zzce zzce2 = (zzce)collection;
        if (zzce2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzce2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzce2.size;
        if (n > this.zzjn.length) {
            this.zzjn = Arrays.copyOf(this.zzjn, n);
        }
        System.arraycopy(zzce2.zzjn, 0, this.zzjn, this.size, zzce2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzjn[i]))) continue;
            System.arraycopy(this.zzjn, i + 1, this.zzjn, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzg(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
    }

    private final String zzh(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzce zzce2 = this;
        zzce2.zzw();
        zzce2.zzg(n);
        float f3 = zzce2.zzjn[n];
        zzce2.zzjn[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzce zzce2 = this;
        zzce2.zzw();
        zzce2.zzg(n);
        float f = zzce2.zzjn[n];
        if (n < zzce2.size - 1) {
            System.arraycopy(zzce2.zzjn, n + 1, zzce2.zzjn, n, zzce2.size - n);
        }
        --zzce2.size;
        ++zzce2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzcn zzi(int n) {
        int n2 = n;
        zzce zzce2 = this;
        if (n2 < zzce2.size) {
            throw new IllegalArgumentException();
        }
        return new zzce(Arrays.copyOf(zzce2.zzjn, n2), zzce2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzce zzce2 = this;
        zzce2.zzg(n);
        return Float.valueOf(zzce2.zzjn[n]);
    }

    static {
        zzjm.zzv();
    }
}

