/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.clearcut;

import com.google.android.gms.internal.clearcut.zzav;
import com.google.android.gms.internal.clearcut.zzci;
import com.google.android.gms.internal.clearcut.zzcn;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzch
extends zzav<Integer>
implements zzcn<Integer>,
RandomAccess {
    private static final zzch zzkr = new zzch();
    private int[] zzks;
    private int size;

    public static zzch zzbk() {
        return zzkr;
    }

    zzch() {
        this(new int[10], 0);
    }

    private zzch(int[] nArray, int n) {
        this.zzks = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzks, n2, this.zzks, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzch)) {
            return super.equals(object);
        }
        zzch zzch2 = (zzch)object;
        if (this.size != zzch2.size) {
            return false;
        }
        int[] nArray = zzch2.zzks;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzks[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzks[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzg(n);
        return this.zzks[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzac(int n) {
        this.zzo(this.size, n);
    }

    private final void zzo(int n, int n2) {
        this.zzw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
        if (this.size < this.zzks.length) {
            System.arraycopy(this.zzks, n, this.zzks, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzks, 0, nArray, 0, n);
            System.arraycopy(this.zzks, n, nArray, n + 1, this.size - n);
            this.zzks = nArray;
        }
        this.zzks[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzw();
        zzci.checkNotNull(collection);
        if (!(collection instanceof zzch)) {
            return super.addAll(collection);
        }
        zzch zzch2 = (zzch)collection;
        if (zzch2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzch2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzch2.size;
        if (n > this.zzks.length) {
            this.zzks = Arrays.copyOf(this.zzks, n);
        }
        System.arraycopy(zzch2.zzks, 0, this.zzks, this.size, zzch2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzks[i])) continue;
            System.arraycopy(this.zzks, i + 1, this.zzks, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzg(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
    }

    private final String zzh(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzch zzch2 = this;
        zzch2.zzw();
        zzch2.zzg(n);
        int n4 = zzch2.zzks[n];
        zzch2.zzks[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzch zzch2 = this;
        zzch2.zzw();
        zzch2.zzg(n);
        int n2 = zzch2.zzks[n];
        if (n < zzch2.size - 1) {
            System.arraycopy(zzch2.zzks, n + 1, zzch2.zzks, n, zzch2.size - n);
        }
        --zzch2.size;
        ++zzch2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzo(n, n2);
    }

    @Override
    public final /* synthetic */ zzcn zzi(int n) {
        int n2 = n;
        zzch zzch2 = this;
        if (n2 < zzch2.size) {
            throw new IllegalArgumentException();
        }
        return new zzch(Arrays.copyOf(zzch2.zzks, n2), zzch2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzkr.zzv();
    }
}

