/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.clearcut;

import com.google.android.gms.internal.clearcut.zzav;
import com.google.android.gms.internal.clearcut.zzci;
import com.google.android.gms.internal.clearcut.zzcn;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzaz
extends zzav<Boolean>
implements zzcn<Boolean>,
RandomAccess {
    private static final zzaz zzfg = new zzaz();
    private boolean[] zzfh;
    private int size;

    zzaz() {
        this(new boolean[10], 0);
    }

    private zzaz(boolean[] blArray, int n) {
        this.zzfh = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzfh, n2, this.zzfh, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzaz)) {
            return super.equals(object);
        }
        zzaz zzaz2 = (zzaz)object;
        if (this.size != zzaz2.size) {
            return false;
        }
        boolean[] blArray = zzaz2.zzfh;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzfh[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzci.zzc(this.zzfh[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
        if (this.size < this.zzfh.length) {
            System.arraycopy(this.zzfh, n, this.zzfh, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzfh, 0, blArray, 0, n);
            System.arraycopy(this.zzfh, n, blArray, n + 1, this.size - n);
            this.zzfh = blArray;
        }
        this.zzfh[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzw();
        zzci.checkNotNull(collection);
        if (!(collection instanceof zzaz)) {
            return super.addAll(collection);
        }
        zzaz zzaz2 = (zzaz)collection;
        if (zzaz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzaz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzaz2.size;
        if (n > this.zzfh.length) {
            this.zzfh = Arrays.copyOf(this.zzfh, n);
        }
        System.arraycopy(zzaz2.zzfh, 0, this.zzfh, this.size, zzaz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzfh[i])) continue;
            System.arraycopy(this.zzfh, i + 1, this.zzfh, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzg(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
    }

    private final String zzh(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzaz zzaz2 = this;
        zzaz2.zzw();
        zzaz2.zzg(n);
        boolean bl3 = zzaz2.zzfh[n];
        zzaz2.zzfh[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzaz zzaz2 = this;
        zzaz2.zzw();
        zzaz2.zzg(n);
        boolean bl = zzaz2.zzfh[n];
        if (n < zzaz2.size - 1) {
            System.arraycopy(zzaz2.zzfh, n + 1, zzaz2.zzfh, n, zzaz2.size - n);
        }
        --zzaz2.size;
        ++zzaz2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzcn zzi(int n) {
        int n2 = n;
        zzaz zzaz2 = this;
        if (n2 < zzaz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzaz(Arrays.copyOf(zzaz2.zzfh, n2), zzaz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzaz zzaz2 = this;
        zzaz2.zzg(n);
        return zzaz2.zzfh[n];
    }

    static {
        zzfg.zzv();
    }
}

