/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.zza;
import com.google.android.gms.cast.internal.zzab;
import com.google.android.gms.cast.internal.zzag;
import com.google.android.gms.cast.internal.zzai;
import com.google.android.gms.cast.internal.zzak;
import com.google.android.gms.cast.internal.zzx;
import com.google.android.gms.cast.zzav;
import com.google.android.gms.cast.zzax;
import com.google.android.gms.cast.zzay;
import com.google.android.gms.cast.zzba;
import com.google.android.gms.cast.zzbe;
import com.google.android.gms.cast.zzbf;
import com.google.android.gms.cast.zzbi;
import com.google.android.gms.cast.zzbj;
import com.google.android.gms.cast.zzbk;
import com.google.android.gms.cast.zzbs;
import com.google.android.gms.cast.zzbu;
import com.google.android.gms.cast.zzq;
import com.google.android.gms.cast.zzr;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.ApiExceptionUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzdy;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@SuppressLint(value={"UseSparseArrays"})
public final class zzbt
extends GoogleApi
implements zzr {
    private static final Logger zzg = new Logger("CastClient");
    private static final Api.AbstractClientBuilder zzh = new zzbk();
    private static final Api zzi = new Api("Cast.API_CXLESS", zzh, zzak.zzb);
    @VisibleForTesting
    final zzbs zza = new zzbs(this);
    private Handler zzj;
    private boolean zzk;
    private boolean zzl;
    @VisibleForTesting
    @Nullable
    TaskCompletionSource zzb;
    @VisibleForTesting
    @Nullable
    TaskCompletionSource zzc;
    private final AtomicLong zzm;
    private final Object zzn = new Object();
    private final Object zzo = new Object();
    @Nullable
    private ApplicationMetadata zzp;
    @Nullable
    private String zzq;
    private double zzr;
    private boolean zzs;
    private int zzt;
    private int zzu;
    @Nullable
    private zzav zzv;
    private final CastDevice zzw;
    @VisibleForTesting
    final Map zzd;
    @VisibleForTesting
    final Map zze;
    private final Cast.Listener zzx;
    private final List zzy = Collections.synchronizedList(new ArrayList());
    private int zzz;
    public static final /* synthetic */ int zzf;

    @RequiresNonNull(value={"device"})
    @VisibleForTesting
    final double zzn() {
        if (((zzbt)((Object)string2)).zzw.hasCapability(2048)) {
            return 0.02;
        }
        if (((zzbt)((Object)string2)).zzw.hasCapability(4) && !((zzbt)((Object)string2)).zzw.hasCapability(1)) {
            String string2 = ((zzbt)((Object)string2)).zzw.getModelName();
            if ("Chromecast Audio".equals(string2)) {
                return 0.05;
            }
            return 0.02;
        }
        return 0.05;
    }

    @Override
    public final double zza() {
        this.zzR();
        return this.zzr;
    }

    @Override
    public final int zzb() {
        this.zzR();
        return this.zzt;
    }

    @Override
    public final int zzc() {
        this.zzR();
        return this.zzu;
    }

    static /* bridge */ /* synthetic */ Handler zzo(zzbt zzbt2) {
        if (zzbt2.zzj == null) {
            zzbt2.zzj = new zzdy(zzbt2.getLooper());
        }
        return zzbt2.zzj;
    }

    @Override
    @Nullable
    public final ApplicationMetadata zzd() {
        this.zzR();
        return this.zzp;
    }

    static /* bridge */ /* synthetic */ Cast.Listener zzp(zzbt zzbt2) {
        return zzbt2.zzx;
    }

    static /* bridge */ /* synthetic */ CastDevice zzq(zzbt zzbt2) {
        return zzbt2.zzw;
    }

    static /* bridge */ /* synthetic */ Logger zzr() {
        return zzg;
    }

    private static ApiException zzP(int n) {
        return ApiExceptionUtil.fromStatus((Status)new Status(n));
    }

    static /* bridge */ /* synthetic */ Task zzs(zzbt zzbt2, zzai zzai2) {
        return zzbt2.zzQ(zzai2);
    }

    @Override
    public final Task zze() {
        zzbt zzbt2 = this;
        ListenerHolder listenerHolder = zzbt2.registerListener(zzbt2.zza, "castDeviceControllerListenerKey");
        zzay zzay2 = new zzay(this);
        zzbe zzbe2 = zzbe.zza;
        return this.doRegisterEventListener(RegistrationMethods.builder().withHolder(listenerHolder).register((RemoteCall)zzay2).unregister((RemoteCall)zzbe2).setFeatures(new Feature[]{zzax.zzb}).setMethodKey(8428).build());
    }

    @Override
    public final Task zzf() {
        Task task = this.doWrite(TaskApiCall.builder().run((RemoteCall)zzbf.zza).setMethodKey(8403).build());
        this.zzS();
        zzbt zzbt2 = this;
        zzbt2.zzQ(zzbt2.zza);
        return task;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Task zzg(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map map = this.zze;
        synchronized (map) {
            Cast.MessageReceivedCallback messageReceivedCallback = (Cast.MessageReceivedCallback)this.zze.remove(string2);
            return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzbi(this, messageReceivedCallback, string2)).setMethodKey(8414).build());
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public final Task zzh(String string2, String string3) {
        CastUtils.throwIfInvalidNamespace(string2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 524288) {
            zzg.w("Message send failed. Message exceeds maximum size", new Object[0]);
            throw new IllegalArgumentException("Message exceeds maximum size524288");
        }
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzba(this, null, string2, string3)).setMethodKey(8405).build());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Task zzi(String string2, Cast.MessageReceivedCallback messageReceivedCallback) {
        CastUtils.throwIfInvalidNamespace(string2);
        if (messageReceivedCallback == null) return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzbj(this, string2, messageReceivedCallback)).setMethodKey(8413).build());
        Map map = this.zze;
        synchronized (map) {
            this.zze.put(string2, messageReceivedCallback);
            return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzbj(this, string2, messageReceivedCallback)).setMethodKey(8413).build());
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    private final Task zzQ(zzai zzai2) {
        zzbt zzbt2 = this;
        return zzbt2.doUnregisterEventListener((ListenerHolder.ListenerKey)Preconditions.checkNotNull((Object)zzbt2.registerListener(zzai2, "castDeviceControllerListenerKey").getListenerKey(), (Object)"Key must not be null"), 8415);
    }

    @Override
    @Nullable
    public final String zzj() {
        this.zzR();
        return this.zzq;
    }

    static /* bridge */ /* synthetic */ List zzt(zzbt zzbt2) {
        return zzbt2.zzy;
    }

    static /* bridge */ /* synthetic */ void zzu(zzbt zzbt2, ApplicationMetadata applicationMetadata) {
        zzbt2.zzp = applicationMetadata;
    }

    static /* bridge */ /* synthetic */ void zzv(zzbt zzbt2, String string2) {
        zzbt2.zzq = string2;
    }

    static /* bridge */ /* synthetic */ void zzw(zzbt zzbt2, boolean bl) {
        zzbt2.zzl = true;
    }

    static /* bridge */ /* synthetic */ void zzx(zzbt zzbt2, boolean bl) {
        zzbt2.zzk = true;
    }

    static /* bridge */ /* synthetic */ void zzy(zzbt zzbt2) {
        zzbt2.zzt = -1;
        zzbt2.zzu = -1;
        zzbt2.zzp = null;
        zzbt2.zzq = null;
        zzbt2.zzr = 0.0;
        zzbt2.zzn();
        zzbt2.zzs = false;
        zzbt2.zzv = null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzz(zzbt zzbt2, zza object) {
        void var1_4;
        String string2 = ((zza)((Object)object)).zza();
        if (!CastUtils.zze(string2, zzbt2.zzq)) {
            zzbt2.zzq = string2;
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        Object object2 = new Object[]{(boolean)var1_4, zzbt2.zzl};
        zzg.d("hasChanged=%b, mFirstApplicationStatusUpdate=%b", (Object[])object2);
        object2 = zzbt2.zzx;
        if (object2 != null && (var1_4 != false || zzbt2.zzl)) {
            ((Cast.Listener)object2).onApplicationStatusChanged();
        }
        zzbt2.zzl = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzA(zzbt zzbt2, zzab zzab2) {
        boolean bl;
        int n;
        double d;
        ApplicationMetadata applicationMetadata = zzab2.zze();
        if (!CastUtils.zze((Object)applicationMetadata, (Object)zzbt2.zzp)) {
            zzbt2.zzp = applicationMetadata;
            zzbt2.zzx.onApplicationMetadataChanged(zzbt2.zzp);
        }
        if (!Double.isNaN(d = zzab2.zzb())) {
            if (Math.abs(d - zzbt2.zzr) > 1.0E-7) {
                zzbt2.zzr = d;
                n = 1;
            } else {
                n = 0;
            }
        } else {
            n = 0;
        }
        if ((bl = zzab2.zzg()) != zzbt2.zzs) {
            zzbt2.zzs = bl;
            n = 1;
        }
        Object object = new Object[]{n != 0, zzbt2.zzk};
        zzg.d("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", (Object[])object);
        object = zzbt2.zzx;
        if (object != null && (n || zzbt2.zzk)) {
            ((Cast.Listener)object).onVolumeChanged();
        }
        Double.isNaN(zzab2.zza());
        n = zzab2.zzc();
        if (n != zzbt2.zzt) {
            zzbt2.zzt = n;
            n = 1;
        } else {
            n = 0;
        }
        object = new Object[]{n != 0, zzbt2.zzk};
        zzg.d("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", (Object[])object);
        object = zzbt2.zzx;
        if (object != null && (n || zzbt2.zzk)) {
            ((Cast.Listener)object).onActiveInputStateChanged(zzbt2.zzt);
        }
        if ((n = zzab2.zzd()) != zzbt2.zzu) {
            zzbt2.zzu = n;
            n = 1;
        } else {
            n = 0;
        }
        object = new Object[]{n != 0, zzbt2.zzk};
        zzg.d("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", (Object[])object);
        object = zzbt2.zzx;
        if (object != null && (n || zzbt2.zzk)) {
            ((Cast.Listener)object).onStandbyStateChanged(zzbt2.zzu);
        }
        if (!CastUtils.zze((Object)zzbt2.zzv, (Object)zzab2.zzf())) {
            zzbt2.zzv = zzab2.zzf();
        }
        zzbt2.zzk = false;
    }

    static /* bridge */ /* synthetic */ void zzB(zzbt zzbt2) {
        zzbt2.zzS();
    }

    static /* bridge */ /* synthetic */ void zzC(zzbt zzbt2, int n) {
        zzbt2.zzU(n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzD(zzbt zzbt2, Cast.ApplicationConnectionResult applicationConnectionResult) {
        Object object = zzbt2.zzn;
        synchronized (object) {
            TaskCompletionSource taskCompletionSource = zzbt2.zzb;
            if (taskCompletionSource != null) {
                taskCompletionSource.setResult((Object)applicationConnectionResult);
            }
            zzbt2.zzb = null;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzE(zzbt object, long l, int n) {
        TaskCompletionSource taskCompletionSource;
        block4: {
            Map map = ((zzbt)object).zzd;
            synchronized (map) {
                Long l2 = l;
                taskCompletionSource = (TaskCompletionSource)((zzbt)object).zzd.get(l2);
                object = ((zzbt)object).zzd;
                object.remove(l2);
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                if (taskCompletionSource == null) return;
                if (n != 0) break block4;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            taskCompletionSource.setResult(null);
            return;
        }
        taskCompletionSource.setException((Exception)zzbt.zzP(n));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzF(zzbt zzbt2, int n) {
        Object object = zzbt2.zzo;
        synchronized (object) {
            TaskCompletionSource taskCompletionSource = zzbt2.zzc;
            if (taskCompletionSource == null) {
                return;
            }
            if (n == 0) {
                taskCompletionSource.setResult((Object)new Status(0));
            } else {
                taskCompletionSource.setException((Exception)zzbt.zzP(n));
            }
            zzbt2.zzc = null;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    zzbt(Context context, Cast.CastOptions castOptions) {
        super(context, zzi, (Api.ApiOptions)castOptions, GoogleApi.Settings.DEFAULT_SETTINGS);
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        Preconditions.checkNotNull((Object)castOptions, (Object)"CastOptions cannot be null");
        this.zzx = castOptions.zzb;
        this.zzw = castOptions.zza;
        this.zzd = new HashMap();
        this.zze = new HashMap();
        this.zzm = new AtomicLong(0L);
        this.zzz = 1;
        this.zzn();
    }

    private final void zzR() {
        Preconditions.checkState((boolean)this.zzl(), (Object)"Not connected to device");
    }

    final /* synthetic */ void zzG(String string2, String string3, zzbu zzbu2, zzx zzx2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        this.zzR();
        ((zzag)zzx2.getService()).zzg(string2, string3, null);
        this.zzT(taskCompletionSource);
    }

    final /* synthetic */ void zzH(String string2, LaunchOptions launchOptions, zzx zzx2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        this.zzR();
        ((zzag)zzx2.getService()).zzh(string2, launchOptions);
        this.zzT(taskCompletionSource);
    }

    final /* synthetic */ void zzI(Cast.MessageReceivedCallback messageReceivedCallback, String string2, zzx zzx2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        this.zzV();
        if (messageReceivedCallback != null) {
            ((zzag)zzx2.getService()).zzr(string2);
        }
        taskCompletionSource.setResult(null);
    }

    final /* synthetic */ void zzJ(String string2, String string3, String string4, zzx zzx2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        long l = this.zzm.incrementAndGet();
        this.zzR();
        try {
            this.zzd.put(l, taskCompletionSource);
            ((zzag)zzx2.getService()).zzm(string3, string4, l);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzd.remove(l);
            taskCompletionSource.setException((Exception)((Object)remoteException));
            return;
        }
    }

    final /* synthetic */ void zzK(String string2, Cast.MessageReceivedCallback messageReceivedCallback, zzx zzx2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        this.zzV();
        ((zzag)zzx2.getService()).zzr(string2);
        if (messageReceivedCallback != null) {
            ((zzag)zzx2.getService()).zzk(string2);
        }
        taskCompletionSource.setResult(null);
    }

    final /* synthetic */ void zzL(boolean bl, zzx zzx2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        ((zzag)zzx2.getService()).zzn(bl, this.zzr, this.zzs);
        taskCompletionSource.setResult(null);
    }

    final /* synthetic */ void zzM(double d, zzx zzx2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        ((zzag)zzx2.getService()).zzo(d, this.zzr, this.zzs);
        taskCompletionSource.setResult(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzN(String object, zzx zzx2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        this.zzR();
        ((zzag)zzx2.getService()).zzp((String)object);
        object = this.zzo;
        synchronized (object) {
            zzx2 = this.zzc;
            if (zzx2 != null) {
                taskCompletionSource.setException((Exception)zzbt.zzP(2001));
                return;
            }
            this.zzc = taskCompletionSource;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public final void zzk(zzq zzq2) {
        Preconditions.checkNotNull((Object)zzq2);
        this.zzy.add(zzq2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzS() {
        zzg.d("removing all MessageReceivedCallbacks", new Object[0]);
        Map map = this.zze;
        synchronized (map) {
            this.zze.clear();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzT(TaskCompletionSource taskCompletionSource) {
        Object object = this.zzn;
        synchronized (object) {
            TaskCompletionSource taskCompletionSource2 = this.zzb;
            if (taskCompletionSource2 != null) {
                this.zzU(2477);
            }
            this.zzb = taskCompletionSource;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzU(int n) {
        Object object = this.zzn;
        synchronized (object) {
            TaskCompletionSource taskCompletionSource = this.zzb;
            if (taskCompletionSource != null) {
                taskCompletionSource.setException((Exception)zzbt.zzP(n));
            }
            this.zzb = null;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzV() {
        boolean bl = this.zzz != 1;
        Preconditions.checkState((boolean)bl, (Object)"Not active connection");
    }

    @Override
    public final boolean zzl() {
        return this.zzz == 2;
    }

    @Override
    public final boolean zzm() {
        this.zzR();
        return this.zzs;
    }

    static /* bridge */ /* synthetic */ void zzO(zzbt zzbt2, int n) {
        zzbt2.zzz = n;
    }
}

