/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.zza;
import com.google.android.gms.cast.internal.zzab;
import com.google.android.gms.cast.internal.zzag;
import com.google.android.gms.cast.internal.zzq;
import com.google.android.gms.cast.internal.zzv;
import com.google.android.gms.cast.zzav;
import com.google.android.gms.cast.zzbu;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class zzw
extends GmsClient {
    private static final Logger zze = new Logger("CastClientImpl");
    private static final Object zzf = new Object();
    private static final Object zzg = new Object();
    private ApplicationMetadata zzh;
    private final CastDevice zzi;
    private final Cast.Listener zzj;
    private final Map zzk;
    private final long zzl;
    private final Bundle zzm;
    private zzv zzn;
    private String zzo;
    private boolean zzp;
    private boolean zzq;
    private boolean zzr;
    private boolean zzs;
    private double zzt;
    private zzav zzu;
    private int zzv;
    private int zzw;
    private final AtomicLong zzx;
    private String zzy;
    private String zzz;
    private Bundle zzA;
    private final Map zzB;
    private BaseImplementation.ResultHolder zzC;
    private BaseImplementation.ResultHolder zzD;

    @VisibleForTesting
    final double zzp() {
        Preconditions.checkNotNull((Object)((Object)object.zzi), (Object)"device should not be null");
        if (object.zzi.hasCapability(2048)) {
            return 0.02;
        }
        if (object.zzi.hasCapability(4) && !object.zzi.hasCapability(1)) {
            Object object = object.zzi.getModelName();
            if ("Chromecast Audio".equals(object)) {
                return 0.05;
            }
            return 0.02;
        }
        return 0.05;
    }

    public final double zzq() throws IllegalStateException {
        this.checkConnected();
        return this.zzt;
    }

    public final int zzr() throws IllegalStateException {
        this.checkConnected();
        return this.zzv;
    }

    public final int getMinApkVersion() {
        return 12800000;
    }

    public final int zzs() throws IllegalStateException {
        this.checkConnected();
        return this.zzw;
    }

    public final Bundle getConnectionHint() {
        Bundle bundle = this.zzA;
        if (bundle != null) {
            this.zzA = null;
            return bundle;
        }
        return super.getConnectionHint();
    }

    protected final Bundle getGetServiceRequestExtraArgs() {
        Bundle bundle = new Bundle();
        Object object = new Object[]{object2.zzy, object2.zzz};
        zze.d("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", (Object[])object);
        object2.zzi.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", object2.zzl);
        object = object2.zzm;
        if (object != null) {
            bundle.putAll(object);
        }
        object2.zzn = new zzv((zzw)((Object)object2));
        object = new BinderWrapper((IBinder)object2.zzn);
        bundle.putParcelable("listener", (Parcelable)object);
        object = object2.zzy;
        if (object != null) {
            bundle.putString("last_application_id", (String)object);
            Object object2 = object2.zzz;
            if (object2 != null) {
                bundle.putString("last_session_id", (String)object2);
            }
        }
        return bundle;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        void var0_2;
        void var1_6;
        if (var1_6 == null) {
            return var0_2;
        }
        IInterface iInterface = var1_6.queryLocalInterface("com.google.android.gms.cast.internal.ICastDeviceController");
        if (iInterface instanceof zzag) {
            zzag zzag2 = (zzag)iInterface;
            return var0_2;
        }
        zzag zzag3 = new zzag((IBinder)var1_6);
        return var0_2;
    }

    public final ApplicationMetadata zzt() throws IllegalStateException {
        this.checkConnected();
        return this.zzh;
    }

    static /* bridge */ /* synthetic */ Cast.Listener zzu(zzw zzw2) {
        return zzw2.zzj;
    }

    static /* bridge */ /* synthetic */ CastDevice zzv(zzw zzw2) {
        return zzw2.zzi;
    }

    static /* bridge */ /* synthetic */ Logger zzw() {
        return zze;
    }

    static /* bridge */ /* synthetic */ BaseImplementation.ResultHolder zzx(zzw zzw2) {
        return zzw2.zzC;
    }

    static /* bridge */ /* synthetic */ Object zzy() {
        return zzf;
    }

    public final String zzz() throws IllegalStateException {
        this.checkConnected();
        return this.zzo;
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    static /* bridge */ /* synthetic */ Map zzA(zzw zzw2) {
        return zzw2.zzk;
    }

    static /* bridge */ /* synthetic */ void zzB(zzw zzw2, ApplicationMetadata applicationMetadata) {
        zzw2.zzh = applicationMetadata;
    }

    static /* bridge */ /* synthetic */ void zzC(zzw zzw2, String string2) {
        zzw2.zzo = string2;
    }

    static /* bridge */ /* synthetic */ void zzD(zzw zzw2, String string2) {
        zzw2.zzy = string2;
    }

    static /* bridge */ /* synthetic */ void zzE(zzw zzw2, String string2) {
        zzw2.zzz = string2;
    }

    static /* bridge */ /* synthetic */ void zzF(zzw zzw2, BaseImplementation.ResultHolder resultHolder) {
        zzw2.zzC = null;
    }

    static /* bridge */ /* synthetic */ void zzG(zzw zzw2) {
        zzw2.zzY();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzH(zzw zzw2, zza object) {
        void var1_4;
        String string2 = ((zza)((Object)object)).zza();
        if (!CastUtils.zze(string2, zzw2.zzo)) {
            zzw2.zzo = string2;
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        Object object2 = new Object[]{(boolean)var1_4, zzw2.zzq};
        zze.d("hasChanged=%b, mFirstApplicationStatusUpdate=%b", (Object[])object2);
        object2 = zzw2.zzj;
        if (object2 != null && (var1_4 != false || zzw2.zzq)) {
            ((Cast.Listener)object2).onApplicationStatusChanged();
        }
        zzw2.zzq = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzI(zzw zzw2, zzab zzab2) {
        boolean bl;
        int n;
        double d;
        ApplicationMetadata applicationMetadata = zzab2.zze();
        if (!CastUtils.zze((Object)applicationMetadata, (Object)zzw2.zzh)) {
            zzw2.zzh = applicationMetadata;
            zzw2.zzj.onApplicationMetadataChanged(zzw2.zzh);
        }
        if (!Double.isNaN(d = zzab2.zzb())) {
            if (Math.abs(d - zzw2.zzt) > 1.0E-7) {
                zzw2.zzt = d;
                n = 1;
            } else {
                n = 0;
            }
        } else {
            n = 0;
        }
        if ((bl = zzab2.zzg()) != zzw2.zzp) {
            zzw2.zzp = bl;
            n = 1;
        }
        Double.isNaN(zzab2.zza());
        Object object = new Object[]{n != 0, zzw2.zzr};
        zze.d("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", (Object[])object);
        object = zzw2.zzj;
        if (object != null && (n || zzw2.zzr)) {
            ((Cast.Listener)object).onVolumeChanged();
        }
        if ((n = zzab2.zzc()) != zzw2.zzv) {
            zzw2.zzv = n;
            n = 1;
        } else {
            n = 0;
        }
        object = new Object[]{n != 0, zzw2.zzr};
        zze.d("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", (Object[])object);
        object = zzw2.zzj;
        if (object != null && (n || zzw2.zzr)) {
            ((Cast.Listener)object).onActiveInputStateChanged(zzw2.zzv);
        }
        if ((n = zzab2.zzd()) != zzw2.zzw) {
            zzw2.zzw = n;
            n = 1;
        } else {
            n = 0;
        }
        object = new Object[]{n != 0, zzw2.zzr};
        zze.d("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", (Object[])object);
        object = zzw2.zzj;
        if (object != null && (n || zzw2.zzr)) {
            ((Cast.Listener)object).onStandbyStateChanged(zzw2.zzw);
        }
        if (!CastUtils.zze((Object)zzw2.zzu, (Object)zzab2.zzf())) {
            zzw2.zzu = zzab2.zzf();
        }
        zzw2.zzr = false;
    }

    static /* bridge */ /* synthetic */ void zzJ(zzw zzw2, long l, int n) {
        zzw2.zzaa(l, n);
    }

    static /* bridge */ /* synthetic */ void zzK(zzw zzw2, int n) {
        zzw2.zzab(n);
    }

    public zzw(Context context, Looper looper, ClientSettings clientSettings, CastDevice castDevice, long l, Cast.Listener listener, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzi = castDevice;
        this.zzj = listener;
        this.zzl = l;
        this.zzm = bundle;
        this.zzk = new HashMap();
        this.zzx = new AtomicLong(0L);
        this.zzB = new HashMap();
        this.zzY();
        this.zzp();
    }

    private final void zzY() {
        this.zzs = false;
        this.zzv = -1;
        this.zzw = -1;
        this.zzh = null;
        this.zzo = null;
        this.zzt = 0.0;
        this.zzp();
        this.zzp = false;
        this.zzu = null;
    }

    public final void disconnect() {
        Object object = new Object[]{objectArray.zzn, objectArray.isConnected()};
        zze.d("disconnect(); ServiceListener=%s, isConnected=%b", (Object[])object);
        object = objectArray.zzn;
        objectArray.zzn = null;
        if (object == null || ((zzv)object).zzq() == null) {
            Object[] objectArray = new Object[]{};
            zze.d("already disposed, so short-circuiting", objectArray);
            return;
        }
        super.zzZ();
        try {
            ((zzag)objectArray.getService()).zzf();
        }
        catch (RemoteException | IllegalStateException throwable) {
            try {
                zze.d(throwable, "Error while disconnecting the controller interface", new Object[0]);
            }
            catch (Throwable throwable2) {
                super.disconnect();
                throw throwable2;
            }
        }
        super.disconnect();
        return;
        super.disconnect();
    }

    public final void zzL(String string2, String string3, zzbu zzbu2, BaseImplementation.ResultHolder object) throws IllegalStateException, RemoteException {
        this.zzac((BaseImplementation.ResultHolder)object);
        zzbu2 = new zzbu();
        object = (zzag)this.getService();
        if (this.zzW()) {
            ((zzag)object).zzg(string2, string3, zzbu2);
            return;
        }
        this.zzR(2016);
    }

    public final void zzM(String string2, LaunchOptions launchOptions, BaseImplementation.ResultHolder object) throws IllegalStateException, RemoteException {
        this.zzac((BaseImplementation.ResultHolder)object);
        object = (zzag)this.getService();
        if (this.zzW()) {
            ((zzag)object).zzh(string2, launchOptions);
            return;
        }
        this.zzR(2016);
    }

    public final void zzN(BaseImplementation.ResultHolder object) throws IllegalStateException, RemoteException {
        this.zzad((BaseImplementation.ResultHolder)object);
        object = (zzag)this.getService();
        if (this.zzW()) {
            ((zzag)object).zzi();
            return;
        }
        this.zzab(2016);
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzZ();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        Object[] objectArray = new Object[]{n};
        zze.d("in onPostInitHandler; statusCode=%d", objectArray);
        if (n == 0 || n == 2300) {
            this.zzs = true;
            this.zzq = true;
            this.zzr = true;
        } else {
            this.zzs = false;
        }
        if (n == 2300) {
            this.zzA = new Bundle();
            this.zzA.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n = 0;
        }
        super.onPostInitHandler(n, iBinder, bundle, n2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzZ() {
        zze.d("removing all MessageReceivedCallbacks", new Object[0]);
        Map map = this.zzk;
        synchronized (map) {
            this.zzk.clear();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzO(String string2) throws IllegalArgumentException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Object[] objectArray = this.zzk;
        // MONITORENTER : objectArray
        Cast.MessageReceivedCallback messageReceivedCallback = (Cast.MessageReceivedCallback)this.zzk.remove(string2);
        // MONITOREXIT : objectArray
        if (messageReceivedCallback == null) return;
        try {
            ((zzag)this.getService()).zzr(string2);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            objectArray = new Object[]{string2};
            zze.d(illegalStateException, "Error unregistering namespace (%s)", objectArray);
            return;
        }
    }

    public final void zzP() throws IllegalStateException, RemoteException {
        zzag zzag2 = (zzag)this.getService();
        if (this.zzW()) {
            zzag2.zzl();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzQ(String string2, String string3, BaseImplementation.ResultHolder object) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 524288) {
            zze.w("Message send failed. Message exceeds maximum size", new Object[0]);
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        CastUtils.throwIfInvalidNamespace(string2);
        long l = this.zzx.incrementAndGet();
        try {
            this.zzB.put(l, object);
            object = (zzag)this.getService();
            boolean bl = this.zzW();
            if (bl) {
                ((zzag)object).zzm(string2, string3, l);
                return;
            }
        }
        catch (Throwable throwable) {
            this.zzB.remove(l);
            throw throwable;
        }
        {
            this.zzaa(l, 2016);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzR(int n) {
        Object object = zzf;
        synchronized (object) {
            BaseImplementation.ResultHolder resultHolder = this.zzC;
            if (resultHolder == null) return;
            Status status = new Status(n);
            zzq zzq2 = new zzq(status, null, null, null, false);
            resultHolder.setResult((Object)zzq2);
            this.zzC = null;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzS(String string2, Cast.MessageReceivedCallback object) throws IllegalArgumentException, IllegalStateException, RemoteException {
        CastUtils.throwIfInvalidNamespace(string2);
        this.zzO(string2);
        if (object == null) return;
        Map map = this.zzk;
        synchronized (map) {
            this.zzk.put(string2, object);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        object = (zzag)this.getService();
        if (!this.zzW()) return;
        ((zzag)object).zzk(string2);
    }

    public final void zzT(boolean bl) throws IllegalStateException, RemoteException {
        zzag zzag2 = (zzag)this.getService();
        if (this.zzW()) {
            zzag2.zzn(bl, this.zzt, this.zzp);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzaa(long l, int n) {
        Map map = zzw2.zzB;
        synchronized (map) {
            zzw zzw2 = (BaseImplementation.ResultHolder)zzw2.zzB.remove(l);
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl5 : MonitorExitStatement: MONITOREXIT : var4_4
            if (zzw2 == null) return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        zzw2.setResult(new Status(n));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzab(int n) {
        Object object = zzg;
        synchronized (object) {
            BaseImplementation.ResultHolder resultHolder = this.zzD;
            if (resultHolder == null) return;
            resultHolder.setResult((Object)new Status(n));
            this.zzD = null;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzU(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Volume cannot be ");
            stringBuilder.append(d);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        zzag zzag2 = (zzag)this.getService();
        if (this.zzW()) {
            zzag2.zzo(d, this.zzt, this.zzp);
            return;
        }
    }

    public final void zzV(String string2, BaseImplementation.ResultHolder object) throws IllegalStateException, RemoteException {
        this.zzad((BaseImplementation.ResultHolder)object);
        object = (zzag)this.getService();
        if (this.zzW()) {
            ((zzag)object).zzp(string2);
            return;
        }
        this.zzab(2016);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzac(BaseImplementation.ResultHolder resultHolder) {
        Object object = zzf;
        synchronized (object) {
            BaseImplementation.ResultHolder resultHolder2 = this.zzC;
            if (resultHolder2 != null) {
                Status status = new Status(2477);
                zzq zzq2 = new zzq(status, null, null, null, false);
                resultHolder2.setResult((Object)zzq2);
            }
            this.zzC = resultHolder;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzad(BaseImplementation.ResultHolder resultHolder) {
        Object object = zzg;
        synchronized (object) {
            BaseImplementation.ResultHolder resultHolder2 = this.zzD;
            if (resultHolder2 != null) {
                resultHolder.setResult((Object)new Status(2001));
                return;
            }
            this.zzD = resultHolder;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @VisibleForTesting
    final boolean zzW() {
        return ((zzw)((Object)this)).zzs && (this = ((zzw)((Object)this)).zzn) != null && !((zzv)this).zzr();
    }

    public final boolean zzX() throws IllegalStateException {
        this.checkConnected();
        return this.zzp;
    }
}

