/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaError;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadRequestData;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaSeekOptions;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.media.MediaCommon;
import com.google.android.gms.cast.internal.zzal;
import com.google.android.gms.cast.internal.zzam;
import com.google.android.gms.cast.internal.zzan;
import com.google.android.gms.cast.internal.zzao;
import com.google.android.gms.cast.internal.zzap;
import com.google.android.gms.cast.internal.zzat;
import com.google.android.gms.cast.internal.zzav;
import com.google.android.gms.cast.internal.zzd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzaq
extends zzd {
    public static final String zzb = "urn:x-cast:com.google.cast.media";
    private long zzv;
    @Nullable
    private MediaStatus zzw;
    @Nullable
    private Long zzx;
    private zzan zzy;
    private int zzz = -1;
    @VisibleForTesting
    final zzav zzc = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzd = new zzav(86400000L);
    @VisibleForTesting
    final zzav zze = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzf = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzg = new zzav(10000L);
    @VisibleForTesting
    final zzav zzh = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzi = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzj = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzk = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzl = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzm = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzn = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzo = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzp = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzq = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzr;
    @VisibleForTesting
    final zzav zzs = new zzav(86400000L);
    @VisibleForTesting
    final zzav zzt;
    @VisibleForTesting
    final zzav zzu;

    static /* bridge */ /* synthetic */ int zzi(zzaq zzaq2) {
        return zzaq2.zzz;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final long zzR(double d, long l, long l2) {
        long l3 = SystemClock.elapsedRealtime() - this.zzv;
        long l4 = l3 < 0L ? 0L : l3;
        if (l4 == 0L) {
            return l;
        }
        long l5 = l + (long)((double)l4 * d);
        if (l2 > 0L && l5 > l2) {
            return l2;
        }
        if (l5 < 0L) return 0L;
        return l5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long zzj() {
        double d;
        MediaStatus mediaStatus;
        if (this.zzv == 0L || (mediaStatus = this.zzw) == null) {
            return 0L;
        }
        AdBreakStatus adBreakStatus = mediaStatus.getAdBreakStatus();
        if (adBreakStatus == null) {
            return 0L;
        }
        double d2 = mediaStatus.getPlaybackRate();
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        if (mediaStatus.getPlayerState() != 2) {
            d = 0.0;
            return this.zzR(d, adBreakStatus.getCurrentBreakClipTimeInMs(), 0L);
        }
        d = d2;
        return this.zzR(d, adBreakStatus.getCurrentBreakClipTimeInMs(), 0L);
    }

    public final long zzk() {
        AbstractSafeParcelable abstractSafeParcelable = this.zzw;
        if (abstractSafeParcelable == null) {
            return 0L;
        }
        if ((abstractSafeParcelable = abstractSafeParcelable.getLiveSeekableRange()) == null) {
            return 0L;
        }
        long l = abstractSafeParcelable.getEndTime();
        if (!abstractSafeParcelable.isLiveDone()) {
            return this.zzR(1.0, l, -1L);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long zzl() {
        AbstractSafeParcelable abstractSafeParcelable = this.zzw;
        if (abstractSafeParcelable == null) {
            return 0L;
        }
        if ((abstractSafeParcelable = abstractSafeParcelable.getLiveSeekableRange()) == null) {
            return 0L;
        }
        long l = abstractSafeParcelable.getStartTime();
        long l2 = abstractSafeParcelable.isMovingWindow() ? this.zzR(1.0, l, -1L) : l;
        if (abstractSafeParcelable.isLiveDone()) {
            return Math.min(l2, abstractSafeParcelable.getEndTime());
        }
        return l2;
    }

    public final long zzm() {
        MediaStatus mediaStatus;
        MediaInfo mediaInfo = this.zzK();
        if (mediaInfo == null || (mediaStatus = this.zzw) == null) {
            return 0L;
        }
        Long l = this.zzx;
        if (l != null) {
            if (l.equals(4294967296000L)) {
                if (this.zzw.getLiveSeekableRange() != null) {
                    return Math.min(l, this.zzk());
                }
                if (this.zzo() >= 0L) {
                    return Math.min(l, this.zzo());
                }
            }
            return l;
        }
        if (this.zzv == 0L) {
            return 0L;
        }
        double d = mediaStatus.getPlaybackRate();
        long l2 = mediaStatus.getStreamPosition();
        int n = mediaStatus.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l2;
        }
        return this.zzR(d, l2, mediaInfo.getStreamDuration());
    }

    public final long zzn() throws zzao {
        Object object = object.zzw;
        if (object == null) {
            throw new zzao();
        }
        return ((MediaStatus)((Object)object)).zzb();
    }

    public final long zzo() {
        if ((this = ((zzaq)this).zzK()) != null) {
            return ((MediaInfo)((Object)this)).getStreamDuration();
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzp(zzat zzat2, MediaLoadRequestData mediaLoadRequestData) throws IllegalStateException, IllegalArgumentException {
        if (mediaLoadRequestData.getMediaInfo() == null && mediaLoadRequestData.getQueueData() == null) {
            throw new IllegalArgumentException("MediaInfo and MediaQueueData should not be both null");
        }
        if ((mediaLoadRequestData = mediaLoadRequestData.toJson()) == null) {
            throw new IllegalArgumentException("Failed to jsonify the load request due to malformed request");
        }
        long l = this.zzd();
        try {
            mediaLoadRequestData.put("requestId", l);
            mediaLoadRequestData.put("type", "LOAD");
        }
        catch (JSONException jSONException) {}
        this.zzg(mediaLoadRequestData.toString(), l, null);
        this.zzc.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzq(zzat zzat2, @Nullable JSONObject jSONObject) throws IllegalStateException, zzao {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzn());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzd.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzr(zzat zzat2, @Nullable JSONObject jSONObject) throws IllegalStateException, zzao {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzn());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zze.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzs(@Nullable String string2, @Nullable List list) throws IllegalStateException {
        long l = this.zzd();
        list = new JSONObject();
        try {
            list.put("requestId", l);
            list.put("type", "PRECACHE");
            list.put("precacheData", string2);
        }
        catch (JSONException jSONException) {}
        this.zzg(list.toString(), l, null);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzt(zzat zzat2, int n, int n2, int n3) throws zzao, IllegalArgumentException {
        long l;
        JSONObject jSONObject;
        block4: {
            block6: {
                block7: {
                    block5: {
                        if (n2 > 0 && n3 == 0) break block5;
                        if (n2 != 0 || n3 <= 0) break block6;
                        break block7;
                    }
                    n3 = 0;
                }
                jSONObject = new JSONObject();
                l = this.zzd();
                try {
                    jSONObject.put("requestId", l);
                    jSONObject.put("type", (Object)"QUEUE_GET_ITEM_RANGE");
                    jSONObject.put("mediaSessionId", this.zzn());
                    jSONObject.put("itemId", n);
                    if (n2 > 0) {
                        jSONObject.put("nextCount", n2);
                    }
                    if (n3 > 0) {
                        jSONObject.put("prevCount", n3);
                    }
                    break block4;
                }
                catch (JSONException jSONException) {}
            }
            throw new IllegalArgumentException("Exactly one of nextCount and prevCount must be positive and the other must be zero");
        }
        this.zzg(jSONObject.toString(), l, null);
        this.zzs.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzu(zzat zzat2) throws zzao, IllegalStateException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"QUEUE_GET_ITEM_IDS");
            jSONObject.put("mediaSessionId", this.zzn());
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l, null);
        this.zzq.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzv(zzat zzat2, int[] nArray) throws zzao, IllegalArgumentException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"QUEUE_GET_ITEMS");
            jSONObject.put("mediaSessionId", this.zzn());
            JSONArray jSONArray = new JSONArray();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                jSONArray.put(nArray[i]);
            }
            jSONObject.put("itemIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l, null);
        this.zzr.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzw(zzat zzat2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, @Nullable JSONObject jSONObject) throws IllegalStateException, zzao, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (l != -1L && l < 0L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("playPosition can not be negative: ");
            stringBuilder.append(l);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzd();
        try {
            boolean bl;
            int n4;
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzn());
            JSONArray jSONArray = new JSONArray();
            n2 = 0;
            while (n2 < (n4 = mediaQueueItemArray.length)) {
                int n5 = n2++;
                jSONArray.put(n5, (Object)mediaQueueItemArray[n5].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", 0);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", CastUtils.millisecToSec(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
            if (bl = this.zzZ()) {
                jSONObject2.put("sequenceNumber", this.zzz);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l2, null);
        this.zzm.zzb(l2, new zzam(this, zzat2));
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzx(zzat zzat2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, @Nullable JSONObject jSONObject) throws IllegalStateException, IllegalArgumentException {
        int n3;
        if (mediaQueueItemArray == null || (n3 = mediaQueueItemArray.length) == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= n3) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid startIndex: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        if (l != -1L && l < 0L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("playPosition can not be negative: ");
            stringBuilder.append(l);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzd();
        this.zzc.zzb(l2, zzat2);
        try {
            boolean bl;
            int n4;
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            int n5 = 0;
            while (n5 < (n4 = mediaQueueItemArray.length)) {
                int n6 = n5++;
                jSONArray.put(n6, (Object)mediaQueueItemArray[n6].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            String string2 = MediaCommon.zza(n2);
            if (string2 == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Invalid repeat mode: ");
                stringBuilder.append(n2);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            jSONObject2.put("repeatMode", (Object)string2);
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", CastUtils.millisecToSec(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
            if (bl = this.zzZ()) {
                jSONObject2.put("sequenceNumber", this.zzz);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l2, null);
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzy(zzat zzat2, int[] nArray, @Nullable JSONObject jSONObject) throws IllegalStateException, zzao, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            boolean bl;
            int n;
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzn());
            JSONArray jSONArray = new JSONArray();
            int n2 = 0;
            while (n2 < (n = nArray.length)) {
                int n3 = n2++;
                jSONArray.put(n3, nArray[n3]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
            if (bl = this.zzZ()) {
                jSONObject2.put("sequenceNumber", this.zzz);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzo.zzb(l, new zzam(this, zzat2));
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzz(zzat zzat2, int[] nArray, int n, @Nullable JSONObject jSONObject) throws IllegalStateException, zzao, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            boolean bl;
            int n2;
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzn());
            JSONArray jSONArray = new JSONArray();
            int n3 = 0;
            while (n3 < (n2 = nArray.length)) {
                int n4 = n3++;
                jSONArray.put(n4, nArray[n4]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
            if (bl = this.zzZ()) {
                jSONObject2.put("sequenceNumber", this.zzz);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzp.zzb(l, new zzam(this, zzat2));
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzA(zzat zzat2, int n, long l, @Nullable MediaQueueItem[] mediaQueueItemArray, int n2, @Nullable Boolean bl, @Nullable Integer n3, @Nullable JSONObject jSONObject) throws IllegalArgumentException, IllegalStateException, zzao {
        if (l != -1L && l < 0L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("playPosition cannot be negative: ");
            stringBuilder.append(l);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzd();
        try {
            boolean bl2;
            String string2;
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzn());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && (n = mediaQueueItemArray.length) > 0) {
                int n4;
                JSONArray jSONArray = new JSONArray();
                n = 0;
                while (n < (n4 = mediaQueueItemArray.length)) {
                    int n5 = n++;
                    jSONArray.put(n5, (Object)mediaQueueItemArray[n5].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (bl != null) {
                jSONObject2.put("shuffle", (Object)bl);
            }
            if ((string2 = MediaCommon.zza(n3)) != null) {
                jSONObject2.put("repeatMode", (Object)string2);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", CastUtils.millisecToSec(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
            if (bl2 = this.zzZ()) {
                jSONObject2.put("sequenceNumber", this.zzz);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l2, null);
        this.zzn.zzb(l2, new zzam(this, zzat2));
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzB(zzat zzat2) throws IllegalStateException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            MediaStatus mediaStatus = this.zzw;
            if (mediaStatus != null) {
                String string2 = "mediaSessionId";
                jSONObject.put(string2, mediaStatus.zzb());
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l, null);
        this.zzj.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzC(zzat zzat2, MediaSeekOptions mediaSeekOptions) throws IllegalStateException, zzao {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        long l2 = mediaSeekOptions.isSeekToInfinite() ? 4294967296000L : mediaSeekOptions.getPosition();
        try {
            JSONObject jSONObject2;
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"SEEK");
            jSONObject.put("mediaSessionId", this.zzn());
            jSONObject.put("currentTime", CastUtils.millisecToSec(l2));
            int n = mediaSeekOptions.getResumeState();
            if (n == 1) {
                jSONObject.put("resumeState", (Object)"PLAYBACK_START");
            } else {
                n = mediaSeekOptions.getResumeState();
                if (n == 2) {
                    jSONObject.put("resumeState", (Object)"PLAYBACK_PAUSE");
                }
            }
            if ((jSONObject2 = mediaSeekOptions.getCustomData()) != null) {
                jSONObject.put("customData", (Object)mediaSeekOptions.getCustomData());
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l, null);
        this.zzx = l2;
        this.zzg.zzb(l, new zzal(this, zzat2));
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzD(zzat zzat2, long[] lArray) throws IllegalStateException, zzao {
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            int n;
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzn());
            JSONArray jSONArray = new JSONArray();
            int n2 = 0;
            while (n2 < (n = lArray.length)) {
                int n3 = n2++;
                jSONArray.put(n3, lArray[n3]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l, null);
        this.zzk.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzE(zzat zzat2, double d, @Nullable JSONObject jSONObject) throws IllegalStateException, zzao {
        if (this.zzw == null) {
            throw new zzao();
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_PLAYBACK_RATE");
            jSONObject2.put("playbackRate", d);
            Preconditions.checkNotNull((Object)((Object)this.zzw), (Object)"mediaStatus should not be null");
            jSONObject2.put("mediaSessionId", this.zzw.zzb());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzt.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzF(zzat zzat2, boolean bl, @Nullable JSONObject jSONObject) throws IllegalStateException, zzao {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzn());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzi.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzG(zzat zzat2, double d, @Nullable JSONObject jSONObject) throws IllegalStateException, zzao, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Volume cannot be ");
            stringBuilder.append(d);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzn());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzh.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzH(zzat zzat2, TextTrackStyle textTrackStyle) throws IllegalStateException, zzao {
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("textTrackStyle", (Object)textTrackStyle.zza());
            jSONObject.put("mediaSessionId", this.zzn());
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l, null);
        this.zzl.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzI(zzat zzat2) throws IllegalStateException, zzao {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"SKIP_AD");
            jSONObject.put("mediaSessionId", this.zzn());
        }
        catch (JSONException jSONException) {
            Object[] objectArray = new Object[]{jSONException.getMessage()};
            this.zza.w(String.format(Locale.ROOT, "Error creating SkipAd message: %s", objectArray), new Object[0]);
        }
        this.zzg(jSONObject.toString(), l, null);
        this.zzu.zzb(l, zzat2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzJ(zzat zzat2, @Nullable JSONObject jSONObject) throws IllegalStateException, zzao {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzn());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzf.zzb(l, zzat2);
        return l;
    }

    @Nullable
    public final MediaInfo zzK() {
        Object object = object.zzw;
        if (object == null) {
            return null;
        }
        return ((MediaStatus)((Object)object)).getMediaInfo();
    }

    @Nullable
    public final MediaStatus zzL() {
        return this.zzw;
    }

    static /* bridge */ /* synthetic */ zzan zzM(zzaq zzaq2) {
        return zzaq2.zzy;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static zzap zzS(JSONObject object) {
        MediaError mediaError = MediaError.zza(object);
        zzap zzap2 = new zzap();
        String string2 = "customData";
        object = object.has(string2) ? object.optJSONObject(string2) : null;
        zzap2.zza = object;
        zzap2.zzb = mediaError;
        return zzap2;
    }

    static /* bridge */ /* synthetic */ void zzN(zzaq zzaq2, Long l) {
        zzaq2.zzx = null;
    }

    public zzaq(@Nullable String string2) {
        super(zzb, "MediaControlChannel", null);
        this.zzr = new zzav(86400000L);
        this.zzt = new zzav(86400000L);
        this.zzu = new zzav(86400000L);
        zzaq zzaq2 = this;
        zzaq2.zzc(zzaq2.zzc);
        zzaq zzaq3 = this;
        zzaq3.zzc(zzaq3.zzd);
        zzaq zzaq4 = this;
        zzaq4.zzc(zzaq4.zze);
        zzaq zzaq5 = this;
        zzaq5.zzc(zzaq5.zzf);
        zzaq zzaq6 = this;
        zzaq6.zzc(zzaq6.zzg);
        zzaq zzaq7 = this;
        zzaq7.zzc(zzaq7.zzh);
        zzaq zzaq8 = this;
        zzaq8.zzc(zzaq8.zzi);
        zzaq zzaq9 = this;
        zzaq9.zzc(zzaq9.zzj);
        zzaq zzaq10 = this;
        zzaq10.zzc(zzaq10.zzk);
        zzaq zzaq11 = this;
        zzaq11.zzc(zzaq11.zzl);
        zzaq zzaq12 = this;
        zzaq12.zzc(zzaq12.zzm);
        zzaq zzaq13 = this;
        zzaq13.zzc(zzaq13.zzn);
        zzaq zzaq14 = this;
        zzaq14.zzc(zzaq14.zzo);
        zzaq zzaq15 = this;
        zzaq15.zzc(zzaq15.zzp);
        zzaq zzaq16 = this;
        zzaq16.zzc(zzaq16.zzq);
        zzaq zzaq17 = this;
        zzaq17.zzc(zzaq17.zzs);
        zzaq zzaq18 = this;
        zzaq18.zzc(zzaq18.zzs);
        zzaq zzaq19 = this;
        zzaq19.zzc(zzaq19.zzt);
        zzaq zzaq20 = this;
        zzaq20.zzc(zzaq20.zzu);
        this.zzT();
    }

    private final void zzT() {
        ((zzaq)((Object)iterator)).zzv = 0L;
        ((zzaq)((Object)iterator)).zzw = null;
        Iterator iterator = ((zzd)((Object)iterator)).zza().iterator();
        while (iterator.hasNext()) {
            ((zzav)iterator.next()).zzc(2002);
        }
    }

    private final void zzU(JSONObject jSONObject, String string2) {
        if (jSONObject.has("sequenceNumber")) {
            this.zzz = jSONObject.optInt("sequenceNumber", -1);
            return;
        }
        this.zza.w(string2.concat(" message is missing a sequence number."), new Object[0]);
    }

    /*
     * Exception decompiling
     */
    public final void zzO(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [71[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void zzP(long l, int n) {
        Iterator iterator = ((zzd)((Object)iterator)).zza().iterator();
        while (iterator.hasNext()) {
            ((zzav)iterator.next()).zzd(l, n, null);
        }
    }

    private final void zzV() {
        zzan zzan2 = ((zzaq)((Object)zzan2)).zzy;
        if (zzan2 != null) {
            zzan2.zzc();
            return;
        }
    }

    private final void zzW() {
        zzan zzan2 = ((zzaq)((Object)zzan2)).zzy;
        if (zzan2 != null) {
            zzan2.zzd();
            return;
        }
    }

    private final void zzX() {
        zzan zzan2 = ((zzaq)((Object)zzan2)).zzy;
        if (zzan2 != null) {
            zzan2.zzk();
            return;
        }
    }

    private final void zzY() {
        zzan zzan2 = ((zzaq)((Object)zzan2)).zzy;
        if (zzan2 != null) {
            zzan2.zzm();
            return;
        }
    }

    @Override
    public final void zzf() {
        this.zzb();
        this.zzT();
    }

    public final void zzQ(zzan zzan2) {
        this.zzy = zzan2;
    }

    private final boolean zzZ() {
        return this.zzz != -1;
    }

    @Nullable
    private static int[] zzaa(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        int[] nArray = new int[jSONArray.length()];
        int n = 0;
        while (n < jSONArray.length()) {
            int n2 = n++;
            nArray[n2] = jSONArray.getInt(n2);
        }
        return nArray;
    }
}

