/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.zzca;
import org.json.JSONObject;

public class MediaLoadOptions {
    public static final double PLAYBACK_RATE_MIN = 0.5;
    public static final double PLAYBACK_RATE_MAX = 2.0;
    private final boolean zza;
    private final long zzb;
    private final double zzc;
    @Nullable
    private final long[] zzd;
    @Nullable
    private final JSONObject zze;
    @Nullable
    private final String zzf;
    @Nullable
    private final String zzg;

    public double getPlaybackRate() {
        return this.zzc;
    }

    public long getPlayPosition() {
        return this.zzb;
    }

    @Nullable
    public String getCredentials() {
        return this.zzf;
    }

    @Nullable
    public String getCredentialsType() {
        return this.zzg;
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zze;
    }

    public boolean getAutoplay() {
        return this.zza;
    }

    @Nullable
    public long[] getActiveTrackIds() {
        return this.zzd;
    }

    /* synthetic */ MediaLoadOptions(boolean bl, long l, double d, long[] lArray, JSONObject jSONObject, String string2, String string3, zzca zzca2) {
        this.zza = bl;
        this.zzb = l;
        this.zzc = d;
        this.zzd = lArray;
        this.zze = jSONObject;
        this.zzf = string2;
        this.zzg = string3;
    }

    public static class Builder {
        private boolean zza = true;
        private long zzb = -1L;
        private double zzc = 1.0;
        private long[] zzd;
        @Nullable
        private JSONObject zze;
        @Nullable
        private String zzf;
        @Nullable
        private String zzg;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setActiveTrackIds(@NonNull long[] activeTrackIds) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAutoplay(boolean autoplay) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCredentials(@Nullable String credentials) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCredentialsType(@Nullable String credentialsType) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCustomData(@Nullable JSONObject customData) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPlayPosition(long playPosition) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPlaybackRate(double playbackRate) {
            void var1_1;
            if (Double.compare(playbackRate, 2.0) > 0 || Double.compare((double)var1_1, 0.5) < 0) {
                throw new IllegalArgumentException("playbackRate must be between PLAYBACK_RATE_MIN and PLAYBACK_RATE_MAX");
            }
            this.zzc = var1_1;
            return this;
        }

        @NonNull
        public MediaLoadOptions build() {
            return new MediaLoadOptions(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, null);
        }
    }
}

