/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.CredentialsData;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzbw;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Locale;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LaunchOptionsCreator")
public class LaunchOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<LaunchOptions> CREATOR = new zzbw();
    @SafeParcelable.Field(id=2, getter="getRelaunchIfRunning")
    private boolean zza;
    @SafeParcelable.Field(id=3, getter="getLanguage")
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getAndroidReceiverCompatible")
    private boolean zzc;
    @SafeParcelable.Field(id=5, getter="getCredentialsData")
    @Nullable
    private CredentialsData zzd;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc, this.zzd});
    }

    @Nullable
    public CredentialsData getCredentialsData() {
        return this.zzd;
    }

    @NonNull
    public String getLanguage() {
        return this.zzb;
    }

    @NonNull
    public String toString() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc};
        return String.format("LaunchOptions(relaunchIfRunning=%b, language=%s, androidReceiverCompatible: %b)", objectArray);
    }

    public LaunchOptions() {
        this(false, CastUtils.zzb(Locale.getDefault()), false, null);
    }

    @SafeParcelable.Constructor
    LaunchOptions(@SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) boolean bl2, @SafeParcelable.Param(id=5) @Nullable CredentialsData credentialsData) {
        this.zza = bl;
        this.zzb = string2;
        this.zzc = bl2;
        this.zzd = credentialsData;
    }

    /*
     * WARNING - void declaration
     */
    public void setLanguage(@NonNull String language) {
        void var1_1;
        this.zzb = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRelaunchIfRunning(boolean relaunchIfRunning) {
        void var1_1;
        this.zza = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)2, (boolean)this.getRelaunchIfRunning());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getLanguage(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.getAndroidReceiverCompatible());
        void v1 = var1_1;
        SafeParcelWriter.writeParcelable((Parcel)v1, (int)5, (Parcelable)this.getCredentialsData(), (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@Nullable Object obj) {
        LaunchOptions launchOptions;
        if (obj == this) {
            return true;
        }
        if (!(launchOptions instanceof LaunchOptions)) {
            return false;
        }
        launchOptions = launchOptions;
        return this.zza == launchOptions.zza && CastUtils.zze(this.zzb, launchOptions.zzb) && this.zzc == launchOptions.zzc && CastUtils.zze((Object)this.zzd, (Object)launchOptions.zzd);
    }

    public boolean getAndroidReceiverCompatible() {
        return this.zzc;
    }

    public boolean getRelaunchIfRunning() {
        return this.zza;
    }

    public final void zzb(boolean bl) {
        this.zzc = bl;
    }

    public static final class Builder {
        private final LaunchOptions zza;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAndroidReceiverCompatible(boolean androidReceiverCompatible) {
            void var1_1;
            this.zza.zzb((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCredentialsData(@NonNull CredentialsData credentialsData) {
            void var1_1;
            this.zza.zzd = (CredentialsData)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setLocale(@NonNull Locale locale) {
            void var1_1;
            this.zza.setLanguage(CastUtils.zzb((Locale)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRelaunchIfRunning(boolean relaunchIfRunning) {
            void var1_1;
            this.zza.setRelaunchIfRunning((boolean)var1_1);
            return this;
        }

        @NonNull
        public LaunchOptions build() {
            return this.zza;
        }

        public Builder() {
            this.zza = new LaunchOptions();
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull LaunchOptions copy) {
            void var1_1;
            this.zza = new LaunchOptions(var1_1.getRelaunchIfRunning(), var1_1.getLanguage(), var1_1.getAndroidReceiverCompatible(), var1_1.getCredentialsData());
        }
    }
}

