/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzas;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import org.json.JSONObject;

@SafeParcelable.Class(creator="CredentialsDataCreator")
public class CredentialsData
extends AbstractSafeParcelable {
    @NonNull
    public static final String CREDENTIALS_TYPE_CLOUD = "cloud";
    @NonNull
    public static final String CREDENTIALS_TYPE_ANDROID = "android";
    @NonNull
    public static final String CREDENTIALS_TYPE_IOS = "ios";
    @NonNull
    public static final String CREDENTIALS_TYPE_WEB = "web";
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<CredentialsData> CREATOR = new zzas();
    @SafeParcelable.Field(id=1, getter="getCredentials")
    @Nullable
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getCredentialsType")
    @Nullable
    private final String zzb;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb});
    }

    @KeepForSdk
    @Nullable
    public static CredentialsData fromJson(@Nullable JSONObject json) {
        Object object;
        if (json == null) {
            return null;
        }
        String string2 = CastUtils.optStringOrNull(object, "credentials");
        object = CastUtils.optStringOrNull(object, "credentialsType");
        return new CredentialsData(string2, (String)object);
    }

    @Nullable
    public String getCredentials() {
        return this.zza;
    }

    @Nullable
    public String getCredentialsType() {
        return this.zzb;
    }

    @VisibleForTesting
    @SafeParcelable.Constructor
    public CredentialsData(@SafeParcelable.Param(id=1) @Nullable String string2, @SafeParcelable.Param(id=2) @Nullable String string3) {
        this.zza = string2;
        this.zzb = string3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getCredentials(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)2, (String)this.getCredentialsType(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object other) {
        CredentialsData credentialsData;
        if (this == credentialsData) {
            return true;
        }
        if (!(credentialsData instanceof CredentialsData)) {
            return false;
        }
        credentialsData = credentialsData;
        return Objects.equal((Object)this.zza, (Object)credentialsData.zza) && Objects.equal((Object)this.zzb, (Object)credentialsData.zzb);
    }

    public static class Builder {
        private String zza;
        private String zzb = "android";

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCredentials(@NonNull String credentials) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCredentialsType(@NonNull String credentialsType) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public CredentialsData build() {
            return new CredentialsData(this.zza, this.zzb);
        }
    }
}

