/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.zzak;
import com.google.android.gms.cast.zzbt;
import com.google.android.gms.cast.zze;
import com.google.android.gms.cast.zzm;
import com.google.android.gms.cast.zzn;
import com.google.android.gms.cast.zzr;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.IOException;
import java.util.UUID;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final int ACTIVE_INPUT_STATE_UNKNOWN = -1;
    public static final int ACTIVE_INPUT_STATE_NO = 0;
    public static final int ACTIVE_INPUT_STATE_YES = 1;
    public static final int STANDBY_STATE_UNKNOWN = -1;
    public static final int STANDBY_STATE_NO = 0;
    public static final int STANDBY_STATE_YES = 1;
    @NonNull
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    @NonNull
    public static final Api<CastOptions> API;
    @NonNull
    public static final CastApi CastApi;
    @VisibleForTesting
    static final Api.AbstractClientBuilder zza;

    static {
        zza = new zze();
        API = new Api("Cast.API", zza, zzak.zza);
        CastApi = new zzm();
    }

    private Cast() {
    }

    @ShowFirstParty
    public static zzr zza(Context context, CastOptions castOptions) {
        return new zzbt(context, castOptions);
    }

    public static final class CastOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zza;
        final Listener zzb;
        final Bundle zzc;
        final int zzd;
        final String zze;

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zza, this.zzc, this.zzd, this.zze});
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public static Builder builder(@NonNull CastDevice castDevice, @NonNull Listener castListener) {
            void var1_1;
            CastDevice castDevice2;
            return new Builder(castDevice2, (Listener)var1_1);
        }

        public boolean equals(@Nullable Object object) {
            CastOptions castOptions;
            if (object == this) {
                return true;
            }
            if (!(castOptions instanceof CastOptions)) {
                return false;
            }
            castOptions = castOptions;
            return Objects.equal((Object)((Object)this.zza), (Object)((Object)castOptions.zza)) && Objects.checkBundlesEquality((Bundle)this.zzc, (Bundle)castOptions.zzc) && this.zzd == castOptions.zzd && Objects.equal((Object)this.zze, (Object)castOptions.zze);
        }

        /* synthetic */ CastOptions(Builder builder, zzn zzn2) {
            this.zza = builder.zza;
            this.zzb = builder.zzb;
            this.zzd = builder.zzc;
            this.zzc = builder.zzd;
            this.zze = UUID.randomUUID().toString();
        }

        public static final class Builder {
            final CastDevice zza;
            final Listener zzb;
            private int zzc;
            private Bundle zzd;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @NonNull
            public Builder setVerboseLoggingEnabled(boolean enabled) {
                if (enabled) {
                    this.zzc = 1;
                    return this;
                }
                this.zzc = 0;
                return this;
            }

            @NonNull
            public CastOptions build() {
                return new CastOptions(this, null);
            }

            /*
             * WARNING - void declaration
             */
            public Builder(@NonNull CastDevice castDevice, @NonNull Listener castListener) {
                void var2_2;
                void var1_1;
                Preconditions.checkNotNull((Object)var1_1, (Object)"CastDevice parameter cannot be null");
                Preconditions.checkNotNull((Object)var2_2, (Object)"CastListener parameter cannot be null");
                this.zza = var1_1;
                this.zzb = var2_2;
                this.zzc = 0;
            }

            @NonNull
            public final Builder zzc(@NonNull Bundle bundle) {
                this.zzd = bundle;
                return this;
            }
        }
    }

    @Deprecated
    public static interface CastApi {
        public double getVolume(@NonNull GoogleApiClient var1) throws IllegalStateException;

        public int getActiveInputState(@NonNull GoogleApiClient var1) throws IllegalStateException;

        public int getStandbyState(@NonNull GoogleApiClient var1) throws IllegalStateException;

        @Nullable
        public ApplicationMetadata getApplicationMetadata(@NonNull GoogleApiClient var1) throws IllegalStateException;

        @NonNull
        public PendingResult<ApplicationConnectionResult> joinApplication(@NonNull GoogleApiClient var1);

        @NonNull
        public PendingResult<ApplicationConnectionResult> joinApplication(@NonNull GoogleApiClient var1, @NonNull String var2);

        @NonNull
        public PendingResult<ApplicationConnectionResult> joinApplication(@NonNull GoogleApiClient var1, @NonNull String var2, @NonNull String var3);

        @NonNull
        public PendingResult<ApplicationConnectionResult> launchApplication(@NonNull GoogleApiClient var1, @NonNull String var2);

        @NonNull
        public PendingResult<ApplicationConnectionResult> launchApplication(@NonNull GoogleApiClient var1, @NonNull String var2, @NonNull LaunchOptions var3);

        @Deprecated
        @NonNull
        public PendingResult<ApplicationConnectionResult> launchApplication(@NonNull GoogleApiClient var1, @NonNull String var2, boolean var3);

        @NonNull
        public PendingResult<Status> leaveApplication(@NonNull GoogleApiClient var1);

        @NonNull
        public PendingResult<Status> sendMessage(@NonNull GoogleApiClient var1, @NonNull String var2, @NonNull String var3);

        @NonNull
        public PendingResult<Status> stopApplication(@NonNull GoogleApiClient var1);

        @NonNull
        public PendingResult<Status> stopApplication(@NonNull GoogleApiClient var1, @NonNull String var2);

        @Nullable
        public String getApplicationStatus(@NonNull GoogleApiClient var1) throws IllegalStateException;

        public void removeMessageReceivedCallbacks(@NonNull GoogleApiClient var1, @NonNull String var2) throws IOException, IllegalArgumentException;

        public void requestStatus(@NonNull GoogleApiClient var1) throws IOException, IllegalStateException;

        public void setMessageReceivedCallbacks(@NonNull GoogleApiClient var1, @NonNull String var2, @NonNull MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void setMute(@NonNull GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public void setVolume(@NonNull GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public boolean isMute(@NonNull GoogleApiClient var1) throws IllegalStateException;
    }

    public static interface ApplicationConnectionResult
    extends Result {
        @Nullable
        public ApplicationMetadata getApplicationMetadata();

        @Nullable
        public String getApplicationStatus();

        @Nullable
        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(@NonNull CastDevice var1, @NonNull String var2, @NonNull String var3);
    }

    public static class Listener {
        public void onActiveInputStateChanged(int n) {
        }

        public void onApplicationDisconnected(int n) {
        }

        public void onApplicationMetadataChanged(@Nullable ApplicationMetadata applicationMetadata) {
        }

        public void onApplicationStatusChanged() {
        }

        public void onDeviceNameChanged() {
        }

        public void onStandbyStateChanged(int n) {
        }

        public void onVolumeChanged() {
        }
    }
}

