/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaError;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLiveSeekableRange;
import com.google.android.gms.cast.MediaLoadRequestData;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaSeekOptions;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.media.MediaCommon;
import com.google.android.gms.cast.internal.zzam;
import com.google.android.gms.cast.internal.zzan;
import com.google.android.gms.cast.internal.zzao;
import com.google.android.gms.cast.internal.zzap;
import com.google.android.gms.cast.internal.zzaq;
import com.google.android.gms.cast.internal.zzar;
import com.google.android.gms.cast.internal.zzau;
import com.google.android.gms.cast.internal.zzaw;
import com.google.android.gms.cast.internal.zzd;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@VisibleForTesting
public final class zzas
extends zzd {
    public static final String zzb = CastUtils.zzc("com.google.cast.media");
    private long zzw;
    @Nullable
    private MediaStatus zzx;
    @Nullable
    private Long zzy;
    private zzap zzz;
    private int zzA = -1;
    @VisibleForTesting
    final zzaw zzc;
    @VisibleForTesting
    final zzaw zzd;
    @VisibleForTesting
    final zzaw zze;
    @VisibleForTesting
    final zzaw zzf;
    @VisibleForTesting
    final zzaw zzg;
    @VisibleForTesting
    final zzaw zzh;
    @VisibleForTesting
    final zzaw zzi;
    @VisibleForTesting
    final zzaw zzj;
    @VisibleForTesting
    final zzaw zzk;
    @VisibleForTesting
    final zzaw zzl;
    @VisibleForTesting
    final zzaw zzm;
    @VisibleForTesting
    final zzaw zzn;
    @VisibleForTesting
    final zzaw zzo;
    @VisibleForTesting
    final zzaw zzp;
    @VisibleForTesting
    final zzaw zzq;
    @VisibleForTesting
    final zzaw zzr;
    @VisibleForTesting
    final zzaw zzs;
    @VisibleForTesting
    final zzaw zzt;
    @VisibleForTesting
    final zzaw zzu;
    @VisibleForTesting
    final zzaw zzv;
    private TaskCompletionSource zzB;

    static /* bridge */ /* synthetic */ int zzi(zzas zzas2) {
        return zzas2.zzA;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final long zzT(double d, long l, long l2) {
        long l3 = SystemClock.elapsedRealtime() - this.zzw;
        long l4 = l3 < 0L ? 0L : l3;
        if (l4 == 0L) {
            return l;
        }
        long l5 = l + (long)((double)l4 * d);
        if (l2 > 0L && l5 > l2) {
            return l2;
        }
        if (l5 < 0L) return 0L;
        return l5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long zzj() {
        double d;
        if (this.zzw == 0L) return 0L;
        MediaStatus mediaStatus = this.zzx;
        if (mediaStatus == null) {
            return 0L;
        }
        AdBreakStatus adBreakStatus = mediaStatus.getAdBreakStatus();
        if (adBreakStatus == null) {
            return 0L;
        }
        double d2 = mediaStatus.getPlaybackRate();
        double d3 = d2 == 0.0 ? 1.0 : d2;
        if (mediaStatus.getPlayerState() != 2) {
            d = 0.0;
            return this.zzT(d, adBreakStatus.getCurrentBreakClipTimeInMs(), 0L);
        }
        d = d3;
        return this.zzT(d, adBreakStatus.getCurrentBreakClipTimeInMs(), 0L);
    }

    public final long zzk() {
        AbstractSafeParcelable abstractSafeParcelable = this.zzx;
        if (abstractSafeParcelable == null) {
            return 0L;
        }
        if ((abstractSafeParcelable = abstractSafeParcelable.getLiveSeekableRange()) == null) {
            return 0L;
        }
        long l = abstractSafeParcelable.getEndTime();
        if (!abstractSafeParcelable.isLiveDone()) {
            return this.zzT(1.0, l, -1L);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long zzl() {
        MediaStatus mediaStatus = this.zzx;
        if (mediaStatus == null) {
            return 0L;
        }
        MediaLiveSeekableRange mediaLiveSeekableRange = mediaStatus.getLiveSeekableRange();
        if (mediaLiveSeekableRange == null) {
            return 0L;
        }
        long l = mediaLiveSeekableRange.getStartTime();
        long l2 = mediaLiveSeekableRange.isMovingWindow() ? (l = this.zzT(1.0, l, -1L)) : l;
        if (mediaLiveSeekableRange.isLiveDone()) {
            return Math.min(l2, mediaLiveSeekableRange.getEndTime());
        }
        return l2;
    }

    public final long zzm() {
        MediaStatus mediaStatus;
        MediaInfo mediaInfo = this.zzK();
        if (mediaInfo == null || (mediaStatus = this.zzx) == null) {
            return 0L;
        }
        Long l = this.zzy;
        if (l != null) {
            if (l.equals(4294967296000L)) {
                if (this.zzx.getLiveSeekableRange() != null) {
                    return Math.min(l, this.zzk());
                }
                if (this.zzo() >= 0L) {
                    return Math.min(l, this.zzo());
                }
            }
            return l;
        }
        if (this.zzw == 0L) {
            return 0L;
        }
        double d = mediaStatus.getPlaybackRate();
        long l2 = mediaStatus.getStreamPosition();
        int n = mediaStatus.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l2;
        }
        return this.zzT(d, l2, mediaInfo.getStreamDuration());
    }

    public final long zzn() throws zzaq {
        Object object = object.zzx;
        if (object == null) {
            object = new zzaq();
            throw object;
        }
        return ((MediaStatus)((Object)object)).zzb();
    }

    public final long zzo() {
        if ((this = ((zzas)this).zzK()) != null) {
            return ((MediaInfo)((Object)this)).getStreamDuration();
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzp(zzau zzau2, MediaLoadRequestData mediaLoadRequestData) throws IllegalStateException, IllegalArgumentException {
        Object object;
        if (mediaLoadRequestData.getMediaInfo() == null && mediaLoadRequestData.getQueueData() == null) {
            object = new IllegalArgumentException("MediaInfo and MediaQueueData should not be both null");
            throw object;
        }
        if ((mediaLoadRequestData = mediaLoadRequestData.toJson()) == null) {
            object = new IllegalArgumentException("Failed to jsonify the load request due to malformed request");
            throw object;
        }
        long l = ((zzp)object).zzd();
        try {
            mediaLoadRequestData.put("requestId", l);
            mediaLoadRequestData.put("type", "LOAD");
        }
        catch (JSONException jSONException) {}
        ((zzp)object).zzg(mediaLoadRequestData.toString(), l, null);
        ((zzas)object).zzc.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzq(zzau zzau2, @Nullable JSONObject jSONObject) throws IllegalStateException, zzaq {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzn());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzd.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzr(zzau zzau2, @Nullable JSONObject jSONObject) throws IllegalStateException, zzaq {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzn());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zze.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzs(@Nullable String string2, @Nullable List list) throws IllegalStateException {
        long l = this.zzd();
        list = new JSONObject();
        try {
            list.put("requestId", l);
            list.put("type", "PRECACHE");
            list.put("precacheData", string2);
        }
        catch (JSONException jSONException) {}
        this.zzg(list.toString(), l, null);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzt(zzau zzau2, int n, int n2, int n3) throws zzaq, IllegalArgumentException {
        long l;
        JSONObject jSONObject;
        block4: {
            block6: {
                block7: {
                    block5: {
                        if (n2 > 0 && n3 == 0) break block5;
                        if (n2 != 0 || n3 <= 0) break block6;
                        break block7;
                    }
                    n3 = 0;
                }
                jSONObject = new JSONObject();
                l = ((zzp)object).zzd();
                try {
                    jSONObject.put("requestId", l);
                    jSONObject.put("type", (Object)"QUEUE_GET_ITEM_RANGE");
                    jSONObject.put("mediaSessionId", ((zzas)object).zzn());
                    jSONObject.put("itemId", n);
                    if (n2 > 0) {
                        jSONObject.put("nextCount", n2);
                    }
                    if (n3 > 0) {
                        jSONObject.put("prevCount", n3);
                    }
                    break block4;
                }
                catch (JSONException jSONException) {}
            }
            Object object = new IllegalArgumentException("Exactly one of nextCount and prevCount must be positive and the other must be zero");
            throw object;
        }
        ((zzp)object).zzg(jSONObject.toString(), l, null);
        ((zzas)object).zzs.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzu(zzau zzau2) throws zzaq, IllegalStateException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"QUEUE_GET_ITEM_IDS");
            jSONObject.put("mediaSessionId", this.zzn());
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l, null);
        this.zzq.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzv(zzau zzau2, int[] nArray) throws zzaq, IllegalArgumentException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"QUEUE_GET_ITEMS");
            jSONObject.put("mediaSessionId", this.zzn());
            JSONArray jSONArray = new JSONArray();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                jSONArray.put(nArray[i]);
            }
            jSONObject.put("itemIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l, null);
        this.zzr.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzw(zzau object, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, @Nullable JSONObject jSONObject) throws IllegalStateException, zzaq, IllegalArgumentException {
        Object object2;
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            object2 = new IllegalArgumentException("itemsToInsert must not be null or empty.");
            throw object2;
        }
        if (l != -1L && l < 0L) {
            object = new StringBuilder();
            ((StringBuilder)object).append("playPosition can not be negative: ");
            ((StringBuilder)object).append(l);
            object2 = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object2;
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = ((zzp)object2).zzd();
        try {
            boolean bl;
            int n4;
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", ((zzas)object2).zzn());
            JSONArray jSONArray = new JSONArray();
            for (n2 = 0; n2 < (n4 = mediaQueueItemArray.length); ++n2) {
                jSONArray.put(n2, (Object)mediaQueueItemArray[n2].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", 0);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", CastUtils.millisecToSec(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
            if (bl = super.zzab()) {
                jSONObject2.put("sequenceNumber", ((zzas)object2).zzA);
            }
        }
        catch (JSONException jSONException) {}
        ((zzp)object2).zzg(jSONObject2.toString(), l2, null);
        zzaw zzaw2 = ((zzas)object2).zzm;
        zzao zzao2 = new zzao((zzas)object2, (zzau)object);
        zzaw2.zzb(l2, zzao2);
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzx(zzau object, MediaQueueItem[] object2, int n, int n2, long l, @Nullable JSONObject jSONObject) throws IllegalStateException, IllegalArgumentException {
        Object object3;
        int n3;
        if (object2 == null || (n3 = ((Object)object2).length) == 0) {
            object3 = new IllegalArgumentException("items must not be null or empty.");
            throw object3;
        }
        if (n < 0 || n >= n3) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid startIndex: ");
            ((StringBuilder)object).append(n);
            object3 = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object3;
        }
        if (l != -1L && l < 0L) {
            object = new StringBuilder();
            ((StringBuilder)object).append("playPosition can not be negative: ");
            ((StringBuilder)object).append(l);
            object3 = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object3;
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = ((zzp)object3).zzd();
        ((zzas)object3).zzc.zzb(l2, (zzau)object);
        try {
            boolean bl;
            int n4;
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < (n4 = ((Object)object2).length); ++i) {
                jSONArray.put(i, (Object)((MediaQueueItem)((Object)object2[i])).toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            Object object4 = MediaCommon.zza(n2);
            if (object4 == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Invalid repeat mode: ");
                ((StringBuilder)object2).append(n2);
                object4 = new IllegalArgumentException(((StringBuilder)object2).toString());
                throw object4;
            }
            jSONObject2.put("repeatMode", object4);
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", CastUtils.millisecToSec(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
            if (bl = super.zzab()) {
                jSONObject2.put("sequenceNumber", ((zzas)object3).zzA);
            }
        }
        catch (JSONException jSONException) {}
        ((zzp)object3).zzg(jSONObject2.toString(), l2, null);
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzy(zzau zzau2, int[] nArray, @Nullable JSONObject object) throws IllegalStateException, zzaq, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            Object object2 = new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
            throw object2;
        }
        JSONObject jSONObject = new JSONObject();
        long l = ((zzp)object2).zzd();
        try {
            boolean bl;
            int n;
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"QUEUE_REMOVE");
            jSONObject.put("mediaSessionId", ((zzas)object2).zzn());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < (n = nArray.length); ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject.put("itemIds", (Object)jSONArray);
            if (object != null) {
                jSONObject.put("customData", object);
            }
            if (bl = super.zzab()) {
                jSONObject.put("sequenceNumber", ((zzas)object2).zzA);
            }
        }
        catch (JSONException jSONException) {}
        ((zzp)object2).zzg(jSONObject.toString(), l, null);
        zzaw zzaw2 = ((zzas)object2).zzo;
        zzao zzao2 = new zzao((zzas)object2, zzau2);
        zzaw2.zzb(l, zzao2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzz(zzau zzau2, int[] nArray, int n, @Nullable JSONObject jSONObject) throws IllegalStateException, zzaq, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            Object object = new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
            throw object;
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = ((zzp)object).zzd();
        try {
            boolean bl;
            int n2;
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", ((zzas)object).zzn());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < (n2 = nArray.length); ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
            if (bl = super.zzab()) {
                jSONObject2.put("sequenceNumber", ((zzas)object).zzA);
            }
        }
        catch (JSONException jSONException) {}
        ((zzp)object).zzg(jSONObject2.toString(), l, null);
        zzaw zzaw2 = ((zzas)object).zzp;
        zzao zzao2 = new zzao((zzas)object, zzau2);
        zzaw2.zzb(l, zzao2);
        return l;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzA(zzau object, int n, long l, @Nullable MediaQueueItem[] object2, int n2, @Nullable Boolean bl, @Nullable Integer n3, @Nullable JSONObject jSONObject) throws IllegalArgumentException, IllegalStateException, zzaq {
        void var3_5;
        if (var3_5 != -1L && var3_5 < 0L) {
            object = new StringBuilder();
            ((StringBuilder)object).append("playPosition cannot be negative: ");
            ((StringBuilder)object).append((long)var3_5);
            Object object3 = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object3;
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = ((zzp)object3).zzd();
        try {
            String string2;
            void var5_6;
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", ((zzas)object3).zzn());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (var5_6 != null && (n = ((void)var5_6).length) > 0) {
                int n4;
                JSONArray jSONArray = new JSONArray();
                for (n = 0; n < (n4 = ((void)var5_6).length); ++n) {
                    jSONArray.put(n, (Object)var5_6[n].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (bl != null) {
                jSONObject2.put("shuffle", (Object)bl);
            }
            if ((string2 = MediaCommon.zza(n3)) != null) {
                jSONObject2.put("repeatMode", (Object)string2);
            }
            if (var3_5 != -1L) {
                jSONObject2.put("currentTime", CastUtils.millisecToSec((long)var3_5));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
            if ((n = (int)(super.zzab() ? 1 : 0)) != 0) {
                jSONObject2.put("sequenceNumber", ((zzas)object3).zzA);
            }
        }
        catch (JSONException jSONException) {}
        ((zzp)object3).zzg(jSONObject2.toString(), l2, null);
        zzaw zzaw2 = ((zzas)object3).zzn;
        object2 = new zzao((zzas)object3, (zzau)object);
        zzaw2.zzb(l2, (zzau)object2);
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzB(zzau zzau2) throws IllegalStateException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            MediaStatus mediaStatus = this.zzx;
            if (mediaStatus != null) {
                String string2 = "mediaSessionId";
                jSONObject.put(string2, mediaStatus.zzb());
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l, null);
        this.zzj.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzC(zzau zzau2, MediaSeekOptions object) throws IllegalStateException, zzaq {
        long l;
        JSONObject jSONObject = new JSONObject();
        long l2 = this.zzd();
        long l3 = ((MediaSeekOptions)object).isSeekToInfinite() ? 4294967296000L : (l = ((MediaSeekOptions)object).getPosition());
        try {
            JSONObject jSONObject2;
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"SEEK");
            jSONObject.put("mediaSessionId", this.zzn());
            jSONObject.put("currentTime", CastUtils.millisecToSec(l3));
            int n = ((MediaSeekOptions)object).getResumeState();
            if (n == 1) {
                jSONObject.put("resumeState", (Object)"PLAYBACK_START");
            } else {
                n = ((MediaSeekOptions)object).getResumeState();
                if (n == 2) {
                    jSONObject.put("resumeState", (Object)"PLAYBACK_PAUSE");
                }
            }
            if ((jSONObject2 = ((MediaSeekOptions)object).getCustomData()) != null) {
                jSONObject.put("customData", (Object)((MediaSeekOptions)object).getCustomData());
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject.toString(), l2, null);
        this.zzy = l3;
        object = this.zzg;
        zzam zzam2 = new zzam(this, zzau2);
        ((zzaw)object).zzb(l2, zzam2);
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzD(zzau zzau2, long[] lArray) throws IllegalStateException, zzaq {
        if (lArray == null) {
            Object object = new IllegalArgumentException("trackIds cannot be null");
            throw object;
        }
        JSONObject jSONObject = new JSONObject();
        long l = ((zzp)object).zzd();
        try {
            int n;
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", ((zzas)object).zzn());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < (n = lArray.length); ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        ((zzp)object).zzg(jSONObject.toString(), l, null);
        ((zzas)object).zzk.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzE(zzau zzau2, double d, @Nullable JSONObject jSONObject) throws IllegalStateException, zzaq {
        if (((zzas)object).zzx == null) {
            Object object = new zzaq();
            throw object;
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = ((zzp)object).zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_PLAYBACK_RATE");
            jSONObject2.put("playbackRate", d);
            Preconditions.checkNotNull((Object)((Object)((zzas)object).zzx), (Object)"mediaStatus should not be null");
            jSONObject2.put("mediaSessionId", ((zzas)object).zzx.zzb());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        ((zzp)object).zzg(jSONObject2.toString(), l, null);
        ((zzas)object).zzt.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzF(zzau zzau2, boolean bl, @Nullable JSONObject jSONObject) throws IllegalStateException, zzaq {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzn());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzi.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzG(zzau object, double d, @Nullable JSONObject jSONObject) throws IllegalStateException, zzaq, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Volume cannot be ");
            ((StringBuilder)object).append(d);
            Object object2 = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object2;
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = ((zzp)object2).zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", ((zzas)object2).zzn());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        ((zzp)object2).zzg(jSONObject2.toString(), l, null);
        ((zzas)object2).zzh.zzb(l, (zzau)object);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzH(zzau zzau2, TextTrackStyle textTrackStyle) throws IllegalStateException, zzaq {
        if (textTrackStyle == null) {
            Object object = new IllegalArgumentException("trackStyle cannot be null");
            throw object;
        }
        JSONObject jSONObject = new JSONObject();
        long l = ((zzp)object).zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("textTrackStyle", (Object)textTrackStyle.zza());
            jSONObject.put("mediaSessionId", ((zzas)object).zzn());
        }
        catch (JSONException jSONException) {}
        ((zzp)object).zzg(jSONObject.toString(), l, null);
        ((zzas)object).zzl.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzI(zzau zzau2) throws IllegalStateException, zzaq {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"SKIP_AD");
            jSONObject.put("mediaSessionId", this.zzn());
        }
        catch (JSONException jSONException) {
            Logger logger = this.zza;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{jSONException.getMessage()};
            logger.w(String.format(locale, "Error creating SkipAd message: %s", objectArray), new Object[0]);
        }
        this.zzg(jSONObject.toString(), l, null);
        this.zzu.zzb(l, zzau2);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzJ(zzau zzau2, @Nullable JSONObject jSONObject) throws IllegalStateException, zzaq {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzd();
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzn());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zzg(jSONObject2.toString(), l, null);
        this.zzf.zzb(l, zzau2);
        return l;
    }

    @Nullable
    public final MediaInfo zzK() {
        Object object = object.zzx;
        if (object == null) {
            return null;
        }
        return ((MediaStatus)((Object)object)).getMediaInfo();
    }

    @Nullable
    public final MediaStatus zzL() {
        return this.zzx;
    }

    static /* bridge */ /* synthetic */ zzap zzM(zzas zzas2) {
        return zzas2.zzz;
    }

    private static zzar zzU(JSONObject jSONObject) {
        MediaError mediaError = MediaError.zza(jSONObject);
        zzar zzar2 = new zzar();
        zzar2.zza = CastUtils.zzg(jSONObject, "customData");
        zzar2.zzb = mediaError;
        return zzar2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Task zzN(@Nullable JSONObject object) {
        object = new JSONObject();
        long l = this.zzd();
        try {
            object.put("requestId", l);
            object.put("type", (Object)"STORE_SESSION");
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("assistant_supported", true);
            jSONObject.put("display_supported", true);
            jSONObject.put("is_group", false);
            object.put("targetDeviceCapabilities", (Object)jSONObject);
        }
        catch (JSONException jSONException) {
            this.zza.w(jSONException, "store session failed to create JSON message", new Object[0]);
        }
        try {
            this.zzg(object.toString(), l, null);
            object = this.zzv;
        }
        catch (IllegalStateException illegalStateException) {
            return Tasks.forException((Exception)illegalStateException);
        }
        zzan zzan2 = new zzan(this);
        ((zzaw)object).zzb(l, zzan2);
        object = new TaskCompletionSource();
        this.zzB = object;
        return this.zzB.getTask();
    }

    static /* bridge */ /* synthetic */ TaskCompletionSource zzO(zzas zzas2) {
        return zzas2.zzB;
    }

    static /* bridge */ /* synthetic */ void zzP(zzas zzas2, Long l) {
        zzas2.zzy = null;
    }

    public zzas(@Nullable String object) {
        super(zzb, "MediaControlChannel", null);
        this.zzc = object = new zzaw(86400000L);
        this.zzd = object = new zzaw(86400000L);
        this.zze = object = new zzaw(86400000L);
        this.zzf = object = new zzaw(86400000L);
        this.zzg = object = new zzaw(10000L);
        this.zzh = object = new zzaw(86400000L);
        this.zzi = object = new zzaw(86400000L);
        this.zzj = object = new zzaw(86400000L);
        this.zzk = object = new zzaw(86400000L);
        this.zzl = object = new zzaw(86400000L);
        this.zzm = object = new zzaw(86400000L);
        this.zzn = object = new zzaw(86400000L);
        this.zzo = object = new zzaw(86400000L);
        this.zzp = object = new zzaw(86400000L);
        this.zzq = object = new zzaw(86400000L);
        this.zzs = object = new zzaw(86400000L);
        this.zzr = object = new zzaw(86400000L);
        this.zzt = object = new zzaw(86400000L);
        this.zzu = object = new zzaw(86400000L);
        this.zzv = object = new zzaw(86400000L);
        this.zzc(this.zzc);
        this.zzc(this.zzd);
        this.zzc(this.zze);
        this.zzc(this.zzf);
        this.zzc(this.zzg);
        this.zzc(this.zzh);
        this.zzc(this.zzi);
        this.zzc(this.zzj);
        this.zzc(this.zzk);
        this.zzc(this.zzl);
        this.zzc(this.zzm);
        this.zzc(this.zzn);
        this.zzc(this.zzo);
        this.zzc(this.zzp);
        this.zzc(this.zzq);
        this.zzc(this.zzs);
        object = this.zzs;
        this.zzc((zzaw)object);
        this.zzc(this.zzt);
        this.zzc(this.zzu);
        this.zzc(this.zzv);
        this.zzV();
    }

    private final void zzV() {
        ((zzas)((Object)iterator)).zzw = 0L;
        ((zzas)((Object)iterator)).zzx = null;
        Iterator iterator = ((zzd)((Object)iterator)).zza().iterator();
        while (iterator.hasNext()) {
            ((zzaw)iterator.next()).zzc(2002);
        }
    }

    private final void zzW(JSONObject jSONObject, String string2) {
        if (jSONObject.has("sequenceNumber")) {
            this.zzA = jSONObject.optInt("sequenceNumber", -1);
            return;
        }
        this.zza.w(string2.concat(" message is missing a sequence number."), new Object[0]);
    }

    /*
     * Exception decompiling
     */
    public final void zzQ(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [75[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void zzR(long l, int n) {
        Iterator iterator = ((zzd)((Object)iterator)).zza().iterator();
        while (iterator.hasNext()) {
            ((zzaw)iterator.next()).zzd(l, n, null);
        }
    }

    private final void zzX() {
        zzap zzap2 = ((zzas)((Object)zzap2)).zzz;
        if (zzap2 != null) {
            zzap2.zzc();
            return;
        }
    }

    private final void zzY() {
        zzap zzap2 = ((zzas)((Object)zzap2)).zzz;
        if (zzap2 != null) {
            zzap2.zzd();
            return;
        }
    }

    private final void zzZ() {
        zzap zzap2 = ((zzas)((Object)zzap2)).zzz;
        if (zzap2 != null) {
            zzap2.zzk();
            return;
        }
    }

    private final void zzaa() {
        zzap zzap2 = ((zzas)((Object)zzap2)).zzz;
        if (zzap2 != null) {
            zzap2.zzm();
            return;
        }
    }

    @Override
    public final void zzf() {
        this.zzb();
        this.zzV();
    }

    public final void zzS(zzap zzap2) {
        this.zzz = zzap2;
    }

    private final boolean zzab() {
        return this.zzA != -1;
    }

    @Nullable
    private static int[] zzac(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        int[] nArray = new int[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            nArray[i] = jSONArray.getInt(i);
        }
        return nArray;
    }
}

