/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzds;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.PlatformVersion;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="TextTrackStyleCreator")
public final class TextTrackStyle
extends AbstractSafeParcelable {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<TextTrackStyle> CREATOR;
    @SafeParcelable.Field(id=2, getter="getFontScale")
    private float zzb;
    @SafeParcelable.Field(id=3, getter="getForegroundColor")
    private int zzc;
    @SafeParcelable.Field(id=4, getter="getBackgroundColor")
    private int zzd;
    @SafeParcelable.Field(id=5, getter="getEdgeType")
    private int zze;
    @SafeParcelable.Field(id=6, getter="getEdgeColor")
    private int zzf;
    @SafeParcelable.Field(id=7, getter="getWindowType")
    private int zzg;
    @SafeParcelable.Field(id=8, getter="getWindowColor")
    private int zzh;
    @SafeParcelable.Field(id=9, getter="getWindowCornerRadius")
    private int zzi;
    @SafeParcelable.Field(id=10, getter="getFontFamily")
    @Nullable
    private String zzj;
    @SafeParcelable.Field(id=11, getter="getFontGenericFamily")
    private int zzk;
    @SafeParcelable.Field(id=12, getter="getFontStyle")
    private int zzl;
    @SafeParcelable.Field(id=13)
    @Nullable
    String zza;
    @Nullable
    private JSONObject zzm;

    public float getFontScale() {
        return this.zzb;
    }

    public int getBackgroundColor() {
        return this.zzd;
    }

    public int getEdgeColor() {
        return this.zzf;
    }

    public int getEdgeType() {
        return this.zze;
    }

    public int getFontGenericFamily() {
        return this.zzk;
    }

    public int getFontStyle() {
        return this.zzl;
    }

    public int getForegroundColor() {
        return this.zzc;
    }

    public int getWindowColor() {
        return this.zzh;
    }

    public int getWindowCornerRadius() {
        return this.zzi;
    }

    public int getWindowType() {
        return this.zzg;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{Float.valueOf(this.zzb), this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, String.valueOf(this.zzm)};
        return Objects.hashCode((Object[])objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=19)
    @NonNull
    public static TextTrackStyle fromSystemSettings(@NonNull Context context) {
        Context context2;
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!PlatformVersion.isAtLeastKitKat()) {
            return textTrackStyle;
        }
        if ((context2 = (CaptioningManager)context2.getSystemService("captioning")) == null) {
            return textTrackStyle;
        }
        textTrackStyle.setFontScale(context2.getFontScale());
        context2 = context2.getUserStyle();
        textTrackStyle.setBackgroundColor(context2.backgroundColor);
        textTrackStyle.setForegroundColor(context2.foregroundColor);
        switch (context2.edgeType) {
            default: {
                textTrackStyle.setEdgeType(0);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            case 1: {
                textTrackStyle.setEdgeType(1);
            }
        }
        textTrackStyle.setEdgeColor(context2.edgeColor);
        context2 = context2.getTypeface();
        if (context2 == null) return textTrackStyle;
        if (Typeface.MONOSPACE.equals((Object)context2)) {
            textTrackStyle.setFontGenericFamily(1);
        } else if (Typeface.SANS_SERIF.equals((Object)context2)) {
            textTrackStyle.setFontGenericFamily(0);
        } else if (Typeface.SERIF.equals((Object)context2)) {
            textTrackStyle.setFontGenericFamily(2);
        } else {
            textTrackStyle.setFontGenericFamily(0);
        }
        boolean bl = context2.isBold();
        boolean bl2 = context2.isItalic();
        if (bl && bl2) {
            textTrackStyle.setFontStyle(3);
            return textTrackStyle;
        }
        if (bl) {
            textTrackStyle.setFontStyle(1);
            return textTrackStyle;
        }
        if (bl2) {
            textTrackStyle.setFontStyle(2);
            return textTrackStyle;
        }
        textTrackStyle.setFontStyle(0);
        return textTrackStyle;
    }

    @Nullable
    public String getFontFamily() {
        return this.zzj;
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zzm;
    }

    static {
        zzds zzds2;
        CREATOR = zzds2 = new zzds();
    }

    public TextTrackStyle() {
        this(1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    TextTrackStyle(@SafeParcelable.Param(id=2) float f, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) int n3, @SafeParcelable.Param(id=6) int n4, @SafeParcelable.Param(id=7) int n5, @SafeParcelable.Param(id=8) int n6, @SafeParcelable.Param(id=9) int n7, @SafeParcelable.Param(id=10) @Nullable String string2, @SafeParcelable.Param(id=11) int n8, @SafeParcelable.Param(id=12) int n9, @SafeParcelable.Param(id=13) @Nullable String string3) {
        this.zzb = f;
        this.zzc = n;
        this.zzd = n2;
        this.zze = n3;
        this.zzf = n4;
        this.zzg = n5;
        this.zzh = n6;
        this.zzi = n7;
        this.zzj = string2;
        this.zzk = n8;
        this.zzl = n9;
        this.zza = string3;
        if (this.zza == null) {
            this.zzm = null;
            return;
        }
        try {
            JSONObject jSONObject;
            this.zzm = jSONObject = new JSONObject(this.zza);
            return;
        }
        catch (JSONException jSONException) {
            this.zzm = null;
            this.zza = null;
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public void fromJson(@NonNull JSONObject json) throws JSONException {
        String string2;
        void var1_1;
        this.zzb = (float)var1_1.optDouble("fontScale", 1.0);
        this.zzc = TextTrackStyle.zzb(var1_1.optString("foregroundColor"));
        this.zzd = TextTrackStyle.zzb(var1_1.optString("backgroundColor"));
        if (var1_1.has("edgeType")) {
            string2 = var1_1.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zze = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zze = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zze = 2;
            } else if ("RAISED".equals(string2)) {
                this.zze = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zze = 4;
            }
        }
        this.zzf = TextTrackStyle.zzb(var1_1.optString("edgeColor"));
        if (var1_1.has("windowType")) {
            string2 = var1_1.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzg = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzg = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzg = 2;
            }
        }
        this.zzh = TextTrackStyle.zzb(var1_1.optString("windowColor"));
        if (this.zzg == 2) {
            this.zzi = var1_1.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzj = CastUtils.optStringOrNull((JSONObject)var1_1, "fontFamily");
        if (var1_1.has("fontGenericFamily")) {
            string2 = var1_1.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzk = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzk = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzk = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzk = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzk = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzk = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzk = 6;
            }
        }
        if (var1_1.has("fontStyle")) {
            string2 = var1_1.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzl = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzl = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzl = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzl = 3;
            }
        }
        this.zzm = var1_1.optJSONObject("customData");
    }

    /*
     * WARNING - void declaration
     */
    public void setBackgroundColor(int backgroundColor) {
        void var1_1;
        this.zzd = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomData(@NonNull JSONObject customData) {
        void var1_1;
        this.zzm = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEdgeColor(int edgeColor) {
        void var1_1;
        this.zzf = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEdgeType(int edgeType) {
        void var1_1;
        if (edgeType < 0 || var1_1 > 4) {
            Object object = new IllegalArgumentException("invalid edgeType");
            throw object;
        }
        object.zze = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFontFamily(@NonNull String fontFamily) {
        void var1_1;
        this.zzj = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFontGenericFamily(int fontGenericFamily) {
        void var1_1;
        if (fontGenericFamily < 0 || var1_1 > 6) {
            Object object = new IllegalArgumentException("invalid fontGenericFamily");
            throw object;
        }
        object.zzk = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFontScale(float fontScale) {
        void var1_1;
        this.zzb = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFontStyle(int fontStyle) {
        void var1_1;
        if (fontStyle < 0 || var1_1 > 3) {
            Object object = new IllegalArgumentException("invalid fontStyle");
            throw object;
        }
        object.zzl = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setForegroundColor(int foregroundColor) {
        void var1_1;
        this.zzc = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWindowColor(int windowColor) {
        void var1_1;
        this.zzh = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWindowCornerRadius(int windowCornerRadius) {
        void var1_1;
        if (windowCornerRadius < 0) {
            Object object = new IllegalArgumentException("invalid windowCornerRadius");
            throw object;
        }
        object.zzi = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWindowType(int windowType) {
        void var1_1;
        if (windowType < 0 || var1_1 > 2) {
            Object object = new IllegalArgumentException("invalid windowType");
            throw object;
        }
        object.zzg = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        void var2_5;
        JSONObject jSONObject = this.zzm;
        if (jSONObject == null) {
            Object var2_4 = null;
        } else {
            String string2 = jSONObject.toString();
        }
        this.zza = var2_5;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)2, (float)this.getFontScale());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getForegroundColor());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getBackgroundColor());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)5, (int)this.getEdgeType());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.getEdgeColor());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)7, (int)this.getWindowType());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)8, (int)this.getWindowColor());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)9, (int)this.getWindowCornerRadius());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)10, (String)this.getFontFamily(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)11, (int)this.getFontGenericFamily());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)12, (int)this.getFontStyle());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)13, (String)this.zza, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean equals(@Nullable Object other) {
        JSONObject jSONObject;
        boolean bl;
        void var1_1;
        if (this == var1_1) {
            return true;
        }
        if (!(var1_1 instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)var1_1;
        JSONObject jSONObject2 = this.zzm;
        boolean bl2 = jSONObject2 == null;
        if (bl2 != (bl = (jSONObject = textTrackStyle.zzm) == null)) {
            return false;
        }
        if (jSONObject2 != null && jSONObject != null && !JsonUtils.areJsonValuesEquivalent((Object)jSONObject2, (Object)jSONObject)) {
            return false;
        }
        return this.zzb == textTrackStyle.zzb && this.zzc == textTrackStyle.zzc && this.zzd == textTrackStyle.zzd && this.zze == textTrackStyle.zze && this.zzf == textTrackStyle.zzf && this.zzg == textTrackStyle.zzg && this.zzh == textTrackStyle.zzh && this.zzi == textTrackStyle.zzi && CastUtils.zzh(this.zzj, textTrackStyle.zzj) && this.zzk == textTrackStyle.zzk && this.zzl == textTrackStyle.zzl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            String string3;
            jSONObject.put("fontScale", (double)textTrackStyle.zzb);
            int n = textTrackStyle.zzc;
            if (n != 0) {
                string3 = "foregroundColor";
                jSONObject.put(string3, (Object)TextTrackStyle.zzc(n));
            }
            if ((n = textTrackStyle.zzd) != 0) {
                string3 = "backgroundColor";
                jSONObject.put(string3, (Object)TextTrackStyle.zzc(n));
            }
            switch (textTrackStyle.zze) {
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
            }
            n = textTrackStyle.zzf;
            if (n != 0) {
                string3 = "edgeColor";
                jSONObject.put(string3, (Object)TextTrackStyle.zzc(n));
            }
            switch (textTrackStyle.zzg) {
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
            }
            n = textTrackStyle.zzh;
            if (n != 0) {
                string3 = "windowColor";
                jSONObject.put(string3, (Object)TextTrackStyle.zzc(n));
            }
            if ((n = textTrackStyle.zzg) == 2) {
                jSONObject.put("windowRoundedCornerRadius", textTrackStyle.zzi);
            }
            if ((string2 = textTrackStyle.zzj) != null) {
                string3 = "fontFamily";
                jSONObject.put(string3, (Object)string2);
            }
            switch (textTrackStyle.zzk) {
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
            }
            switch (textTrackStyle.zzl) {
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
            }
            TextTrackStyle textTrackStyle = textTrackStyle.zzm;
            if (textTrackStyle == null) return jSONObject;
            string2 = "customData";
            jSONObject.put(string2, (Object)textTrackStyle);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int zzb(String string2) {
        if (string2 == null) return 0;
        if (string2.length() != 9) return 0;
        if (string2.charAt(0) != '#') return 0;
        try {
            String string3 = string2.substring(1, 3);
            int n = Integer.parseInt(string3, 16);
            String string4 = string2.substring(3, 5);
            int n2 = Integer.parseInt(string4, 16);
            String string5 = string2.substring(5, 7);
            int n3 = Integer.parseInt(string5, 16);
            return Color.argb((int)Integer.parseInt(string2.substring(7, 9), 16), (int)n, (int)n2, (int)n3);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static final String zzc(int n) {
        Object[] objectArray = new Object[]{Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n)};
        return String.format("#%02X%02X%02X%02X", objectArray);
    }
}

