/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.MediaLoadRequestData;
import com.google.android.gms.cast.zzdr;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.JsonUtils;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="SessionStateCreator")
public class SessionState
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<SessionState> CREATOR;
    @SafeParcelable.Field(id=2, getter="getLoadRequestData")
    @Nullable
    private final MediaLoadRequestData zzb;
    @SafeParcelable.Field(id=3)
    @Nullable
    String zza;
    @Nullable
    private final JSONObject zzc;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzb, String.valueOf(this.zzc)};
        return Objects.hashCode((Object[])objectArray);
    }

    @Nullable
    public MediaLoadRequestData getLoadRequestData() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static SessionState fromJson(@NonNull JSONObject json) {
        void var1_3;
        JSONObject jSONObject;
        JSONObject jSONObject2 = json.optJSONObject("loadRequestData");
        if (jSONObject2 != null) {
            MediaLoadRequestData mediaLoadRequestData = MediaLoadRequestData.fromJson(jSONObject2);
        } else {
            Object var1_4 = null;
        }
        jSONObject = jSONObject.optJSONObject("customData");
        return new SessionState((MediaLoadRequestData)var1_3, jSONObject);
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @KeepForSdk
    public JSONObject toJson() {
        try {
            JSONObject jSONObject = new JSONObject();
            MediaLoadRequestData mediaLoadRequestData = this.zzb;
            if (mediaLoadRequestData != null) {
                String string2 = "loadRequestData";
                jSONObject.put(string2, (Object)mediaLoadRequestData.toJson());
            }
            jSONObject.put("customData", (Object)this.zzc);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    static {
        zzdr zzdr2;
        CREATOR = zzdr2 = new zzdr();
    }

    SessionState(@Nullable MediaLoadRequestData mediaLoadRequestData, @Nullable JSONObject jSONObject) {
        this.zzb = mediaLoadRequestData;
        this.zzc = jSONObject;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        void var3_5;
        JSONObject jSONObject = this.zzc;
        if (jSONObject == null) {
            Object var3_4 = null;
        } else {
            String string2 = jSONObject.toString();
        }
        this.zza = var3_5;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getLoadRequestData(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zza, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object other) {
        SessionState sessionState;
        if (this == sessionState) {
            return true;
        }
        if (!(sessionState instanceof SessionState)) {
            return false;
        }
        sessionState = sessionState;
        if (!JsonUtils.areJsonValuesEquivalent((Object)this.zzc, (Object)sessionState.zzc)) {
            return false;
        }
        return Objects.equal((Object)this.zzb, (Object)sessionState.zzb);
    }

    public static class Builder {
        @Nullable
        private MediaLoadRequestData zza;
        @Nullable
        private JSONObject zzb;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCustomData(@Nullable JSONObject customData) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setLoadRequestData(@Nullable MediaLoadRequestData loadRequestData) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        @NonNull
        public SessionState build() {
            SessionState sessionState = new SessionState(this.zza, this.zzb);
            return sessionState;
        }
    }
}

