/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.MediaQueueContainerMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.media.MediaCommon;
import com.google.android.gms.cast.zzch;
import com.google.android.gms.cast.zzci;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaQueueDataCreator")
public class MediaQueueData
extends AbstractSafeParcelable {
    public static final int MEDIA_QUEUE_TYPE_GENERIC = 0;
    public static final int MEDIA_QUEUE_TYPE_ALBUM = 1;
    public static final int MEDIA_QUEUE_TYPE_PLAYLIST = 2;
    public static final int MEDIA_QUEUE_TYPE_AUDIO_BOOK = 3;
    public static final int MEDIA_QUEUE_TYPE_RADIO_STATION = 4;
    public static final int MEDIA_QUEUE_TYPE_PODCAST_SERIES = 5;
    public static final int MEDIA_QUEUE_TYPE_TV_SERIES = 6;
    public static final int MEDIA_QUEUE_TYPE_VIDEO_PLAYLIST = 7;
    public static final int MEDIA_QUEUE_TYPE_LIVE_TV = 8;
    public static final int MEDIA_QUEUE_TYPE_MOVIE = 9;
    @NonNull
    public static final Parcelable.Creator<MediaQueueData> CREATOR;
    @SafeParcelable.Field(id=2, getter="getQueueId")
    @Nullable
    private String zza;
    @SafeParcelable.Field(id=3, getter="getEntity")
    @Nullable
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getQueueType")
    private int zzc;
    @SafeParcelable.Field(id=5, getter="getName")
    @Nullable
    private String zzd;
    @SafeParcelable.Field(id=6, getter="getContainerMetadata")
    @Nullable
    private MediaQueueContainerMetadata zze;
    @SafeParcelable.Field(id=7, getter="getRepeatMode")
    private int zzf;
    @SafeParcelable.Field(id=8, getter="getItems")
    @Nullable
    private List zzg;
    @SafeParcelable.Field(id=9, getter="getStartIndex")
    private int zzh;
    @SafeParcelable.Field(id=10, getter="getStartTime")
    private long zzi;
    @SafeParcelable.Field(id=11, getter="getShuffle")
    private boolean zzj;

    public int getQueueType() {
        return this.zzc;
    }

    public int getRepeatMode() {
        return this.zzf;
    }

    public int getStartIndex() {
        return this.zzh;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getStartTime() {
        return this.zzi;
    }

    @Nullable
    public MediaQueueContainerMetadata getContainerMetadata() {
        return this.zze;
    }

    @Nullable
    public String getEntity() {
        return this.zzb;
    }

    @Nullable
    public String getName() {
        return this.zzd;
    }

    @Nullable
    public String getQueueId() {
        return this.zza;
    }

    @Nullable
    public List<MediaQueueItem> getItems() {
        Object this_ = this_.zzg;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    static {
        zzci zzci2;
        CREATOR = zzci2 = new zzci();
    }

    private MediaQueueData() {
        this.zzl();
    }

    @SafeParcelable.Constructor
    MediaQueueData(@SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable String string3, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) @Nullable String string4, @SafeParcelable.Param(id=6) @Nullable MediaQueueContainerMetadata mediaQueueContainerMetadata, @SafeParcelable.Param(id=7) int n2, @SafeParcelable.Param(id=8) @Nullable List list, @SafeParcelable.Param(id=9) int n3, @SafeParcelable.Param(id=10) long l, @SafeParcelable.Param(id=11) boolean bl) {
        this.zza = string2;
        this.zzb = string3;
        this.zzc = n;
        this.zzd = string4;
        this.zze = mediaQueueContainerMetadata;
        this.zzf = n2;
        this.zzg = list;
        this.zzh = n3;
        this.zzi = l;
        this.zzj = bl;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setRepeatMode(int repeatMode) {
        void var1_1;
        this.zzf = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getQueueId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getEntity(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getQueueType());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.getContainerMetadata(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)7, (int)this.getRepeatMode());
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)8, this.getItems(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)9, (int)this.getStartIndex());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)10, (long)this.getStartTime());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)11, (boolean)this.zzj);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object other) {
        MediaQueueData mediaQueueData;
        if (this == mediaQueueData) {
            return true;
        }
        if (!(mediaQueueData instanceof MediaQueueData)) {
            return false;
        }
        mediaQueueData = mediaQueueData;
        return TextUtils.equals((CharSequence)this.zza, (CharSequence)mediaQueueData.zza) && TextUtils.equals((CharSequence)this.zzb, (CharSequence)mediaQueueData.zzb) && this.zzc == mediaQueueData.zzc && TextUtils.equals((CharSequence)this.zzd, (CharSequence)mediaQueueData.zzd) && Objects.equal((Object)((Object)this.zze), (Object)((Object)mediaQueueData.zze)) && this.zzf == mediaQueueData.zzf && Objects.equal((Object)this.zzg, (Object)mediaQueueData.zzg) && this.zzh == mediaQueueData.zzh && this.zzi == mediaQueueData.zzi && this.zzj == mediaQueueData.zzj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            boolean bl;
            Object object;
            Object object2;
            boolean bl2 = TextUtils.isEmpty((CharSequence)this.zza);
            if (!bl2) {
                jSONObject.put("id", (Object)this.zza);
            }
            if (!(bl2 = TextUtils.isEmpty((CharSequence)this.zzb))) {
                jSONObject.put("entity", (Object)this.zzb);
            }
            switch (this.zzc) {
                case 9: {
                    jSONObject.put("queueType", (Object)"MOVIE");
                    break;
                }
                case 8: {
                    jSONObject.put("queueType", (Object)"LIVE_TV");
                    break;
                }
                case 7: {
                    jSONObject.put("queueType", (Object)"VIDEO_PLAYLIST");
                    break;
                }
                case 6: {
                    jSONObject.put("queueType", (Object)"TV_SERIES");
                    break;
                }
                case 5: {
                    jSONObject.put("queueType", (Object)"PODCAST_SERIES");
                    break;
                }
                case 4: {
                    jSONObject.put("queueType", (Object)"RADIO_STATION");
                    break;
                }
                case 3: {
                    jSONObject.put("queueType", (Object)"AUDIOBOOK");
                    break;
                }
                case 2: {
                    jSONObject.put("queueType", (Object)"PLAYLIST");
                    break;
                }
                case 1: {
                    jSONObject.put("queueType", (Object)"ALBUM");
                    break;
                }
            }
            bl2 = TextUtils.isEmpty((CharSequence)this.zzd);
            if (!bl2) {
                jSONObject.put("name", (Object)this.zzd);
            }
            if ((object2 = this.zze) != null) {
                object = "containerMetadata";
                jSONObject.put((String)object, (Object)((MediaQueueContainerMetadata)((Object)object2)).zza());
            }
            if ((object2 = MediaCommon.zza(this.zzf)) != null) {
                jSONObject.put("repeatMode", object2);
            }
            if ((object2 = this.zzg) != null && !(bl = object2.isEmpty())) {
                boolean bl3;
                JSONArray jSONArray = new JSONArray();
                object = this.zzg.iterator();
                while (bl3 = object.hasNext()) {
                    jSONArray.put((Object)((MediaQueueItem)((Object)object.next())).toJson());
                }
                jSONObject.put("items", (Object)jSONArray);
            }
            jSONObject.put("startIndex", this.zzh);
            long l = this.zzi;
            if (l != -1L) {
                String string2 = "startTime";
                jSONObject.put(string2, CastUtils.millisecToSec(l));
            }
            jSONObject.put("shuffle", this.zzj);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    /*
     * Unable to fully structure code
     */
    static /* bridge */ /* synthetic */ void zzb(MediaQueueData var0, JSONObject var1_1) {
        var0.zzl();
        if (var1_1 == null) {
            return;
        }
        var0.zza = CastUtils.optStringOrNull(var1_1, "id");
        var0.zzb = CastUtils.optStringOrNull(var1_1, "entity");
        var2_2 = var1_1.optString("queueType");
        switch (var2_2.hashCode()) lbl-1000:
        // 9 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_3 = -1;
lbl11:
                    // 10 sources

                    while (true) {
                        switch (var2_3) lbl-1000:
                        // 9 sources

                        {
                            default: lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    var0.zzd = CastUtils.optStringOrNull(var1_1, "name");
                                    if (var1_1.has("containerMetadata")) {
                                        var2_4 = var1_1.optJSONObject("containerMetadata");
lbl18:
                                        // 2 sources

                                        while (true) {
                                            if (var2_4 != null) {
                                                var3_6 = new MediaQueueContainerMetadata.Builder();
                                                var3_6.zza((JSONObject)var2_4);
                                                var0.zze = var3_6.build();
                                            }
                                            if ((var2_4 = MediaCommon.mediaRepeatModeFromString(var1_1.optString("repeatMode"))) != null) {
                                                var0.zzf = var2_4.intValue();
                                            }
                                            if ((var3_6 = var1_1.optJSONArray("items")) != null) {
                                                var0.zzg = var2_4 = new ArrayList();
                                                var4_7 = var0.zzg;
                                                block30: for (var2_5 = 0; var2_5 < var3_6.length(); ++var2_5) {
                                                    var5_8 = var3_6.optJSONObject(var2_5);
                                                    if (var5_8 != null) {
                                                        var6_9 = new MediaQueueItem(var5_8);
                                                        var4_7.add(var6_9);
                                                    }
lbl36:
                                                    // 4 sources

                                                }
                                            }
                                            var0.zzh = var1_1.optInt("startIndex", var0.zzh);
                                            if (var1_1.has("startTime")) {
                                                var0.zzi = CastUtils.secToMillisec(var1_1.optDouble("startTime", (double)var0.zzi));
                                            }
                                            var0.zzj = var1_1.optBoolean("shuffle");
                                            return;
                                        }
                                    }
                                    var2_4 = null;
                                    ** continue;
                                    break;
                                }
                            }
                            case 8: {
                                var0.zzc = 9;
                                ** GOTO lbl-1000
                            }
                            case 7: {
                                var0.zzc = 8;
                                ** GOTO lbl-1000
                            }
                            case 6: {
                                var0.zzc = 7;
                                ** GOTO lbl-1000
                            }
                            case 5: {
                                var0.zzc = 6;
                                ** GOTO lbl-1000
                            }
                            case 4: {
                                var0.zzc = 5;
                                ** GOTO lbl-1000
                            }
                            case 3: {
                                var0.zzc = 4;
                                ** GOTO lbl-1000
                            }
                            case 2: {
                                var0.zzc = 3;
                                ** GOTO lbl-1000
                            }
                            case 1: {
                                var0.zzc = 2;
                                ** GOTO lbl-1000
                            }
                            case 0: 
                        }
                        var0.zzc = 1;
                        ** continue;
                        break;
                    }
                    break;
                }
            }
            case 902303413: {
                if (!var2_2.equals("LIVE_TV")) ** GOTO lbl-1000
                var2_3 = 7;
                ** GOTO lbl11
            }
            case 393100598: {
                if (!var2_2.equals("VIDEO_PLAYLIST")) ** GOTO lbl-1000
                var2_3 = 6;
                ** GOTO lbl11
            }
            case 73549584: {
                if (!var2_2.equals("MOVIE")) ** GOTO lbl-1000
                var2_3 = 8;
                ** GOTO lbl11
            }
            case 62359119: {
                if (!var2_2.equals("ALBUM")) ** GOTO lbl-1000
                var2_3 = 0;
                ** GOTO lbl11
            }
            case -1088524588: {
                if (!var2_2.equals("TV_SERIES")) ** GOTO lbl-1000
                var2_3 = 5;
                ** GOTO lbl11
            }
            case -1319760993: {
                if (!var2_2.equals("AUDIOBOOK")) ** GOTO lbl-1000
                var2_3 = 2;
                ** GOTO lbl11
            }
            case -1632865838: {
                if (!var2_2.equals("PLAYLIST")) ** GOTO lbl-1000
                var2_3 = 1;
                ** GOTO lbl11
            }
            case -1758903120: {
                if (!var2_2.equals("RADIO_STATION")) ** GOTO lbl-1000
                var2_3 = 3;
                ** GOTO lbl11
            }
            case -1803151310: 
        }
        ** while (!var2_2.equals((Object)"PODCAST_SERIES"))
lbl106:
        // 1 sources

        var2_3 = 4;
        ** while (true)
        catch (JSONException v0) {
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zze(MediaQueueData mediaQueueData, List arrayList) {
        if (arrayList == null) {
            arrayList = null;
        } else {
            ArrayList arrayList2 = new ArrayList(arrayList);
            arrayList = arrayList2;
        }
        mediaQueueData.zzg = arrayList;
    }

    /* synthetic */ MediaQueueData(zzch zzch2) {
        this.zzl();
    }

    /* synthetic */ MediaQueueData(MediaQueueData mediaQueueData, zzch zzch2) {
        this.zza = mediaQueueData.zza;
        this.zzb = mediaQueueData.zzb;
        this.zzc = mediaQueueData.zzc;
        this.zzd = mediaQueueData.zzd;
        this.zze = mediaQueueData.zze;
        this.zzf = mediaQueueData.zzf;
        this.zzg = mediaQueueData.zzg;
        this.zzh = mediaQueueData.zzh;
        this.zzi = mediaQueueData.zzi;
        this.zzj = mediaQueueData.zzj;
    }

    private final void zzl() {
        this.zza = null;
        this.zzb = null;
        this.zzc = 0;
        this.zzd = null;
        this.zzf = 0;
        this.zzg = null;
        this.zzh = 0;
        this.zzi = -1L;
        this.zzj = false;
    }

    @ShowFirstParty
    public final boolean zzk() {
        return this.zzj;
    }

    public static class Builder {
        private final MediaQueueData zza;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContainerMetadata(@Nullable MediaQueueContainerMetadata containerMetadata) {
            void var1_1;
            this.zza.zze = (MediaQueueContainerMetadata)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEntity(@Nullable String entity) {
            void var1_1;
            this.zza.zzb = (String)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setItems(@Nullable List<MediaQueueItem> items) {
            void var1_1;
            MediaQueueData.zze(this.zza, (List)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setName(@Nullable String name) {
            void var1_1;
            this.zza.zzd = (String)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setQueueId(@Nullable String queueId) {
            void var1_1;
            this.zza.zza = (String)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setQueueType(int queueType) {
            void var1_1;
            this.zza.zzc = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRepeatMode(int repeatMode) {
            void var1_1;
            this.zza.setRepeatMode((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStartIndex(int startIndex) {
            void var1_1;
            this.zza.zzh = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStartTime(long startTime) {
            void var1_1;
            this.zza.zzi = (long)var1_1;
            return this;
        }

        @NonNull
        public MediaQueueData build() {
            MediaQueueData mediaQueueData = new MediaQueueData(this.zza, null);
            return mediaQueueData;
        }

        public Builder() {
            MediaQueueData mediaQueueData;
            this.zza = mediaQueueData = new MediaQueueData(null);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public Builder(@NonNull MediaQueueData from) {
            void var1_1;
            MediaQueueData mediaQueueData;
            this.zza = mediaQueueData = new MediaQueueData((MediaQueueData)var1_1, null);
        }

        @NonNull
        public final Builder zza(@NonNull JSONObject jSONObject) {
            MediaQueueData.zzb(this.zza, jSONObject);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaQueueType {
    }
}

