/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.media.zza;
import com.google.android.gms.cast.zzcf;
import com.google.android.gms.cast.zzcg;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaQueueContainerMetadataCreator")
public class MediaQueueContainerMetadata
extends AbstractSafeParcelable {
    public static final int MEDIA_QUEUE_CONTAINER_TYPE_GENERIC = 0;
    public static final int MEDIA_QUEUE_CONTAINER_TYPE_AUDIO_BOOK = 1;
    @NonNull
    public static final Parcelable.Creator<MediaQueueContainerMetadata> CREATOR;
    @SafeParcelable.Field(id=2, getter="getContainerType")
    private int zza;
    @SafeParcelable.Field(id=3, getter="getTitle")
    @Nullable
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getSections")
    @Nullable
    private List zzc;
    @SafeParcelable.Field(id=5, getter="getContainerImages")
    @Nullable
    private List zzd;
    @SafeParcelable.Field(id=6, getter="getContainerDuration")
    private double zze;

    public double getContainerDuration() {
        return this.zze;
    }

    public int getContainerType() {
        return this.zza;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze};
        return Objects.hashCode((Object[])objectArray);
    }

    @Nullable
    public String getTitle() {
        return this.zzb;
    }

    @Nullable
    public List<WebImage> getContainerImages() {
        Object this_ = this_.zzd;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    @Nullable
    public List<MediaMetadata> getSections() {
        Object this_ = this_.zzc;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    static {
        zzcg zzcg2;
        CREATOR = zzcg2 = new zzcg();
    }

    private MediaQueueContainerMetadata() {
        this.zzh();
    }

    @SafeParcelable.Constructor
    MediaQueueContainerMetadata(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) @Nullable String string2, @SafeParcelable.Param(id=4) @Nullable List list, @SafeParcelable.Param(id=5) @Nullable List list2, @SafeParcelable.Param(id=6) double d) {
        this.zza = n;
        this.zzb = string2;
        this.zzc = list;
        this.zzd = list2;
        this.zze = d;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getContainerType());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getTitle(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)4, this.getSections(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)5, this.getContainerImages(), (boolean)false);
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)6, (double)this.getContainerDuration());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object other) {
        MediaQueueContainerMetadata mediaQueueContainerMetadata;
        if (this == mediaQueueContainerMetadata) {
            return true;
        }
        if (!(mediaQueueContainerMetadata instanceof MediaQueueContainerMetadata)) {
            return false;
        }
        mediaQueueContainerMetadata = mediaQueueContainerMetadata;
        return this.zza == mediaQueueContainerMetadata.zza && TextUtils.equals((CharSequence)this.zzb, (CharSequence)mediaQueueContainerMetadata.zzb) && Objects.equal((Object)this.zzc, (Object)mediaQueueContainerMetadata.zzc) && Objects.equal((Object)this.zzd, (Object)mediaQueueContainerMetadata.zzd) && this.zze == mediaQueueContainerMetadata.zze;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            boolean bl;
            List list;
            boolean bl2;
            List list2;
            boolean bl3;
            switch (this.zza) {
                case 1: {
                    jSONObject.put("containerType", (Object)"AUDIOBOOK_CONTAINER");
                }
                default: {
                    break;
                }
                case 0: {
                    jSONObject.put("containerType", (Object)"GENERIC_CONTAINER");
                }
            }
            if (!(bl3 = TextUtils.isEmpty((CharSequence)this.zzb))) {
                jSONObject.put("title", (Object)this.zzb);
            }
            if ((list2 = this.zzc) != null && !(bl2 = list2.isEmpty())) {
                boolean bl4;
                JSONArray jSONArray = new JSONArray();
                Iterator iterator = this.zzc.iterator();
                while (bl4 = iterator.hasNext()) {
                    jSONArray.put((Object)((MediaMetadata)((Object)iterator.next())).zza());
                }
                jSONObject.put("sections", (Object)jSONArray);
            }
            if ((list = this.zzd) != null && !(bl = list.isEmpty())) {
                JSONArray jSONArray = com.google.android.gms.cast.internal.media.zza.zzc(this.zzd);
                jSONObject.put("containerImages", (Object)jSONArray);
            }
            jSONObject.put("containerDuration", this.zze);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static /* bridge */ /* synthetic */ void zzb(MediaQueueContainerMetadata var0, JSONObject var1_1) {
        var0.zzh();
        var2_2 = var1_1.optString("containerType", "");
        switch (var2_2.hashCode()) lbl-1000:
        // 2 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_3 = -1;
lbl7:
                    // 3 sources

                    while (true) {
                        switch (var2_3) lbl-1000:
                        // 2 sources

                        {
                            default: lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    var0.zzb = CastUtils.optStringOrNull(var1_1, "title");
                                    var3_6 /* !! */  = var1_1.optJSONArray("sections");
                                    if (var3_6 /* !! */  != null) {
                                        var0.zzc = var2_4 = new ArrayList<E>();
                                        var4_7 = var0.zzc;
                                        for (var2_3 = 0; var2_3 < var3_6 /* !! */ .length(); ++var2_3) {
                                            var5_8 = var3_6 /* !! */ .optJSONObject(var2_3);
                                            if (var5_8 == null) continue;
                                            var6_9 = new MediaMetadata();
                                            var6_9.zzc(var5_8);
                                            var4_7.add(var6_9);
                                        }
                                    }
                                    if ((var2_5 = var1_1.optJSONArray("containerImages")) != null) {
                                        var3_6 /* !! */  = new ArrayList();
                                        var0.zzd = var3_6 /* !! */ ;
                                        com.google.android.gms.cast.internal.media.zza.zzd(var0.zzd, var2_5);
                                    }
                                    var0.zze = var1_1.optDouble("containerDuration", var0.zze);
                                    return;
                                }
                            }
                            case 1: {
                                var0.zza = 1;
                                ** GOTO lbl-1000
                            }
                            case 0: 
                        }
                        var0.zza = 0;
                        ** continue;
                        break;
                    }
                    break;
                }
            }
            case 828666841: {
                if (!var2_2.equals("GENERIC_CONTAINER")) ** GOTO lbl-1000
                var2_3 = 0;
                ** GOTO lbl7
            }
            case 6924225: 
        }
        ** while (!var2_2.equals((Object)"AUDIOBOOK_CONTAINER"))
lbl42:
        // 1 sources

        var2_3 = 1;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzd(MediaQueueContainerMetadata mediaQueueContainerMetadata, List arrayList) {
        if (arrayList == null) {
            arrayList = null;
        } else {
            ArrayList arrayList2 = new ArrayList(arrayList);
            arrayList = arrayList2;
        }
        mediaQueueContainerMetadata.zzd = arrayList;
    }

    /* synthetic */ MediaQueueContainerMetadata(zzcf zzcf2) {
        this.zzh();
    }

    /* synthetic */ MediaQueueContainerMetadata(MediaQueueContainerMetadata mediaQueueContainerMetadata, zzcf zzcf2) {
        this.zza = mediaQueueContainerMetadata.zza;
        this.zzb = mediaQueueContainerMetadata.zzb;
        this.zzc = mediaQueueContainerMetadata.zzc;
        this.zzd = mediaQueueContainerMetadata.zzd;
        this.zze = mediaQueueContainerMetadata.zze;
    }

    private final void zzh() {
        this.zza = 0;
        this.zzb = null;
        this.zzc = null;
        this.zzd = null;
        this.zze = 0.0;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzg(@Nullable List arrayList) {
        if (arrayList == null) {
            arrayList = null;
        } else {
            ArrayList arrayList2 = new ArrayList(arrayList);
            arrayList = arrayList2;
        }
        this.zzc = arrayList;
    }

    public static class Builder {
        private final MediaQueueContainerMetadata zza;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContainerDuration(double containerDuration) {
            void var1_1;
            this.zza.zze = (double)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContainerImages(@Nullable List<WebImage> containerImages) {
            void var1_1;
            MediaQueueContainerMetadata.zzd(this.zza, (List)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContainerType(int containerType) {
            void var1_1;
            this.zza.zza = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSections(@Nullable List<MediaMetadata> sections) {
            void var1_1;
            this.zza.zzg((List)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTitle(@Nullable String title) {
            void var1_1;
            this.zza.zzb = (String)var1_1;
            return this;
        }

        @NonNull
        public MediaQueueContainerMetadata build() {
            MediaQueueContainerMetadata mediaQueueContainerMetadata = new MediaQueueContainerMetadata(this.zza, null);
            return mediaQueueContainerMetadata;
        }

        public Builder() {
            MediaQueueContainerMetadata mediaQueueContainerMetadata;
            this.zza = mediaQueueContainerMetadata = new MediaQueueContainerMetadata(null);
        }

        @NonNull
        public final Builder zza(@NonNull JSONObject jSONObject) {
            MediaQueueContainerMetadata.zzb(this.zza, jSONObject);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaQueueContainerType {
    }
}

