/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.media.zza;
import com.google.android.gms.cast.zzcd;
import com.google.android.gms.cast.zzce;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaMetadataCreator")
public class MediaMetadata
extends AbstractSafeParcelable {
    public static final int MEDIA_TYPE_GENERIC = 0;
    public static final int MEDIA_TYPE_MOVIE = 1;
    public static final int MEDIA_TYPE_TV_SHOW = 2;
    public static final int MEDIA_TYPE_MUSIC_TRACK = 3;
    public static final int MEDIA_TYPE_PHOTO = 4;
    public static final int MEDIA_TYPE_AUDIOBOOK_CHAPTER = 5;
    public static final int MEDIA_TYPE_USER = 100;
    @NonNull
    public static final Parcelable.Creator<MediaMetadata> CREATOR;
    @NonNull
    public static final String KEY_CREATION_DATE = "com.google.android.gms.cast.metadata.CREATION_DATE";
    @NonNull
    public static final String KEY_RELEASE_DATE = "com.google.android.gms.cast.metadata.RELEASE_DATE";
    @NonNull
    public static final String KEY_BROADCAST_DATE = "com.google.android.gms.cast.metadata.BROADCAST_DATE";
    @NonNull
    public static final String KEY_TITLE = "com.google.android.gms.cast.metadata.TITLE";
    @NonNull
    public static final String KEY_SUBTITLE = "com.google.android.gms.cast.metadata.SUBTITLE";
    @NonNull
    public static final String KEY_ARTIST = "com.google.android.gms.cast.metadata.ARTIST";
    @NonNull
    public static final String KEY_ALBUM_ARTIST = "com.google.android.gms.cast.metadata.ALBUM_ARTIST";
    @NonNull
    public static final String KEY_ALBUM_TITLE = "com.google.android.gms.cast.metadata.ALBUM_TITLE";
    @NonNull
    public static final String KEY_BOOK_TITLE = "com.google.android.gms.cast.metadata.BOOK_TITLE";
    @NonNull
    public static final String KEY_CHAPTER_NUMBER = "com.google.android.gms.cast.metadata.CHAPTER_NUMBER";
    @NonNull
    public static final String KEY_CHAPTER_TITLE = "com.google.android.gms.cast.metadata.CHAPTER_TITLE";
    @NonNull
    public static final String KEY_COMPOSER = "com.google.android.gms.cast.metadata.COMPOSER";
    @NonNull
    public static final String KEY_DISC_NUMBER = "com.google.android.gms.cast.metadata.DISC_NUMBER";
    @NonNull
    public static final String KEY_TRACK_NUMBER = "com.google.android.gms.cast.metadata.TRACK_NUMBER";
    @NonNull
    public static final String KEY_SEASON_NUMBER = "com.google.android.gms.cast.metadata.SEASON_NUMBER";
    @NonNull
    public static final String KEY_EPISODE_NUMBER = "com.google.android.gms.cast.metadata.EPISODE_NUMBER";
    @NonNull
    public static final String KEY_SERIES_TITLE = "com.google.android.gms.cast.metadata.SERIES_TITLE";
    @NonNull
    public static final String KEY_STUDIO = "com.google.android.gms.cast.metadata.STUDIO";
    @NonNull
    public static final String KEY_WIDTH = "com.google.android.gms.cast.metadata.WIDTH";
    @NonNull
    public static final String KEY_HEIGHT = "com.google.android.gms.cast.metadata.HEIGHT";
    @NonNull
    public static final String KEY_LOCATION_NAME = "com.google.android.gms.cast.metadata.LOCATION_NAME";
    @NonNull
    public static final String KEY_LOCATION_LATITUDE = "com.google.android.gms.cast.metadata.LOCATION_LATITUDE";
    @NonNull
    public static final String KEY_LOCATION_LONGITUDE = "com.google.android.gms.cast.metadata.LOCATION_LONGITUDE";
    @NonNull
    public static final String KEY_QUEUE_ITEM_ID = "com.google.android.gms.cast.metadata.QUEUE_ITEM_ID";
    @NonNull
    public static final String KEY_SECTION_DURATION = "com.google.android.gms.cast.metadata.SECTION_DURATION";
    @NonNull
    public static final String KEY_SECTION_START_ABSOLUTE_TIME = "com.google.android.gms.cast.metadata.SECTION_START_ABSOLUTE_TIME";
    @NonNull
    public static final String KEY_SECTION_START_TIME_IN_CONTAINER = "com.google.android.gms.cast.metadata.SECTION_START_TIME_IN_CONTAINER";
    @NonNull
    public static final String KEY_SECTION_START_TIME_IN_MEDIA = "com.google.android.gms.cast.metadata.SECTION_START_TIME_IN_MEDIA";
    private static final String[] zzb;
    private static final zzcd zzc;
    @SafeParcelable.Field(id=2, getter="getImages")
    private final List zzd;
    @SafeParcelable.Field(id=3)
    final Bundle zza;
    @SafeParcelable.Field(id=4, getter="getMediaType")
    private int zze;
    private final Writer zzf;

    /*
     * WARNING - void declaration
     */
    public double getDouble(@NonNull String key) {
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 3);
        return this.zza.getDouble((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(@NonNull String key) {
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 2);
        return this.zza.getInt((String)var1_1);
    }

    public int getMediaType() {
        return this.zze;
    }

    @KeepForSdk
    public static int getTypeForKey(@NonNull String key) throws IllegalArgumentException {
        Object object;
        if (TextUtils.isEmpty((CharSequence)key)) {
            object = new IllegalArgumentException("null and empty keys are not allowed");
            throw object;
        }
        return zzc.zza((String)object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n;
        Bundle bundle = this.zza;
        if (bundle == null) {
            n = 17;
            return n * 31 + ((Object)this.zzd).hashCode();
        }
        Iterator iterator = bundle.keySet().iterator();
        n = 17;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = (String)object;
            object = this.zza.get(object);
            int n2 = n * 31;
            n = object != null ? object.hashCode() : 0;
            n = n2 + n;
        }
        return n * 31 + ((Object)this.zzd).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public long getTimeMillis(@NonNull String key) {
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 5);
        return this.zza.getLong((String)var1_1);
    }

    @KeepForSdk
    @NonNull
    public Writer getWriter() {
        return this.zzf;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getDateAsString(@NonNull String key) {
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 4);
        return this.zza.getString((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getString(@NonNull String key) {
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 1);
        return this.zza.getString((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Calendar getDate(@NonNull String key) {
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 4);
        Object object = object.zza.getString((String)var1_1);
        if (object != null) {
            return com.google.android.gms.cast.internal.media.zza.zzb((String)object);
        }
        return null;
    }

    @NonNull
    public List<WebImage> getImages() {
        return this.zzd;
    }

    @NonNull
    public Set<String> keySet() {
        return this.zza.keySet();
    }

    static {
        Object object = new String[]{"none", "String", "int", "double", "ISO-8601 date String", "Time in milliseconds as long"};
        zzb = object;
        object = new zzce();
        CREATOR = object;
        object = new zzcd();
        ((zzcd)object).zzb(KEY_CREATION_DATE, "creationDateTime", 4);
        ((zzcd)object).zzb(KEY_RELEASE_DATE, "releaseDate", 4);
        ((zzcd)object).zzb(KEY_BROADCAST_DATE, "originalAirdate", 4);
        ((zzcd)object).zzb(KEY_TITLE, "title", 1);
        ((zzcd)object).zzb(KEY_SUBTITLE, "subtitle", 1);
        ((zzcd)object).zzb(KEY_ARTIST, "artist", 1);
        ((zzcd)object).zzb(KEY_ALBUM_ARTIST, "albumArtist", 1);
        ((zzcd)object).zzb(KEY_ALBUM_TITLE, "albumName", 1);
        ((zzcd)object).zzb(KEY_COMPOSER, "composer", 1);
        ((zzcd)object).zzb(KEY_DISC_NUMBER, "discNumber", 2);
        ((zzcd)object).zzb(KEY_TRACK_NUMBER, "trackNumber", 2);
        ((zzcd)object).zzb(KEY_SEASON_NUMBER, "season", 2);
        ((zzcd)object).zzb(KEY_EPISODE_NUMBER, "episode", 2);
        ((zzcd)object).zzb(KEY_SERIES_TITLE, "seriesTitle", 1);
        ((zzcd)object).zzb(KEY_STUDIO, "studio", 1);
        ((zzcd)object).zzb(KEY_WIDTH, "width", 2);
        ((zzcd)object).zzb(KEY_HEIGHT, "height", 2);
        ((zzcd)object).zzb(KEY_LOCATION_NAME, "location", 1);
        ((zzcd)object).zzb(KEY_LOCATION_LATITUDE, "latitude", 3);
        ((zzcd)object).zzb(KEY_LOCATION_LONGITUDE, "longitude", 3);
        ((zzcd)object).zzb(KEY_SECTION_DURATION, "sectionDuration", 5);
        ((zzcd)object).zzb(KEY_SECTION_START_TIME_IN_MEDIA, "sectionStartTimeInMedia", 5);
        ((zzcd)object).zzb(KEY_SECTION_START_ABSOLUTE_TIME, "sectionStartAbsoluteTime", 5);
        ((zzcd)object).zzb(KEY_SECTION_START_TIME_IN_CONTAINER, "sectionStartTimeInContainer", 5);
        ((zzcd)object).zzb(KEY_QUEUE_ITEM_ID, "queueItemId", 2);
        ((zzcd)object).zzb(KEY_BOOK_TITLE, "bookTitle", 1);
        ((zzcd)object).zzb(KEY_CHAPTER_NUMBER, "chapterNumber", 2);
        ((zzcd)object).zzb(KEY_CHAPTER_TITLE, "chapterTitle", 1);
        zzc = object;
    }

    public MediaMetadata() {
        this(0);
    }

    /*
     * WARNING - void declaration
     */
    public MediaMetadata(int mediaType) {
        void var1_1;
        ArrayList arrayList = new ArrayList();
        Bundle bundle = new Bundle();
        this(arrayList, bundle, (int)var1_1);
    }

    @SafeParcelable.Constructor
    MediaMetadata(@SafeParcelable.Param(id=2) List list, @SafeParcelable.Param(id=3) Bundle bundle, @SafeParcelable.Param(id=4) int n) {
        Writer writer;
        this.zzf = writer = new Writer();
        this.zzd = list;
        this.zza = bundle;
        this.zze = n;
    }

    /*
     * WARNING - void declaration
     */
    public void addImage(@NonNull WebImage image) {
        void var1_1;
        this.zzd.add(var1_1);
    }

    public void clear() {
        this.zza.clear();
        this.zzd.clear();
    }

    public void clearImages() {
        this.zzd.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void putDate(@NonNull String key, @NonNull Calendar value) {
        void var2_2;
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 4);
        this.zza.putString((String)var1_1, com.google.android.gms.cast.internal.media.zza.zza((Calendar)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void putDouble(@NonNull String key, double value) {
        void var2_2;
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 3);
        this.zza.putDouble((String)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putInt(@NonNull String key, int value) {
        void var2_2;
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 2);
        this.zza.putInt((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putString(@NonNull String key, @NonNull String value) {
        void var2_2;
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 1);
        this.zza.putString((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putTimeMillis(@NonNull String key, long value) {
        void var2_2;
        void var1_1;
        MediaMetadata.throwIfWrongType(key, 5);
        this.zza.putLong((String)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void throwIfWrongType(@NonNull String key, int type) throws IllegalArgumentException {
        void var1_1;
        Object object;
        if (TextUtils.isEmpty((CharSequence)key)) {
            object = new IllegalArgumentException("null and empty keys are not allowed");
            throw object;
        }
        int n = zzc.zza((String)object);
        if (n != var1_1 && n != 0) {
            Object object2 = zzb;
            String string2 = object2[var1_1];
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Value for ");
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append(" must be a ");
            ((StringBuilder)object2).append(string2);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(((StringBuilder)object2).toString());
            throw illegalArgumentException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)2, this.getImages(), (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)var1_1, (int)3, (Bundle)this.zza, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getMediaType());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(@NonNull String key) {
        void var1_1;
        return this.zza.containsKey((String)var1_1);
    }

    public boolean equals(@Nullable Object other) {
        MediaMetadata mediaMetadata;
        if (this == mediaMetadata) {
            return true;
        }
        if (!(mediaMetadata instanceof MediaMetadata)) {
            return false;
        }
        mediaMetadata = mediaMetadata;
        return this.zzd(this.zza, mediaMetadata.zza) && ((Object)this.zzd).equals(mediaMetadata.zzd);
    }

    public boolean hasImages() {
        List this_ = ((MediaMetadata)((Object)this_)).zzd;
        return this_ != null && !this_.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        Object object;
        Object object2;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("metadataType", this.zze);
        }
        catch (JSONException jSONException) {}
        if ((object2 = com.google.android.gms.cast.internal.media.zza.zzc(this.zzd)).length() != 0) {
            try {
                jSONObject.put("images", object2);
            }
            catch (JSONException jSONException) {}
        }
        object2 = new ArrayList();
        switch (this.zze) {
            case 5: {
                object = new String[]{KEY_CHAPTER_TITLE, KEY_CHAPTER_NUMBER, KEY_TITLE, KEY_BOOK_TITLE, KEY_SUBTITLE};
                Collections.addAll(object2, object);
                break;
            }
            case 4: {
                object = new String[]{KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE};
                Collections.addAll(object2, object);
                break;
            }
            case 3: {
                object = new String[]{KEY_TITLE, KEY_ARTIST, KEY_ALBUM_TITLE, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE};
                Collections.addAll(object2, object);
                break;
            }
            case 2: {
                object = new String[]{KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE};
                Collections.addAll(object2, object);
                break;
            }
            case 1: {
                object = new String[]{KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE};
                Collections.addAll(object2, object);
                break;
            }
            case 0: {
                object = new String[]{KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE};
                Collections.addAll(object2, object);
                break;
            }
        }
        object = new String[]{KEY_SECTION_DURATION, KEY_SECTION_START_TIME_IN_MEDIA, KEY_SECTION_START_ABSOLUTE_TIME, KEY_SECTION_START_TIME_IN_CONTAINER, KEY_QUEUE_ITEM_ID};
        Collections.addAll(object2, object);
        try {
            boolean bl;
            int n;
            boolean bl2;
            object2 = object2.iterator();
            block21: while (bl2 = object2.hasNext()) {
                String string2;
                boolean bl3;
                object = (String)object2.next();
                if (object == null || !(bl3 = this.zza.containsKey((String)object)) || (string2 = zzc.zzc((String)object)) == null) continue;
                n = zzc.zza((String)object);
                switch (n) {
                    default: {
                        continue block21;
                    }
                    case 5: {
                        jSONObject.put(string2, CastUtils.millisecToSec(this.zza.getLong((String)object)));
                        continue block21;
                    }
                    case 1: 
                    case 4: {
                        jSONObject.put(string2, (Object)this.zza.getString((String)object));
                        continue block21;
                    }
                    case 3: {
                        jSONObject.put(string2, this.zza.getDouble((String)object));
                        continue block21;
                    }
                    case 2: 
                }
                jSONObject.put(string2, this.zza.getInt((String)object));
            }
            object2 = this.zza.keySet().iterator();
            while (bl = object2.hasNext()) {
                String string3 = (String)object2.next();
                boolean bl4 = string3.startsWith("com.google.");
                if (bl4) continue;
                Object object3 = this.zza.get(string3);
                n = object3 instanceof String;
                if (n != 0) {
                    jSONObject.put(string3, object3);
                    continue;
                }
                n = object3 instanceof Integer;
                if (n != 0) {
                    jSONObject.put(string3, object3);
                    continue;
                }
                n = object3 instanceof Double;
                if (n == 0) continue;
                jSONObject.put(string3, object3);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    /*
     * Exception decompiling
     */
    public final void zzc(@NonNull JSONObject var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 38[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final boolean zzd(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string2 : bundle.keySet()) {
            Object object = bundle.get(string2);
            Object object2 = bundle2.get(string2);
            if (!(object instanceof Bundle) || !(object2 instanceof Bundle) || this.zzd((Bundle)object, (Bundle)object2)) {
                if (!(object == null ? object2 != null || !bundle2.containsKey(string2) : !object.equals(object2))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @KeepForSdk
    public class Writer {
        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @Nullable
        public Object getRawValue(@NonNull String key) {
            void var1_1;
            return MediaMetadata.this.zza.get((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void remove(@NonNull String key) {
            void var1_1;
            MediaMetadata.this.zza.remove((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setMediaType(int mediaType) {
            void var1_1;
            MediaMetadata.this.zze = (int)var1_1;
        }
    }
}

