/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.HlsSegmentFormat;
import com.google.android.gms.cast.HlsVideoSegmentFormat;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.VastAdsRequest;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzby;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.internal.cast.zzeo;
import com.google.android.gms.internal.cast.zzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaInfoCreator")
public class MediaInfo
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    public static final long UNKNOWN_START_ABSOLUTE_TIME = -1L;
    @NonNull
    public static final Parcelable.Creator<MediaInfo> CREATOR;
    public static final long zza;
    @SafeParcelable.Field(id=2, getter="getContentId")
    @Nullable
    private String zzc;
    @SafeParcelable.Field(id=3, getter="getStreamType")
    private int zzd;
    @SafeParcelable.Field(id=4, getter="getContentType")
    @Nullable
    private String zze;
    @SafeParcelable.Field(id=5, getter="getMetadata")
    @Nullable
    private MediaMetadata zzf;
    @SafeParcelable.Field(id=6, getter="getStreamDuration")
    private long zzg;
    @SafeParcelable.Field(id=7, getter="getMediaTracks")
    @Nullable
    private List zzh;
    @SafeParcelable.Field(id=8, getter="getTextTrackStyle")
    @Nullable
    private TextTrackStyle zzi;
    @SafeParcelable.Field(id=9)
    @Nullable
    String zzb;
    @SafeParcelable.Field(id=10, getter="getAdBreaks")
    @Nullable
    private List zzj;
    @SafeParcelable.Field(id=11, getter="getAdBreakClips")
    @Nullable
    private List zzk;
    @SafeParcelable.Field(id=12, getter="getEntity")
    @Nullable
    private String zzl;
    @SafeParcelable.Field(id=13, getter="getVmapAdsRequest")
    @Nullable
    private VastAdsRequest zzm;
    @SafeParcelable.Field(id=14, getter="getStartAbsoluteTime")
    private long zzn;
    @SafeParcelable.Field(id=15, getter="getAtvEntity")
    @Nullable
    private String zzo;
    @SafeParcelable.Field(id=16, getter="getContentUrl")
    @Nullable
    private String zzp;
    @SafeParcelable.Field(id=17, getter="getHlsSegmentFormat")
    @HlsSegmentFormat
    @Nullable
    private String zzq;
    @SafeParcelable.Field(id=18, getter="getHlsVideoSegmentFormat")
    @HlsVideoSegmentFormat
    @Nullable
    private String zzr;
    @Nullable
    private JSONObject zzs;
    private final Writer zzt;

    public int getStreamType() {
        return this.zzd;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzc, this.zzd, this.zze, this.zzf, this.zzg, String.valueOf(this.zzs), this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, this.zzm, this.zzn, this.zzo, this.zzq, this.zzr};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getStartAbsoluteTime() {
        return this.zzn;
    }

    public long getStreamDuration() {
        return this.zzg;
    }

    @KeepForSdk
    @NonNull
    public Writer getWriter() {
        return this.zzt;
    }

    @Nullable
    public MediaMetadata getMetadata() {
        return this.zzf;
    }

    @Nullable
    public TextTrackStyle getTextTrackStyle() {
        return this.zzi;
    }

    @Nullable
    public VastAdsRequest getVmapAdsRequest() {
        return this.zzm;
    }

    @NonNull
    public String getContentId() {
        Object this_ = this_.zzc;
        if (this_ == null) {
            return "";
        }
        return this_;
    }

    @Nullable
    public String getContentType() {
        return this.zze;
    }

    @Nullable
    public String getContentUrl() {
        return this.zzp;
    }

    @Nullable
    public String getEntity() {
        return this.zzl;
    }

    @HlsSegmentFormat
    @Nullable
    public String getHlsSegmentFormat() {
        return this.zzq;
    }

    @HlsVideoSegmentFormat
    @Nullable
    public String getHlsVideoSegmentFormat() {
        return this.zzr;
    }

    @Nullable
    public List<AdBreakClipInfo> getAdBreakClips() {
        Object this_ = this_.zzk;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    @Nullable
    public List<AdBreakInfo> getAdBreaks() {
        Object this_ = this_.zzj;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    @Nullable
    public List<MediaTrack> getMediaTracks() {
        return this.zzh;
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zzs;
    }

    static {
        zzby zzby2;
        zza = CastUtils.secToMillisec(-1L);
        CREATOR = zzby2 = new zzby();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    MediaInfo(JSONObject jSONObject) throws JSONException {
        double d;
        ArrayList arrayList;
        block16: {
            JSONObject jSONObject2;
            int n;
            block15: {
                double d2;
                this(jSONObject.optString("contentId"), -1, null, null, -1L, null, null, null, null, null, null, null, -1L, null, null, null, null);
                arrayList = jSONObject.optString("streamType", "NONE");
                this.zzd = "NONE".equals(arrayList) ? 0 : ("BUFFERED".equals(arrayList) ? 1 : ("LIVE".equals(arrayList) ? 2 : -1));
                this.zze = CastUtils.optStringOrNull(jSONObject, "contentType");
                if (jSONObject.has("metadata")) {
                    MediaMetadata mediaMetadata;
                    arrayList = jSONObject.getJSONObject("metadata");
                    n = arrayList.getInt("metadataType");
                    this.zzf = mediaMetadata = new MediaMetadata(n);
                    this.zzf.zzc((JSONObject)arrayList);
                }
                this.zzg = -1L;
                if (this.zzd != 2 && jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d2 = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d2) && d2 >= 0.0) {
                    this.zzg = CastUtils.secToMillisec(d2);
                }
                if (jSONObject.has("tracks")) break block15;
                this.zzh = null;
                break block16;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            JSONArray jSONArray = jSONObject.getJSONArray("tracks");
            for (int n2 = 0; n2 < jSONArray.length(); jSONObject2 = jSONObject2.optJSONObject("customData"), ++n2) {
                void var4_10;
                zzer zzer2;
                Object object;
                String string2;
                String string3;
                String string4;
                String string5;
                long l;
                block14: {
                    block17: {
                        String string6;
                        block20: {
                            block19: {
                                block18: {
                                    jSONObject2 = jSONArray.getJSONObject(n2);
                                    l = jSONObject2.getLong("trackId");
                                    String string7 = jSONObject2.optString("type");
                                    n = "TEXT".equals(string7) ? 1 : ("AUDIO".equals(string7) ? 2 : ("VIDEO".equals(string7) ? 3 : 0));
                                    string5 = CastUtils.optStringOrNull(jSONObject2, "trackContentId");
                                    string4 = CastUtils.optStringOrNull(jSONObject2, "trackContentType");
                                    string3 = CastUtils.optStringOrNull(jSONObject2, "name");
                                    string2 = CastUtils.optStringOrNull(jSONObject2, "language");
                                    if (!jSONObject2.has("subtype")) break block17;
                                    string6 = jSONObject2.getString("subtype");
                                    if (!"SUBTITLES".equals(string6)) break block18;
                                    boolean bl = true;
                                    break block14;
                                }
                                if (!"CAPTIONS".equals(string6)) break block19;
                                int n3 = 2;
                                break block14;
                            }
                            if (!"DESCRIPTIONS".equals(string6)) break block20;
                            int n4 = 3;
                            break block14;
                        }
                        if ("CHAPTERS".equals(string6)) {
                            int n5 = 4;
                            break block14;
                        } else if ("METADATA".equals(string6)) {
                            int n6 = 5;
                            break block14;
                        } else {
                            int n7 = -1;
                        }
                        break block14;
                    }
                    boolean bl = false;
                }
                if (jSONObject2.has("roles")) {
                    object = zzer.zzi();
                    JSONArray jSONArray2 = jSONObject2.getJSONArray("roles");
                    for (int i = 0; i < jSONArray2.length(); ++i) {
                        ((zzeo)object).zzc(jSONArray2.optString(i));
                    }
                    zzer2 = ((zzeo)object).zzd();
                } else {
                    zzer2 = null;
                }
                object = new MediaTrack(l, n, string5, string4, string3, string2, (int)var4_10, zzer2, jSONObject2);
                arrayList2.add(object);
            }
            this.zzh = arrayList = new ArrayList(arrayList2);
        }
        if (jSONObject.has("textTrackStyle")) {
            arrayList = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.fromJson((JSONObject)arrayList);
            this.zzi = textTrackStyle;
        } else {
            this.zzi = null;
        }
        this.zzr(jSONObject);
        this.zzs = jSONObject.optJSONObject("customData");
        this.zzl = CastUtils.optStringOrNull(jSONObject, "entity");
        this.zzo = CastUtils.optStringOrNull(jSONObject, "atvEntity");
        this.zzm = VastAdsRequest.fromJson(jSONObject.optJSONObject("vmapAdsRequest"));
        if (jSONObject.has("startAbsoluteTime") && !jSONObject.isNull("startAbsoluteTime") && !Double.isNaN(d = jSONObject.optDouble("startAbsoluteTime")) && !Double.isInfinite(d) && d >= 0.0) {
            this.zzn = CastUtils.secToMillisec(d);
        }
        if (jSONObject.has("contentUrl")) {
            this.zzp = jSONObject.optString("contentUrl");
        }
        this.zzq = CastUtils.optStringOrNull(jSONObject, "hlsSegmentFormat");
        this.zzr = CastUtils.optStringOrNull(jSONObject, "hlsVideoSegmentFormat");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @SafeParcelable.Constructor
    MediaInfo(@SafeParcelable.Param(id=2) @Nullable String var1_1, @SafeParcelable.Param(id=3) int var2_2, @SafeParcelable.Param(id=4) @Nullable String var3_3, @SafeParcelable.Param(id=5) @Nullable MediaMetadata var4_4, @SafeParcelable.Param(id=6) long var5_5, @SafeParcelable.Param(id=7) @Nullable List var7_6, @SafeParcelable.Param(id=8) @Nullable TextTrackStyle var8_7, @SafeParcelable.Param(id=9) @Nullable String var9_8, @SafeParcelable.Param(id=10) @Nullable List var10_9, @SafeParcelable.Param(id=11) @Nullable List var11_10, @SafeParcelable.Param(id=12) @Nullable String var12_11, @SafeParcelable.Param(id=13) @Nullable VastAdsRequest var13_12, @SafeParcelable.Param(id=14) long var14_13, @SafeParcelable.Param(id=15) @Nullable String var16_14, @SafeParcelable.Param(id=16) @Nullable String var17_15, @SafeParcelable.Param(id=17) @Nullable @HlsSegmentFormat String var18_16, @SafeParcelable.Param(id=18) @Nullable @HlsVideoSegmentFormat String var19_17) {
        super();
        this /* !! */ .zzt = var20_18 = this /* !! */ .new Writer();
        this /* !! */ .zzc = var1_1;
        this /* !! */ .zzd = var2_2;
        this /* !! */ .zze = var3_3;
        this /* !! */ .zzf = var4_4;
        this /* !! */ .zzg = var5_5;
        this /* !! */ .zzh = var7_6;
        this /* !! */ .zzi = var8_7;
        this /* !! */ .zzb = var9_8;
        if (this /* !! */ .zzb != null) {
            super(this /* !! */ .zzb);
            this /* !! */ .zzs = var1_1;
lbl15:
            // 3 sources

            while (true) {
                this /* !! */ .zzj = var10_9;
                this /* !! */ .zzk = var11_10;
                this /* !! */ .zzl = var12_11;
                this /* !! */ .zzm = var13_12;
                this /* !! */ .zzn = var14_13;
                this /* !! */ .zzo = var16_14;
                this /* !! */ .zzp = var17_15;
                this /* !! */ .zzq = var18_16;
                this /* !! */ .zzr = var19_17;
                if (this /* !! */ .zzc == null && this /* !! */ .zzp == null && this /* !! */ .zzl == null) {
                    super("Either contentID or contentUrl or entity should be set");
                    throw this /* !! */ ;
                }
                return;
            }
        }
        this /* !! */ .zzs = null;
        ** GOTO lbl15
        catch (JSONException v0) {
            this /* !! */ .zzs = null;
            this /* !! */ .zzb = null;
            ** continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTextTrackStyle(@NonNull TextTrackStyle textTrackStyle) {
        void var1_1;
        this.zzi = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        void var3_5;
        JSONObject jSONObject = this.zzs;
        if (jSONObject == null) {
            Object var3_4 = null;
        } else {
            String string2 = jSONObject.toString();
        }
        this.zzb = var3_5;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getContentId(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getStreamType());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getContentType(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.getMetadata(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)6, (long)this.getStreamDuration());
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)7, this.getMediaTracks(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)8, (Parcelable)this.getTextTrackStyle(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)9, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)10, this.getAdBreaks(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)11, this.getAdBreakClips(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)12, (String)this.getEntity(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)13, (Parcelable)this.getVmapAdsRequest(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)14, (long)this.getStartAbsoluteTime());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)15, (String)this.zzo, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)16, (String)this.getContentUrl(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)17, (String)this.getHlsSegmentFormat(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)18, (String)this.getHlsVideoSegmentFormat(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean equals(@Nullable Object other) {
        JSONObject jSONObject;
        boolean bl;
        void var1_1;
        if (this == var1_1) {
            return true;
        }
        if (!(var1_1 instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)var1_1;
        JSONObject jSONObject2 = this.zzs;
        boolean bl2 = jSONObject2 == null;
        if (bl2 != (bl = (jSONObject = mediaInfo.zzs) == null)) {
            return false;
        }
        if (jSONObject2 != null && jSONObject != null && !JsonUtils.areJsonValuesEquivalent((Object)jSONObject2, (Object)jSONObject)) {
            return false;
        }
        return CastUtils.zzh(this.zzc, mediaInfo.zzc) && this.zzd == mediaInfo.zzd && CastUtils.zzh(this.zze, mediaInfo.zze) && CastUtils.zzh((Object)this.zzf, (Object)mediaInfo.zzf) && this.zzg == mediaInfo.zzg && CastUtils.zzh(this.zzh, mediaInfo.zzh) && CastUtils.zzh((Object)this.zzi, (Object)mediaInfo.zzi) && CastUtils.zzh(this.zzj, mediaInfo.zzj) && CastUtils.zzh(this.zzk, mediaInfo.zzk) && CastUtils.zzh(this.zzl, mediaInfo.zzl) && CastUtils.zzh((Object)this.zzm, (Object)mediaInfo.zzm) && this.zzn == mediaInfo.zzn && CastUtils.zzh(this.zzo, mediaInfo.zzo) && CastUtils.zzh(this.zzp, mediaInfo.zzp) && CastUtils.zzh(this.zzq, mediaInfo.zzq) && CastUtils.zzh(this.zzr, mediaInfo.zzr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            long l;
            boolean bl;
            long l2;
            Object object;
            Object object2;
            jSONObject.put("contentId", (Object)this /* !! */ .zzc);
            jSONObject.putOpt("contentUrl", (Object)this /* !! */ .zzp);
            switch (this /* !! */ .zzd) {
                default: {
                    object2 = "NONE";
                    break;
                }
                case 2: {
                    object2 = "LIVE";
                    break;
                }
                case 1: {
                    object2 = "BUFFERED";
                }
            }
            jSONObject.put("streamType", object2);
            object2 = this /* !! */ .zze;
            if (object2 != null) {
                object = "contentType";
                jSONObject.put((String)object, object2);
            }
            if ((object2 = this /* !! */ .zzf) != null) {
                object = "metadata";
                jSONObject.put((String)object, (Object)((MediaMetadata)((Object)object2)).zza());
            }
            if ((l2 = this /* !! */ .zzg) <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                object2 = "duration";
                jSONObject.put((String)object2, CastUtils.millisecToSec(l2));
            }
            if ((object2 = this /* !! */ .zzh) != null) {
                object2 = new JSONArray();
                object = this /* !! */ .zzh.iterator();
                while (bl = object.hasNext()) {
                    object2.put((Object)((MediaTrack)((Object)object.next())).zza());
                }
                jSONObject.put("tracks", object2);
            }
            if ((object2 = this /* !! */ .zzi) != null) {
                object = "textTrackStyle";
                jSONObject.put((String)object, (Object)((TextTrackStyle)((Object)object2)).zza());
            }
            if ((object2 = this /* !! */ .zzs) != null) {
                object = "customData";
                jSONObject.put((String)object, object2);
            }
            if ((object2 = this /* !! */ .zzl) != null) {
                object = "entity";
                jSONObject.put((String)object, object2);
            }
            if ((object2 = this /* !! */ .zzj) != null) {
                object2 = new JSONArray();
                object = this /* !! */ .zzj.iterator();
                while (bl = object.hasNext()) {
                    object2.put((Object)((AdBreakInfo)((Object)object.next())).zza());
                }
                jSONObject.put("breaks", object2);
            }
            if ((object2 = this /* !! */ .zzk) != null) {
                object2 = new JSONArray();
                object = this /* !! */ .zzk.iterator();
                while (bl = object.hasNext()) {
                    object2.put((Object)((AdBreakClipInfo)((Object)object.next())).zza());
                }
                jSONObject.put("breakClips", object2);
            }
            if ((object2 = this /* !! */ .zzm) != null) {
                object = "vmapAdsRequest";
                jSONObject.put(object, (Object)((VastAdsRequest)((Object)object2)).zza());
            }
            if ((l = this /* !! */ .zzn) != -1L) {
                object2 = "startAbsoluteTime";
                jSONObject.put((String)object2, CastUtils.millisecToSec(l));
            }
            jSONObject.putOpt("atvEntity", (Object)this /* !! */ .zzo);
            object2 = this /* !! */ .zzq;
            if (object2 != null) {
                object = "hlsSegmentFormat";
                jSONObject.put((String)object, object2);
            }
            if ((this /* !! */  = this /* !! */ .zzr) == null) return jSONObject;
            object2 = "hlsVideoSegmentFormat";
            jSONObject.put((String)object2, (Object)this /* !! */ );
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzr(JSONObject jSONObject) throws JSONException {
        ArrayList arrayList;
        Object[] objectArray;
        Object[] objectArray2;
        block24: {
            ArrayList arrayList2;
            void var2_9;
            if (!jSONObject.has("breaks")) break block24;
            objectArray2 = jSONObject.getJSONArray("breaks");
            ArrayList<void> arrayList3 = new ArrayList<void>(objectArray2.length());
            boolean bl = false;
            while (var2_9 < objectArray2.length()) {
                void var3_21;
                block26: {
                    block27: {
                        JSONObject jSONObject2;
                        block25: {
                            jSONObject2 = objectArray2.getJSONObject((int)var2_9);
                            if (jSONObject2 != null) break block25;
                            Object var3_22 = null;
                            break block26;
                        }
                        if (!jSONObject2.has("id")) break block27;
                        if (!jSONObject2.has("position")) {
                            Object var3_31 = null;
                            break block26;
                        } else {
                            void var3_36;
                            AdBreakInfo adBreakInfo;
                            objectArray = jSONObject2.getString("id");
                            long l = CastUtils.secToMillisec(jSONObject2.getLong("position"));
                            boolean bl2 = jSONObject2.optBoolean("isWatched");
                            long l2 = CastUtils.secToMillisec(jSONObject2.optLong("duration"));
                            JSONArray jSONArray = jSONObject2.optJSONArray("breakClipIds");
                            String[] stringArray = new String[]{};
                            if (jSONArray != null) {
                                int n;
                                void var3_34;
                                String[] stringArray2 = new String[jSONArray.length()];
                                boolean bl3 = false;
                                while (var3_34 < (n = jSONArray.length())) {
                                    stringArray2[var3_34] = jSONArray.getString((int)var3_34);
                                    ++var3_34;
                                }
                                String[] stringArray3 = stringArray2;
                            }
                            boolean bl4 = jSONObject2.optBoolean("isEmbedded");
                            boolean bl5 = jSONObject2.optBoolean("expanded");
                            AdBreakInfo adBreakInfo2 = adBreakInfo = new AdBreakInfo(l, (String)objectArray, l2, bl2, (String[])var3_36, bl4, bl5);
                        }
                    }
                    Object var3_38 = null;
                    break block26;
                    catch (JSONException jSONException) {
                        Locale locale = Locale.ROOT;
                        objectArray = new Object[]{jSONException.getMessage()};
                        Log.d((String)"AdBreakInfo", (String)String.format(locale, "Error while creating an AdBreakInfo from JSON: %s", objectArray));
                        Object var3_41 = null;
                    }
                }
                if (var3_21 != null) {
                    arrayList3.add(var3_21);
                    ++var2_9;
                    continue;
                }
                arrayList3.clear();
                break;
            }
            this.zzj = arrayList2 = new ArrayList(arrayList3);
        }
        if (!jSONObject.has("breakClips")) {
            return;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("breakClips");
        objectArray = new ArrayList(jSONArray.length());
        for (int i = 0; i < jSONArray.length(); ++i) {
            void var2_13;
            JSONObject jSONObject3 = jSONArray.getJSONObject(i);
            if (jSONObject3 == null) {
                Object var2_12 = null;
            } else if (!jSONObject3.has("id")) {
                Object var2_14 = null;
            } else {
                try {
                    void var3_28;
                    void var2_17;
                    AdBreakClipInfo adBreakClipInfo;
                    long l;
                    String string2 = jSONObject3.getString("id");
                    long l3 = CastUtils.secToMillisec(jSONObject3.optLong("duration"));
                    String string3 = CastUtils.optStringOrNull(jSONObject3, "clickThroughUrl");
                    String string4 = CastUtils.optStringOrNull(jSONObject3, "contentUrl");
                    String string5 = CastUtils.optStringOrNull(jSONObject3, "mimeType");
                    if (string5 == null) {
                        String string6 = CastUtils.optStringOrNull(jSONObject3, "contentType");
                    }
                    String string7 = CastUtils.optStringOrNull(jSONObject3, "title");
                    JSONObject jSONObject4 = jSONObject3.optJSONObject("customData");
                    String string8 = CastUtils.optStringOrNull(jSONObject3, "contentId");
                    String string9 = CastUtils.optStringOrNull(jSONObject3, "posterUrl");
                    boolean bl = jSONObject3.has("whenSkippable");
                    long l4 = bl ? (l = CastUtils.secToMillisec(((Integer)jSONObject3.get("whenSkippable")).intValue())) : -1L;
                    String string10 = CastUtils.optStringOrNull(jSONObject3, "hlsSegmentFormat");
                    VastAdsRequest vastAdsRequest = VastAdsRequest.fromJson(jSONObject3.optJSONObject("vastAdsRequest"));
                    if (jSONObject4 != null) {
                        int n = jSONObject4.length();
                        if (n == 0) {
                            Object var3_27 = null;
                        } else {
                            String string11 = jSONObject4.toString();
                        }
                    } else {
                        Object var3_30 = null;
                    }
                    AdBreakClipInfo adBreakClipInfo2 = adBreakClipInfo = new AdBreakClipInfo(string2, string7, l3, string4, (String)var2_17, string3, (String)var3_28, string8, string9, l4, string10, vastAdsRequest);
                }
                catch (JSONException jSONException) {
                    Locale locale = Locale.ROOT;
                    objectArray2 = new Object[]{jSONException.getMessage()};
                    Log.d((String)"AdBreakClipInfo", (String)String.format(locale, "Error while creating an AdBreakClipInfo from JSON: %s", objectArray2));
                    Object var2_20 = null;
                }
            }
            if (var2_13 != null) {
                objectArray.add(var2_13);
                continue;
            }
            objectArray.clear();
            break;
        }
        this.zzk = arrayList = new ArrayList(objectArray);
    }

    @KeepForSdk
    public class Writer {
        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setAdBreakClips(@Nullable List<AdBreakClipInfo> adBreakClips) {
            void var1_1;
            MediaInfo.this.zzk = (List)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setAdBreaks(@Nullable List<AdBreakInfo> adBreaks) {
            void var1_1;
            MediaInfo.this.zzj = (List)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setContentId(@NonNull String contentId) {
            void var1_1;
            MediaInfo.this.zzc = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setContentType(@Nullable String contentType) {
            void var1_1;
            MediaInfo.this.zze = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setContentUrl(@Nullable String contentUrl) {
            void var1_1;
            MediaInfo.this.zzp = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setCustomData(@Nullable JSONObject customData) {
            void var1_1;
            MediaInfo.this.zzs = (JSONObject)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setEntity(@Nullable String entity) {
            void var1_1;
            MediaInfo.this.zzl = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setHlsSegmentFormat(@Nullable @HlsSegmentFormat String hlsSegmentFormat) {
            void var1_1;
            MediaInfo.this.zzq = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setHlsVideoSegmentFormat(@Nullable @HlsVideoSegmentFormat String hlsVideoSegmentFormat) {
            void var1_1;
            MediaInfo.this.zzr = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setMediaTracks(@Nullable List<MediaTrack> mediaTracks) {
            void var1_1;
            MediaInfo.this.zzh = (List)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setMetadata(@Nullable MediaMetadata metadata) {
            void var1_1;
            MediaInfo.this.zzf = (MediaMetadata)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setStartAbsoluteTime(long startAbsoluteTime) {
            void var1_1;
            if (startAbsoluteTime < 0L && var1_1 != -1L) {
                Object object = new IllegalArgumentException("Invalid start absolute time");
                throw object;
            }
            ((Writer)object).MediaInfo.this.zzn = (long)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setStreamDuration(long streamDuration) {
            void var1_1;
            if (streamDuration < 0L && var1_1 != -1L) {
                Object object = new IllegalArgumentException("Invalid stream duration");
                throw object;
            }
            ((Writer)object).MediaInfo.this.zzg = (long)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setStreamType(int streamType) {
            void var1_1;
            if (streamType < -1 || var1_1 > 2) {
                Object object = new IllegalArgumentException("invalid stream type");
                throw object;
            }
            ((Writer)object).MediaInfo.this.zzd = (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setTextTrackStyle(@Nullable TextTrackStyle textTrackStyle) {
            void var1_1;
            MediaInfo.this.zzi = (TextTrackStyle)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setVmapAdsRequest(@Nullable VastAdsRequest vmapAdsRequest) {
            void var1_1;
            MediaInfo.this.zzm = (VastAdsRequest)var1_1;
        }
    }

    public static class Builder {
        @Nullable
        private String zza;
        private int zzb = -1;
        @Nullable
        private String zzc;
        @Nullable
        private MediaMetadata zzd;
        private long zze = -1L;
        @Nullable
        private List zzf;
        @Nullable
        private TextTrackStyle zzg;
        @Nullable
        private String zzh;
        @Nullable
        private List zzi;
        @Nullable
        private List zzj;
        @Nullable
        private String zzk;
        @Nullable
        private VastAdsRequest zzl;
        private long zzm = -1L;
        @Nullable
        private String zzn;
        @Nullable
        private String zzo;
        @Nullable
        @HlsSegmentFormat
        private String zzp;
        @Nullable
        @HlsVideoSegmentFormat
        private String zzq;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAdBreakClips(@Nullable List<AdBreakClipInfo> adBreakClips) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAdBreaks(@Nullable List<AdBreakInfo> adBreaks) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAtvEntity(@NonNull String atvEntity) {
            void var1_1;
            this.zzn = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContentType(@Nullable String contentType) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContentUrl(@NonNull String contentUrl) {
            void var1_1;
            this.zzo = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setCustomData(@Nullable JSONObject customData) {
            String string2;
            string2 = customData == null ? null : string2.toString();
            this.zzh = string2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEntity(@NonNull String entity) {
            void var1_1;
            this.zzk = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHlsSegmentFormat(@Nullable @HlsSegmentFormat String hlsSegmentFormat) {
            void var1_1;
            this.zzp = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHlsVideoSegmentFormat(@Nullable @HlsVideoSegmentFormat String hlsVideoSegmentFormat) {
            void var1_1;
            this.zzq = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMediaTracks(@Nullable List<MediaTrack> mediaTracks) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMetadata(@Nullable MediaMetadata metadata) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStreamDuration(long streamDuration) {
            void var1_1;
            if (streamDuration < 0L && var1_1 != -1L) {
                Object object = new IllegalArgumentException("Invalid stream duration");
                throw object;
            }
            ((Builder)object).zze = var1_1;
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStreamType(int streamType) {
            void var1_1;
            if (streamType < -1 || var1_1 > 2) {
                Object object = new IllegalArgumentException("invalid stream type");
                throw object;
            }
            ((Builder)object).zzb = var1_1;
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTextTrackStyle(@Nullable TextTrackStyle textTrackStyle) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setVmapAdsRequest(@Nullable VastAdsRequest vmapAdsRequest) {
            void var1_1;
            this.zzl = var1_1;
            return this;
        }

        @NonNull
        public MediaInfo build() {
            MediaInfo mediaInfo = new MediaInfo(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, this.zzm, this.zzn, this.zzo, this.zzp, this.zzq);
            return mediaInfo;
        }

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String contentId) {
            void var1_1;
            this.zza = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String contentId, @Nullable String entity) {
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzk = var2_2;
        }
    }
}

