/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayClient;
import com.google.android.gms.cast.R;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.zzag;
import com.google.android.gms.cast.zzah;
import com.google.android.gms.cast.zzai;
import com.google.android.gms.cast.zzaj;
import com.google.android.gms.cast.zzak;
import com.google.android.gms.cast.zzal;
import com.google.android.gms.cast.zzam;
import com.google.android.gms.cast.zzan;
import com.google.android.gms.cast.zzap;
import com.google.android.gms.cast.zzar;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.cast.zzdk;
import com.google.android.gms.internal.cast.zzdl;
import com.google.android.gms.internal.cast.zzdm;
import com.google.android.gms.tasks.OnCompleteListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

@Deprecated
@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final Logger zza;
    private static final int zzb;
    private static final Object zzc;
    private static final AtomicBoolean zzd;
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static CastRemoteDisplayLocalService zze;
    @Nullable
    private String zzf;
    private WeakReference zzg;
    private zzar zzh;
    private NotificationSettings zzi;
    @Nullable
    private Notification zzj;
    private boolean zzk;
    private PendingIntent zzl;
    private CastDevice zzm;
    @Nullable
    private Display zzn;
    @Nullable
    private Context zzo;
    @Nullable
    private ServiceConnection zzp;
    private Handler zzq;
    private MediaRouter zzr;
    private boolean zzs = false;
    private CastRemoteDisplayClient zzt;
    private final MediaRouter.Callback zzu;
    private final IBinder zzv;

    public int onStartCommand(@NonNull Intent intent, int n, int n2) {
        this.zzv("onStartCommand");
        this.zzs = true;
        return 2;
    }

    @NonNull
    public IBinder onBind(@NonNull Intent intent) {
        this.zzv("onBind");
        return this.zzv;
    }

    @Nullable
    protected Display getCastRemoteDisplay() {
        return this.zzn;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzc;
        synchronized (object) {
            return zze;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static {
        Object object = new Logger("CastRDLocalService");
        zza = object;
        zzb = R.id.cast_notification_id;
        zzc = object = new Object();
        zzd = object = new AtomicBoolean(false);
    }

    public CastRemoteDisplayLocalService() {
        Object object = new zzag(this);
        this.zzu = object;
        super(this);
        this.zzv = object;
    }

    public void onCreate() {
        this.zzv("onCreate");
        super.onCreate();
        Object object = new zzdm(this.getMainLooper());
        this.zzq = object;
        object = this.zzq;
        zzah zzah2 = new zzah(this);
        object.postDelayed(zzah2, 100L);
        if (this.zzt == null) {
            this.zzt = CastRemoteDisplay.getClient((Context)this);
        }
        if (!PlatformVersion.isAtLeastO()) {
            return;
        }
        object = this.getSystemService(NotificationManager.class);
        object = (NotificationManager)object;
        zzah2 = new NotificationChannel("cast_remote_display_local_service", (CharSequence)this.getString(R.string.cast_notification_default_channel_name), 2);
        zzah2.setShowBadge(false);
        object.createNotificationChannel((NotificationChannel)zzah2);
    }

    public abstract void onCreatePresentation(@NonNull Display var1);

    public abstract void onDismissPresentation();

    protected static void setDebugEnabled() {
        zza.zzb(true);
    }

    /*
     * WARNING - void declaration
     */
    public static void startService(@NonNull Context activityContext, @NonNull Class<? extends CastRemoteDisplayLocalService> serviceClass, @NonNull String applicationId, @NonNull CastDevice device, @NonNull NotificationSettings notificationSettings, @NonNull Callbacks callbacks) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Context context;
        Options options = new Options();
        CastRemoteDisplayLocalService.startServiceWithOptions(context, (Class<? extends CastRemoteDisplayLocalService>)var1_1, (String)var2_2, (CastDevice)var3_3, options, (NotificationSettings)var4_4, (Callbacks)var5_5);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void startServiceWithOptions(@NonNull Context activityContext, @NonNull Class<? extends CastRemoteDisplayLocalService> serviceClass, @NonNull String applicationId, @NonNull CastDevice device, @NonNull Options options, @NonNull NotificationSettings notificationSettings, @NonNull Callbacks callbacks) {
        Object object;
        block10: {
            void var6_8;
            void var5_7;
            void var4_6;
            void var3_5;
            void var2_4;
            IllegalStateException illegalStateException;
            Object object2;
            zza.d("Starting Service", new Object[0]);
            Object object3 = zzc;
            synchronized (object3) {
                object2 = zze;
                if (object2 != null) {
                    zza.w("An existing service had not been stopped before starting one", new Object[0]);
                    CastRemoteDisplayLocalService.zzw(true);
                }
            }
            try {
                boolean bl;
                object3 = new ComponentName(object, (Class)((Object)illegalStateException));
                object3 = object.getPackageManager().getServiceInfo((ComponentName)object3, 128);
                if (object3 != null && (bl = ((ServiceInfo)object3).exported)) break block10;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                illegalStateException = new IllegalStateException("Service not found, did you forget to configure it in the manifest?", nameNotFoundException);
                throw illegalStateException;
            }
            Preconditions.checkNotNull((Object)object, (Object)"activityContext is required.");
            Preconditions.checkNotNull((Object)illegalStateException, (Object)"serviceClass is required.");
            Preconditions.checkNotNull((Object)var2_4, (Object)"applicationId is required.");
            Preconditions.checkNotNull((Object)var3_5, (Object)"device is required.");
            Preconditions.checkNotNull((Object)var4_6, (Object)"options is required.");
            Preconditions.checkNotNull((Object)var5_7, (Object)"notificationSettings is required.");
            Preconditions.checkNotNull((Object)var6_8, (Object)"callbacks is required.");
            if (((NotificationSettings)var5_7).zza == null && ((NotificationSettings)var5_7).zzb == null) {
                object = new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
                throw object;
            }
            if (zzd.getAndSet(true)) {
                zza.e("Service is already being started, startService has been called twice", new Object[0]);
                return;
            }
            Intent intent = new Intent(object, (Class)((Object)illegalStateException));
            object.startService(intent);
            illegalStateException = ConnectionTracker.getInstance();
            object2 = new zzai((String)var2_4, (CastDevice)var3_5, (Options)var4_6, (NotificationSettings)var5_7, (Context)object, (Callbacks)var6_8);
            illegalStateException.bindService((Context)object, intent, (ServiceConnection)object2, 64);
            return;
        }
        object = new IllegalStateException("The service must not be exported, verify the manifest configuration");
        throw object;
        {
            catch (Throwable throwable) {}
            {
                throw throwable;
            }
        }
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzw(false);
    }

    /*
     * WARNING - void declaration
     */
    public void updateNotificationSettings(@NonNull NotificationSettings notificationSettings) {
        void var1_1;
        Preconditions.checkNotNull((Object)notificationSettings, (Object)"notificationSettings is required.");
        Preconditions.checkNotNull((Object)this.zzq, (Object)"Service is not ready yet.");
        Handler handler = this.zzq;
        zzak zzak2 = new zzak(this, (NotificationSettings)var1_1);
        handler.post((Runnable)zzak2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Notification zzu(boolean bl) {
        void var1_5;
        int n;
        this.zzv("createDefaultNotification");
        String string2 = this.zzi.zzc;
        NotificationCompat.Builder builder = this.zzi.zzd;
        if (bl) {
            int n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            int n3 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = (String)this.getPackageManager().getApplicationLabel(this.getApplicationInfo());
        }
        if (TextUtils.isEmpty((CharSequence)builder)) {
            void var1_3;
            builder = new NotificationCompat.Builder[]{this.zzm.getFriendlyName()};
            String string3 = this.getString((int)var1_3, (Object[])builder);
        } else {
            NotificationCompat.Builder builder2 = builder;
        }
        builder = new NotificationCompat.Builder((Context)this, "cast_remote_display_local_service");
        NotificationCompat.Builder builder3 = builder.setContentTitle((CharSequence)string2).setContentText((CharSequence)var1_5).setContentIntent(this.zzi.zzb).setSmallIcon(n).setOngoing(true);
        String string4 = this.getString(R.string.cast_notification_disconnect);
        if (this.zzl == null) {
            Preconditions.checkNotNull((Object)this.zzo, (Object)"activityContext is required.");
            string2 = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            string2.setPackage(this.zzo.getPackageName());
            this.zzl = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)string2, (int)(zzdl.zza | 0x8000000));
        }
        return builder3.addAction(17301560, (CharSequence)string4, this.zzl).build();
    }

    static /* bridge */ /* synthetic */ Context zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzo;
    }

    static /* bridge */ /* synthetic */ ServiceConnection zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzp;
    }

    static /* bridge */ /* synthetic */ CastDevice zzc(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzm;
    }

    static /* bridge */ /* synthetic */ CastRemoteDisplayLocalService zzd() {
        return zze;
    }

    static /* bridge */ /* synthetic */ Logger zze() {
        return zza;
    }

    static /* bridge */ /* synthetic */ Object zzf() {
        return zzc;
    }

    static /* bridge */ /* synthetic */ WeakReference zzg(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzg;
    }

    static /* bridge */ /* synthetic */ AtomicBoolean zzh() {
        return zzd;
    }

    static /* bridge */ /* synthetic */ void zzi(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Context context) {
        castRemoteDisplayLocalService.zzo = null;
    }

    static /* bridge */ /* synthetic */ void zzj(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zzn = null;
    }

    static /* bridge */ /* synthetic */ void zzk(CastRemoteDisplayLocalService castRemoteDisplayLocalService, ServiceConnection serviceConnection) {
        castRemoteDisplayLocalService.zzp = null;
    }

    static /* bridge */ /* synthetic */ void zzl(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display object) {
        if (object == null) {
            zza.e("Cast Remote Display session created without display", new Object[0]);
            return;
        }
        castRemoteDisplayLocalService.zzn = object;
        if (castRemoteDisplayLocalService.zzk) {
            castRemoteDisplayLocalService.zzj = castRemoteDisplayLocalService.zzu(true);
            castRemoteDisplayLocalService.startForeground(zzb, castRemoteDisplayLocalService.zzj);
        }
        if ((object = (Callbacks)castRemoteDisplayLocalService.zzg.get()) != null) {
            object.onRemoteDisplaySessionStarted(castRemoteDisplayLocalService);
        }
        Preconditions.checkNotNull((Object)castRemoteDisplayLocalService.zzn, (Object)"display is required.");
        castRemoteDisplayLocalService.onCreatePresentation(castRemoteDisplayLocalService.zzn);
    }

    static /* bridge */ /* synthetic */ void zzm(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzv(string2);
    }

    static /* bridge */ /* synthetic */ void zzn(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String object) {
        object = zza;
        Object[] objectArray = new Object[]{castRemoteDisplayLocalService, "The local service has not been been started, stopping it"};
        ((Logger)object).e("[Instance: %s] %s", objectArray);
    }

    static /* bridge */ /* synthetic */ void zzo(CastRemoteDisplayLocalService object) {
        object = (Callbacks)((CastRemoteDisplayLocalService)((Object)object)).zzg.get();
        if (object != null) {
            Status status = new Status(2200);
            object.onRemoteDisplaySessionError(status);
        }
        CastRemoteDisplayLocalService.stopService();
    }

    static /* bridge */ /* synthetic */ void zzp(CastRemoteDisplayLocalService castRemoteDisplayLocalService, boolean bl) {
        castRemoteDisplayLocalService.zzx(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzq(CastRemoteDisplayLocalService object, NotificationSettings notificationSettings) {
        Preconditions.checkMainThread((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (((CastRemoteDisplayLocalService)((Object)object)).zzi == null) {
            object = new IllegalStateException("No current notification settings to update");
            throw object;
        }
        if (((CastRemoteDisplayLocalService)((Object)object)).zzk) {
            if (notificationSettings.zza != null) {
                object = new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
                throw object;
            }
            if (notificationSettings.zzb != null) {
                ((CastRemoteDisplayLocalService)((Object)object)).zzi.zzb = notificationSettings.zzb;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzc)) {
                ((CastRemoteDisplayLocalService)((Object)object)).zzi.zzc = notificationSettings.zzc;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzd)) {
                ((CastRemoteDisplayLocalService)((Object)object)).zzi.zzd = notificationSettings.zzd;
            }
            ((CastRemoteDisplayLocalService)((Object)object)).zzj = super.zzu(true);
        } else {
            Preconditions.checkNotNull((Object)notificationSettings.zza, (Object)"notification is required.");
            ((CastRemoteDisplayLocalService)((Object)object)).zzj = notificationSettings.zza;
            ((CastRemoteDisplayLocalService)((Object)object)).zzi.zza = ((CastRemoteDisplayLocalService)((Object)object)).zzj;
        }
        object.startForeground(zzb, ((CastRemoteDisplayLocalService)((Object)object)).zzj);
    }

    static /* bridge */ /* synthetic */ void zzr(boolean bl) {
        CastRemoteDisplayLocalService.zzw(false);
    }

    private final void zzv(String string2) {
        Logger logger = zza;
        Object[] objectArray = new Object[]{this, string2};
        logger.d("[Instance: %s] %s", objectArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void zzw(boolean bl) {
        block6: {
            zza.d("Stopping Service", new Object[0]);
            zzd.set(false);
            Object object = zzc;
            // MONITORENTER : object
            CastRemoteDisplayLocalService castRemoteDisplayLocalService = zze;
            if (castRemoteDisplayLocalService == null) break block6;
            zze = null;
            // MONITOREXIT : object
            if (castRemoteDisplayLocalService.zzq == null) return;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
            if (Looper.myLooper() != Looper.getMainLooper()) {
                object = castRemoteDisplayLocalService.zzq;
                zzaj zzaj2 = new zzaj(castRemoteDisplayLocalService, bl);
                object.post((Runnable)zzaj2);
                return;
            }
            castRemoteDisplayLocalService.zzx(bl);
            return;
        }
        zza.e("Service is already being stopped", new Object[0]);
        // MONITOREXIT : object
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzx(boolean bl) {
        this.zzv("Stopping Service");
        Preconditions.checkMainThread((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzr != null) {
            this.zzv("Setting default route");
            MediaRouter mediaRouter = this.zzr;
            mediaRouter.selectRoute(mediaRouter.getDefaultRoute());
        }
        if (this.zzh != null) {
            this.zzv("Unregistering notification receiver");
            this.unregisterReceiver(this.zzh);
        }
        this.zzv("stopRemoteDisplaySession");
        this.zzv("stopRemoteDisplay");
        Object object = this.zzt;
        object = ((CastRemoteDisplayClient)((Object)object)).stopRemoteDisplay();
        zzan zzan2 = new zzan(this);
        object.addOnCompleteListener((OnCompleteListener)zzan2);
        object = (Callbacks)this.zzg.get();
        if (object != null) {
            object.onRemoteDisplaySessionEnded(this);
        }
        this.onDismissPresentation();
        this.zzv("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
        if (this.zzr != null) {
            Preconditions.checkMainThread((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzv("removeMediaRouterCallback");
            this.zzr.removeCallback(this.zzu);
        }
        object = this.zzo;
        zzan2 = this.zzp;
        if (object != null && zzan2 != null) {
            try {
                ConnectionTracker.getInstance().unbindService((Context)object, (ServiceConnection)zzan2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzv("No need to unbind service, already unbound");
            }
        }
        this.zzp = null;
        this.zzo = null;
        this.zzf = null;
        this.zzj = null;
        this.zzn = null;
    }

    static /* bridge */ /* synthetic */ boolean zzs(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ boolean zzt(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String object, CastDevice object2, Options options, NotificationSettings notificationSettings, Context object3, ServiceConnection object4, Callbacks callbacks) {
        block10: {
            castRemoteDisplayLocalService.zzv("startRemoteDisplaySession");
            Preconditions.checkMainThread((String)"Starting the Cast Remote Display must be done on the main thread");
            WeakReference<Callbacks> weakReference = zzc;
            synchronized (weakReference) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = zze;
                if (castRemoteDisplayLocalService2 != null) {
                    zza.w("An existing service had not been stopped before starting one", new Object[0]);
                    return false;
                }
                zze = castRemoteDisplayLocalService;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var8_13
                castRemoteDisplayLocalService.zzg = weakReference = new WeakReference<Callbacks>(callbacks);
                castRemoteDisplayLocalService.zzf = object;
                castRemoteDisplayLocalService.zzm = object2;
                castRemoteDisplayLocalService.zzo = object3;
                castRemoteDisplayLocalService.zzp = object4;
                if (castRemoteDisplayLocalService.zzr != null) break block10;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            castRemoteDisplayLocalService.zzr = MediaRouter.getInstance((Context)castRemoteDisplayLocalService.getApplicationContext());
        }
        Preconditions.checkNotNull((Object)castRemoteDisplayLocalService.zzf, (Object)"applicationId is required.");
        object = new MediaRouteSelector.Builder();
        object3 = castRemoteDisplayLocalService.zzf;
        object3 = CastMediaControlIntent.categoryForCast((String)object3);
        object = object.addControlCategory((String)object3);
        object = object.build();
        castRemoteDisplayLocalService.zzv("addMediaRouterCallback");
        castRemoteDisplayLocalService.zzr.addCallback((MediaRouteSelector)object, castRemoteDisplayLocalService.zzu, 4);
        castRemoteDisplayLocalService.zzj = notificationSettings.zza;
        object = new zzar(null);
        castRemoteDisplayLocalService.zzh = object;
        object = new IntentFilter();
        object.addAction("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
        object.addAction("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        if (PlatformVersion.isAtLeastT()) {
            castRemoteDisplayLocalService.registerReceiver(castRemoteDisplayLocalService.zzh, (IntentFilter)object, 4);
        } else {
            zzdk.zza((Context)castRemoteDisplayLocalService, castRemoteDisplayLocalService.zzh, (IntentFilter)object);
        }
        object = new NotificationSettings(notificationSettings, null);
        castRemoteDisplayLocalService.zzi = object;
        if (castRemoteDisplayLocalService.zzi.zza == null) {
            castRemoteDisplayLocalService.zzk = true;
            castRemoteDisplayLocalService.zzj = castRemoteDisplayLocalService.zzu(false);
        } else {
            castRemoteDisplayLocalService.zzk = false;
            castRemoteDisplayLocalService.zzj = castRemoteDisplayLocalService.zzi.zza;
        }
        castRemoteDisplayLocalService.startForeground(zzb, castRemoteDisplayLocalService.zzj);
        castRemoteDisplayLocalService.zzv("startRemoteDisplay");
        object = new Intent("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        Preconditions.checkNotNull((Object)castRemoteDisplayLocalService.zzo, (Object)"activityContext is required.");
        object.setPackage(castRemoteDisplayLocalService.zzo.getPackageName());
        int n = zzdl.zza;
        object = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)object, (int)n);
        zzal zzal2 = new zzal(castRemoteDisplayLocalService);
        Preconditions.checkNotNull((Object)castRemoteDisplayLocalService.zzf, (Object)"applicationId is required.");
        object3 = castRemoteDisplayLocalService.zzt;
        object4 = castRemoteDisplayLocalService.zzf;
        int n2 = options.getConfigPreset();
        object = ((CastRemoteDisplayClient)((Object)object3)).zze((CastDevice)((Object)object2), (String)object4, n2, (PendingIntent)object, zzal2);
        object2 = new zzam(castRemoteDisplayLocalService);
        object.addOnCompleteListener((OnCompleteListener)object2);
        object = (Callbacks)castRemoteDisplayLocalService.zzg.get();
        if (object == null) {
            return true;
        }
        object.onServiceCreated(castRemoteDisplayLocalService);
        return true;
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        int zza = 2;

        @CastRemoteDisplay.Configuration
        public int getConfigPreset() {
            return this.zza;
        }

        /*
         * WARNING - void declaration
         */
        public void setConfigPreset(@CastRemoteDisplay.Configuration int configPreset) {
            void var1_1;
            this.zza = var1_1;
        }
    }

    public static final class NotificationSettings {
        private Notification zza;
        private PendingIntent zzb;
        private String zzc;
        private String zzd;

        private NotificationSettings() {
        }

        /* synthetic */ NotificationSettings(zzap zzap2) {
        }

        /* synthetic */ NotificationSettings(NotificationSettings notificationSettings, zzap zzap2) {
            this.zza = notificationSettings.zza;
            this.zzb = notificationSettings.zzb;
            this.zzc = notificationSettings.zzc;
            this.zzd = notificationSettings.zzd;
        }

        public static final class Builder {
            private final NotificationSettings zza;

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setNotification(@NonNull Notification notification) {
                void var1_1;
                this.zza.zza = (Notification)var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setNotificationPendingIntent(@NonNull PendingIntent notificationPendingIntent) {
                void var1_1;
                this.zza.zzb = (PendingIntent)var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setNotificationText(@NonNull String notificationText) {
                void var1_1;
                this.zza.zzd = (String)var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setNotificationTitle(@NonNull String notificationTitle) {
                void var1_1;
                this.zza.zzc = (String)var1_1;
                return this;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NonNull
            public NotificationSettings build() {
                Object this_;
                if (((Builder)this_).zza.zza != null) {
                    if (!TextUtils.isEmpty((CharSequence)((Builder)this_).zza.zzc)) {
                        this_ = new IllegalArgumentException("notificationTitle requires using the default notification");
                        throw this_;
                    }
                    if (!TextUtils.isEmpty((CharSequence)((Builder)this_).zza.zzd)) {
                        this_ = new IllegalArgumentException("notificationText requires using the default notification");
                        throw this_;
                    }
                    if (((Builder)this_).zza.zzb == null) return ((Builder)this_).zza;
                    this_ = new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    throw this_;
                }
                if (!TextUtils.isEmpty((CharSequence)((Builder)this_).zza.zzc) || !TextUtils.isEmpty((CharSequence)((Builder)this_).zza.zzd) || ((Builder)this_).zza.zzb != null) {
                    return ((Builder)this_).zza;
                }
                this_ = new IllegalArgumentException("At least an argument must be provided");
                throw this_;
            }

            public Builder() {
                NotificationSettings notificationSettings;
                this.zza = notificationSettings = new NotificationSettings(null);
            }
        }
    }

    public static interface Callbacks {
        public void onRemoteDisplayMuteStateChanged(boolean var1);

        public void onRemoteDisplaySessionEnded(@NonNull CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(@NonNull Status var1);

        public void onRemoteDisplaySessionStarted(@NonNull CastRemoteDisplayLocalService var1);

        public void onServiceCreated(@NonNull CastRemoteDisplayLocalService var1);
    }
}

