/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdBreakInfoCreator")
public class AdBreakInfo
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<AdBreakInfo> CREATOR;
    @SafeParcelable.Field(id=2, getter="getPlaybackPositionInMs")
    private final long zza;
    @SafeParcelable.Field(id=3, getter="getId")
    private final String zzb;
    @SafeParcelable.Field(id=4, getter="getDurationInMs")
    private final long zzc;
    @SafeParcelable.Field(id=5, getter="isWatched")
    private final boolean zzd;
    @SafeParcelable.Field(id=6, getter="getBreakClipIds")
    private final String[] zze;
    @SafeParcelable.Field(id=7, getter="isEmbedded")
    private final boolean zzf;
    @SafeParcelable.Field(id=8, getter="isExpanded")
    private final boolean zzg;

    public int hashCode() {
        return this.zzb.hashCode();
    }

    public long getDurationInMs() {
        return this.zzc;
    }

    public long getPlaybackPositionInMs() {
        return this.zza;
    }

    @NonNull
    public String getId() {
        return this.zzb;
    }

    static {
        zzb zzb2;
        CREATOR = zzb2 = new zzb();
    }

    @SafeParcelable.Constructor
    public AdBreakInfo(@SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) @NonNull String string, @SafeParcelable.Param(id=4) long l2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) @NonNull String[] stringArray, @SafeParcelable.Param(id=7) boolean bl2, @SafeParcelable.Param(id=8) boolean bl3) {
        this.zza = l;
        this.zzb = string;
        this.zzc = l2;
        this.zzd = bl;
        this.zze = stringArray;
        this.zzf = bl2;
        this.zzg = bl3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getPlaybackPositionInMs());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getId(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)4, (long)this.getDurationInMs());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.isWatched());
        SafeParcelWriter.writeStringArray((Parcel)var1_1, (int)6, (String[])this.getBreakClipIds(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)7, (boolean)this.isEmbedded());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)8, (boolean)this.isExpanded());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object other) {
        AdBreakInfo adBreakInfo;
        if (this == adBreakInfo) {
            return true;
        }
        if (!(adBreakInfo instanceof AdBreakInfo)) {
            return false;
        }
        adBreakInfo = adBreakInfo;
        return CastUtils.zzh(this.zzb, adBreakInfo.zzb) && this.zza == adBreakInfo.zza && this.zzc == adBreakInfo.zzc && this.zzd == adBreakInfo.zzd && Arrays.equals(this.zze, adBreakInfo.zze) && this.zzf == adBreakInfo.zzf && this.zzg == adBreakInfo.zzg;
    }

    public boolean isEmbedded() {
        return this.zzf;
    }

    @KeepForSdk
    public boolean isExpanded() {
        return this.zzg;
    }

    public boolean isWatched() {
        return this.zzd;
    }

    @NonNull
    public String[] getBreakClipIds() {
        return this.zze;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject;
        block7: {
            jSONObject = new JSONObject();
            jSONObject.put("id", (Object)this.zzb);
            jSONObject.put("position", CastUtils.millisecToSec(this.zza));
            jSONObject.put("isWatched", this.zzd);
            jSONObject.put("isEmbedded", this.zzf);
            jSONObject.put("duration", CastUtils.millisecToSec(this.zzc));
            jSONObject.put("expanded", this.zzg);
            JSONArray jSONArray = this.zze;
            if (jSONArray == null) break block7;
            jSONArray = new JSONArray();
            String[] stringArray = this.zze;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                jSONArray.put((Object)stringArray[i]);
                continue;
            }
            try {
                jSONObject.put("breakClipIds", (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                return jSONObject;
            }
        }
        return jSONObject;
    }

    public static class Builder {
        private final long zza;
        private String zzb;
        private long zzc;
        private boolean zzd;
        private boolean zze;
        private String[] zzf;
        private boolean zzg;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBreakClipIds(@NonNull String[] breakClipIds) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDurationInMs(long durationInMs) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setId(@NonNull String id) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setIsEmbedded(boolean isEmbedded) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setIsExpanded(boolean isExpanded) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setIsWatched(boolean isWatched) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        @NonNull
        public AdBreakInfo build() {
            AdBreakInfo adBreakInfo = new AdBreakInfo(this.zza, this.zzb, this.zzc, this.zzd, this.zzf, this.zze, this.zzg);
            return adBreakInfo;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(long playbackPositionInMs) {
            void var1_1;
            this.zza = var1_1;
        }
    }
}

