/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadOptions;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzbl;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzbdg;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbek;
import com.google.android.gms.internal.zzbel;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzbeo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbej
extends zzbdg {
    public static final String NAMESPACE = zzbdw.zzfw("com.google.cast.media");
    private long zzfns;
    private MediaStatus zzfnt;
    private final List<zzbeo> zzfki;
    private zzbek zzfnu;
    private final zzbeo zzfnv;
    private final zzbeo zzfnw;
    private final zzbeo zzfnx;
    private final zzbeo zzfny;
    private final zzbeo zzfnz;
    private final zzbeo zzfoa;
    private final zzbeo zzfob;
    private final zzbeo zzfoc;
    private final zzbeo zzfod;
    private final zzbeo zzfoe;
    private final zzbeo zzfof;
    private final zzbeo zzfog;
    private final zzbeo zzfoh;
    private final zzbeo zzfoi;
    private final zzbeo zzfoj;

    public zzbej(String string2, zze zze2) {
        super(NAMESPACE, zze2, "MediaControlChannel", null, 1000L);
        this.zzfnv = new zzbeo(this.zzata, 86400000L);
        this.zzfnw = new zzbeo(this.zzata, 86400000L);
        this.zzfnx = new zzbeo(this.zzata, 86400000L);
        this.zzfny = new zzbeo(this.zzata, 86400000L);
        this.zzfnz = new zzbeo(this.zzata, 86400000L);
        this.zzfoa = new zzbeo(this.zzata, 86400000L);
        this.zzfob = new zzbeo(this.zzata, 86400000L);
        this.zzfoc = new zzbeo(this.zzata, 86400000L);
        this.zzfod = new zzbeo(this.zzata, 86400000L);
        this.zzfoe = new zzbeo(this.zzata, 86400000L);
        this.zzfof = new zzbeo(this.zzata, 86400000L);
        this.zzfog = new zzbeo(this.zzata, 86400000L);
        this.zzfoh = new zzbeo(this.zzata, 86400000L);
        this.zzfoi = new zzbeo(this.zzata, 86400000L);
        this.zzfoj = new zzbeo(this.zzata, 86400000L);
        this.zzfki = new ArrayList<zzbeo>();
        this.zzfki.add(this.zzfnv);
        this.zzfki.add(this.zzfnw);
        this.zzfki.add(this.zzfnx);
        this.zzfki.add(this.zzfny);
        this.zzfki.add(this.zzfnz);
        this.zzfki.add(this.zzfoa);
        this.zzfki.add(this.zzfob);
        this.zzfki.add(this.zzfoc);
        this.zzfki.add(this.zzfod);
        this.zzfki.add(this.zzfoe);
        this.zzfki.add(this.zzfof);
        this.zzfki.add(this.zzfog);
        this.zzfki.add(this.zzfoh);
        this.zzfki.add(this.zzfoi);
        this.zzfki.add(this.zzfoj);
        this.zzagy();
    }

    public final void zza(zzbek zzbek2) {
        this.zzfnu = zzbek2;
    }

    public final long zza(@NonNull zzben zzben2, @NonNull MediaInfo mediaInfo, @NonNull MediaLoadOptions mediaLoadOptions) throws IllegalStateException, IllegalArgumentException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzagn();
        this.zzfnv.zza(l, zzben2);
        this.zzbg(true);
        try {
            JSONArray jSONArray;
            long[] lArray;
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"LOAD");
            jSONObject.put("media", (Object)mediaInfo.toJson());
            jSONObject.put("autoplay", mediaLoadOptions.getAutoplay());
            jSONObject.put("currentTime", (double)mediaLoadOptions.getPlayPosition() / 1000.0);
            jSONObject.put("playbackRate", mediaLoadOptions.getPlaybackRate());
            if (mediaLoadOptions.getCredentials() != null) {
                jSONObject.put("credentials", (Object)mediaLoadOptions.getCredentials());
            }
            if (mediaLoadOptions.getCredentialsType() != null) {
                jSONObject.put("credentialsType", (Object)mediaLoadOptions.getCredentialsType());
            }
            if ((lArray = mediaLoadOptions.getActiveTrackIds()) != null) {
                jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if ((jSONArray = mediaLoadOptions.getCustomData()) != null) {
                jSONObject.put("customData", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzagn();
        this.zzfnw.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzadv());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(zzben zzben2, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzagn();
        this.zzfny.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzadv());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzc(zzben zzben2, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzagn();
        this.zzfnx.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzadv());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, long l, int n, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzagn();
        this.zzfnz.zza(l2, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzadv());
            jSONObject2.put("currentTime", (double)l / 1000.0);
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzben zzben2, double d, JSONObject jSONObject) throws IllegalStateException, zzbel, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzagn();
        this.zzfoa.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzadv());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, boolean bl, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzagn();
        this.zzfob.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzadv());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(zzben zzben2, double d, JSONObject jSONObject) throws IllegalStateException, zzbel {
        if (this.zzfnt == null) {
            throw new zzbel();
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzagn();
        this.zzfoj.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_PLAYBACK_RATE");
            jSONObject2.put("playbackRate", d);
            jSONObject2.put("mediaSessionId", this.zzfnt.zzadv());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2) throws IllegalStateException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzagn();
        this.zzfoc.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzfnt != null) {
                jSONObject.put("mediaSessionId", this.zzfnt.zzadv());
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, long[] lArray) throws IllegalStateException, zzbel {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzagn();
        this.zzfod.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzadv());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, TextTrackStyle textTrackStyle) throws IllegalStateException, zzbel {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzagn();
        this.zzfoe.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzadv());
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzfns == 0L) {
            return 0L;
        }
        double d = this.zzfnt.getPlaybackRate();
        long l = this.zzfnt.getStreamPosition();
        int n = this.zzfnt.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = mediaInfo.getStreamDuration();
        zzbej zzbej2 = this;
        long l3 = zzbej2.zzata.elapsedRealtime() - zzbej2.zzfns;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l;
        }
        long l4 = l + (long)((double)l3 * d);
        if (l2 > 0L && l4 > l2) {
            l4 = l2;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public final long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo != null) {
            return mediaInfo.getStreamDuration();
        }
        return 0L;
    }

    public final MediaStatus getMediaStatus() {
        return this.zzfnt;
    }

    public final MediaInfo getMediaInfo() {
        if (this.zzfnt == null) {
            return null;
        }
        return this.zzfnt.getMediaInfo();
    }

    public final long zza(zzben zzben2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IllegalStateException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid startIndex: ").append(n).toString());
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzagn();
        this.zzfnv.zza(l2, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Invalid repeat mode: ").append(n2).toString());
                }
            }
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzben zzben2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, JSONObject jSONObject) throws IllegalStateException, zzbel, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzagn();
        this.zzfof.zza(l2, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzadv());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzben zzben2, int n, long l, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IllegalArgumentException, IllegalStateException, zzbel {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("playPosition cannot be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzagn();
        this.zzfog.zza(l2, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzadv());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    }
                }
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzben zzben2, int[] nArray, JSONObject jSONObject) throws IllegalStateException, zzbel, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzagn();
        this.zzfoh.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzadv());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, int[] nArray, int n, JSONObject jSONObject) throws IllegalStateException, zzbel, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzagn();
        this.zzfoi.zza(l, zzben2);
        this.zzbg(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzadv());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(String string2, List<zzbl> list) throws IllegalStateException {
        long l = this.zzagn();
        this.zza(zzbej.zza(string2, list, l), l, null);
        return l;
    }

    private static String zza(String string2, List<zzbl> list, long l) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"PRECACHE");
            if (string2 != null) {
                jSONObject.put("precacheData", (Object)string2);
            }
            if (list != null && !list.isEmpty()) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < list.size(); ++i) {
                    jSONArray.put(i, (Object)list.get(i).toJson());
                }
                jSONObject.put("requestItems", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject.toString();
    }

    @Override
    public final void zzfu(String string2) {
        this.zzeui.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            switch (string3) {
                case "MEDIA_STATUS": {
                    JSONArray jSONArray = jSONObject.getJSONArray("status");
                    if (jSONArray.length() > 0) {
                        this.zza(l, jSONArray.getJSONObject(0));
                        return;
                    }
                    this.zzfnt = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzfoc.zzc(l, 0, null);
                    return;
                }
                case "INVALID_PLAYER_STATE": {
                    this.zzeui.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                    JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                    Iterator<zzbeo> iterator = this.zzfki.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject2);
                    }
                    return;
                }
                case "LOAD_FAILED": {
                    JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                    this.zzfnv.zzc(l, 2100, jSONObject3);
                    return;
                }
                case "LOAD_CANCELLED": {
                    JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                    this.zzfnv.zzc(l, 2101, jSONObject4);
                    return;
                }
                case "INVALID_REQUEST": {
                    this.zzeui.zzf("received unexpected error: Invalid Request.", new Object[0]);
                    JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                    Iterator<zzbeo> iterator = this.zzfki.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject5);
                    }
                    break;
                }
            }
            return;
        }
        catch (JSONException jSONException) {
            this.zzeui.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
    }

    private final void zza(long l, JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = this.zzfnv.test(l);
        boolean bl2 = this.zzfnz.zzaha() && !this.zzfnz.test(l);
        boolean bl3 = this.zzfoa.zzaha() && !this.zzfoa.test(l) || this.zzfob.zzaha() && !this.zzfob.test(l);
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        if (bl3) {
            n2 |= 1;
        }
        if (bl || this.zzfnt == null) {
            this.zzfnt = new MediaStatus(jSONObject);
            this.zzfns = this.zzata.elapsedRealtime();
            n = 127;
        } else {
            n = this.zzfnt.zza(jSONObject, n2);
        }
        if ((n & 1) != 0) {
            this.zzfns = this.zzata.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 2) != 0) {
            this.zzfns = this.zzata.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        if ((n & 0x20) != 0) {
            this.zzfns = this.zzata.elapsedRealtime();
            zzbej zzbej2 = this;
            if (zzbej2.zzfnu != null) {
                zzbej2.zzfnu.onAdBreakStatusUpdated();
            }
        }
        if ((n & 0x40) != 0) {
            this.zzfns = this.zzata.elapsedRealtime();
            this.onStatusUpdated();
        }
        Iterator<zzbeo> iterator = this.zzfki.iterator();
        while (iterator.hasNext()) {
            long l2 = l;
            iterator.next().zzc(l2, 0, null);
        }
    }

    private final long zzadv() throws zzbel {
        if (this.zzfnt == null) {
            throw new zzbel();
        }
        return this.zzfnt.zzadv();
    }

    private final void onStatusUpdated() {
        if (this.zzfnu != null) {
            this.zzfnu.onStatusUpdated();
        }
    }

    private final void onMetadataUpdated() {
        if (this.zzfnu != null) {
            this.zzfnu.onMetadataUpdated();
        }
    }

    private final void onQueueStatusUpdated() {
        if (this.zzfnu != null) {
            this.zzfnu.onQueueStatusUpdated();
        }
    }

    private final void onPreloadStatusUpdated() {
        if (this.zzfnu != null) {
            this.zzfnu.onPreloadStatusUpdated();
        }
    }

    private final void zzagy() {
        this.zzfns = 0L;
        this.zzfnt = null;
        Iterator<zzbeo> iterator = this.zzfki.iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }

    @Override
    public final void zzagm() {
        super.zzagm();
        this.zzagy();
    }

    @Override
    public final void zzc(long l, int n) {
        Iterator<zzbeo> iterator = this.zzfki.iterator();
        while (iterator.hasNext()) {
            int n2 = n;
            long l2 = l;
            iterator.next().zzc(l2, n2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzbeo> iterator = this.zzfki.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzbeo.zzakj;
        synchronized (object) {
            Iterator<zzbeo> iterator2 = this.zzfki.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzaha()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

