/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.zzbn;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle
extends zzbgl {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    @Hide
    public static final Parcelable.Creator<TextTrackStyle> CREATOR = new zzbn();
    private float zzezf;
    private int zzezg;
    private int zzbxm;
    private int zzezh;
    private int zzezi;
    private int zzezj;
    private int zzezk;
    private int zzezl;
    private String zzezm;
    private int zzezn;
    private int zzezo;
    private String zzesn;
    private JSONObject zzess;

    TextTrackStyle(float f, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, String string3) {
        this.zzezf = f;
        this.zzezg = n;
        this.zzbxm = n2;
        this.zzezh = n3;
        this.zzezi = n4;
        this.zzezj = n5;
        this.zzezk = n6;
        this.zzezl = n7;
        this.zzezm = string2;
        this.zzezn = n8;
        this.zzezo = n9;
        this.zzesn = string3;
        if (this.zzesn != null) {
            try {
                this.zzess = new JSONObject(this.zzesn);
                return;
            }
            catch (JSONException jSONException) {
                this.zzess = null;
                this.zzesn = null;
                return;
            }
        }
        this.zzess = null;
    }

    public TextTrackStyle() {
        this(1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    public final void setFontScale(float f) {
        this.zzezf = f;
    }

    public final float getFontScale() {
        return this.zzezf;
    }

    public final void setForegroundColor(int n) {
        this.zzezg = n;
    }

    public final int getForegroundColor() {
        return this.zzezg;
    }

    public final void setBackgroundColor(int n) {
        this.zzbxm = n;
    }

    public final int getBackgroundColor() {
        return this.zzbxm;
    }

    public final void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzezh = n;
    }

    public final int getEdgeType() {
        return this.zzezh;
    }

    public final void setEdgeColor(int n) {
        this.zzezi = n;
    }

    public final int getEdgeColor() {
        return this.zzezi;
    }

    public final void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzezj = n;
    }

    public final int getWindowType() {
        return this.zzezj;
    }

    public final void setWindowColor(int n) {
        this.zzezk = n;
    }

    public final int getWindowColor() {
        return this.zzezk;
    }

    public final void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzezl = n;
    }

    public final int getWindowCornerRadius() {
        return this.zzezl;
    }

    public final void setFontFamily(String string2) {
        this.zzezm = string2;
    }

    public final String getFontFamily() {
        return this.zzezm;
    }

    public final void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzezn = n;
    }

    public final int getFontGenericFamily() {
        return this.zzezn;
    }

    public final void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzezo = n;
    }

    public final int getFontStyle() {
        return this.zzezo;
    }

    public final void setCustomData(JSONObject jSONObject) {
        this.zzess = jSONObject;
    }

    public final JSONObject getCustomData() {
        return this.zzess;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzs.zzanv()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (!Typeface.SANS_SERIF.equals((Object)typeface) && Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    @Hide
    public final void zzt(JSONObject jSONObject) throws JSONException {
        String string2;
        this.zzezf = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzezg = TextTrackStyle.zzfo(jSONObject.optString("foregroundColor"));
        this.zzbxm = TextTrackStyle.zzfo(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzezh = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzezh = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzezh = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzezh = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzezh = 4;
            }
        }
        this.zzezi = TextTrackStyle.zzfo(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzezj = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzezj = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzezj = 2;
            }
        }
        this.zzezk = TextTrackStyle.zzfo(jSONObject.optString("windowColor"));
        if (this.zzezj == 2) {
            this.zzezl = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzezm = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzezn = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzezn = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzezn = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzezn = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzezn = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzezn = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzezn = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzezo = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzezo = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzezo = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzezo = 3;
            }
        }
        this.zzess = jSONObject.optJSONObject("customData");
    }

    @Hide
    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzezf);
            if (this.zzezg != 0) {
                jSONObject.put("foregroundColor", (Object)TextTrackStyle.zzbd(this.zzezg));
            }
            if (this.zzbxm != 0) {
                jSONObject.put("backgroundColor", (Object)TextTrackStyle.zzbd(this.zzbxm));
            }
            switch (this.zzezh) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                }
            }
            if (this.zzezi != 0) {
                jSONObject.put("edgeColor", (Object)TextTrackStyle.zzbd(this.zzezi));
            }
            switch (this.zzezj) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                }
            }
            if (this.zzezk != 0) {
                jSONObject.put("windowColor", (Object)TextTrackStyle.zzbd(this.zzezk));
            }
            if (this.zzezj == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzezl);
            }
            if (this.zzezm != null) {
                jSONObject.put("fontFamily", (Object)this.zzezm);
            }
            switch (this.zzezn) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                }
            }
            switch (this.zzezo) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                }
            }
            if (this.zzess != null) {
                jSONObject.put("customData", (Object)this.zzess);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    private static String zzbd(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private static int zzfo(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                return Color.argb((int)Integer.parseInt(string2.substring(7, 9), 16), (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)((Object)object);
        if (this.zzess == null != (textTrackStyle.zzess == null)) {
            return false;
        }
        if (this.zzess != null && textTrackStyle.zzess != null && !zzq.zzc((Object)this.zzess, (Object)textTrackStyle.zzess)) {
            return false;
        }
        return this.zzezf == textTrackStyle.zzezf && this.zzezg == textTrackStyle.zzezg && this.zzbxm == textTrackStyle.zzbxm && this.zzezh == textTrackStyle.zzezh && this.zzezi == textTrackStyle.zzezi && this.zzezj == textTrackStyle.zzezj && this.zzezl == textTrackStyle.zzezl && zzbdw.zza(this.zzezm, textTrackStyle.zzezm) && this.zzezn == textTrackStyle.zzezn && this.zzezo == textTrackStyle.zzezo;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.zzezf), this.zzezg, this.zzbxm, this.zzezh, this.zzezi, this.zzezj, this.zzezk, this.zzezl, this.zzezm, this.zzezn, this.zzezo, String.valueOf(this.zzess)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzesn = this.zzess == null ? null : this.zzess.toString();
        Parcel parcel2 = parcel;
        TextTrackStyle textTrackStyle = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (float)textTrackStyle.getFontScale());
        zzbgo.zzc((Parcel)parcel2, (int)3, (int)textTrackStyle.getForegroundColor());
        zzbgo.zzc((Parcel)parcel2, (int)4, (int)textTrackStyle.getBackgroundColor());
        zzbgo.zzc((Parcel)parcel2, (int)5, (int)textTrackStyle.getEdgeType());
        zzbgo.zzc((Parcel)parcel2, (int)6, (int)textTrackStyle.getEdgeColor());
        zzbgo.zzc((Parcel)parcel2, (int)7, (int)textTrackStyle.getWindowType());
        zzbgo.zzc((Parcel)parcel2, (int)8, (int)textTrackStyle.getWindowColor());
        zzbgo.zzc((Parcel)parcel2, (int)9, (int)textTrackStyle.getWindowCornerRadius());
        zzbgo.zza((Parcel)parcel2, (int)10, (String)textTrackStyle.getFontFamily(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)11, (int)textTrackStyle.getFontGenericFamily());
        zzbgo.zzc((Parcel)parcel2, (int)12, (int)textTrackStyle.getFontStyle());
        zzbgo.zza((Parcel)parcel2, (int)13, (String)textTrackStyle.zzesn, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

