/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzak;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack
extends zzbgl
implements ReflectedParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    @Hide
    public static final Parcelable.Creator<MediaTrack> CREATOR = new zzak();
    private long zzehj;
    private int zzenu;
    private String zzeso;
    private String zzevz;
    private String mName;
    private String zzdxa;
    private int zzexr;
    private String zzesn;
    private JSONObject zzess;

    MediaTrack(long l, int n, String string2, String string3, String string4, String string5, int n2, String string6) {
        this.zzehj = l;
        this.zzenu = n;
        this.zzeso = string2;
        this.zzevz = string3;
        this.mName = string4;
        this.zzdxa = string5;
        this.zzexr = n2;
        this.zzesn = string6;
        if (this.zzesn != null) {
            try {
                this.zzess = new JSONObject(this.zzesn);
                return;
            }
            catch (JSONException jSONException) {
                this.zzess = null;
                this.zzesn = null;
                return;
            }
        }
        this.zzess = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    MediaTrack(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this(0L, 0, null, null, null, null, -1, null);
                            jSONObject2 = jSONObject;
                            MediaTrack mediaTrack = this;
                            this.zzehj = jSONObject2.getLong("trackId");
                            string2 = jSONObject2.getString("type");
                            if ("TEXT".equals(string2)) {
                                mediaTrack.zzenu = 1;
                            } else if ("AUDIO".equals(string2)) {
                                mediaTrack.zzenu = 2;
                            } else if ("VIDEO".equals(string2)) {
                                mediaTrack.zzenu = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            mediaTrack.zzeso = jSONObject2.optString("trackContentId", null);
                            mediaTrack.zzevz = jSONObject2.optString("trackContentType", null);
                            mediaTrack.mName = jSONObject2.optString("name", null);
                            mediaTrack.zzdxa = jSONObject2.optString("language", null);
                            if (!jSONObject2.has("subtype")) break block13;
                            string2 = jSONObject2.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            mediaTrack.zzexr = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        mediaTrack.zzexr = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    mediaTrack.zzexr = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    mediaTrack.zzexr = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    mediaTrack.zzexr = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            mediaTrack.zzexr = 0;
        }
        mediaTrack.zzess = jSONObject2.optJSONObject("customData");
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this(0L, 0, null, null, null, null, -1, null);
        this.zzehj = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.zzenu = n;
    }

    public final long getId() {
        return this.zzehj;
    }

    public final int getType() {
        return this.zzenu;
    }

    public final String getContentId() {
        return this.zzeso;
    }

    public final void setContentId(String string2) {
        this.zzeso = string2;
    }

    public final String getContentType() {
        return this.zzevz;
    }

    public final void setContentType(String string2) {
        this.zzevz = string2;
    }

    public final String getName() {
        return this.mName;
    }

    final void setName(String string2) {
        this.mName = string2;
    }

    public final String getLanguage() {
        return this.zzdxa;
    }

    final void setLanguage(String string2) {
        this.zzdxa = string2;
    }

    public final int getSubtype() {
        return this.zzexr;
    }

    final void zzbb(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.zzenu != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzexr = n;
    }

    public final JSONObject getCustomData() {
        return this.zzess;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzess = jSONObject;
    }

    @Hide
    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzehj);
            switch (this.zzenu) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                }
            }
            if (this.zzeso != null) {
                jSONObject.put("trackContentId", (Object)this.zzeso);
            }
            if (this.zzevz != null) {
                jSONObject.put("trackContentType", (Object)this.zzevz);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzdxa)) {
                jSONObject.put("language", (Object)this.zzdxa);
            }
            switch (this.zzexr) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                }
            }
            if (this.zzess != null) {
                jSONObject.put("customData", (Object)this.zzess);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)((Object)object);
        if (this.zzess == null != (mediaTrack.zzess == null)) {
            return false;
        }
        if (this.zzess != null && mediaTrack.zzess != null && !zzq.zzc((Object)this.zzess, (Object)mediaTrack.zzess)) {
            return false;
        }
        return this.zzehj == mediaTrack.zzehj && this.zzenu == mediaTrack.zzenu && zzbdw.zza(this.zzeso, mediaTrack.zzeso) && zzbdw.zza(this.zzevz, mediaTrack.zzevz) && zzbdw.zza(this.mName, mediaTrack.mName) && zzbdw.zza(this.zzdxa, mediaTrack.zzdxa) && this.zzexr == mediaTrack.zzexr;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzehj, this.zzenu, this.zzeso, this.zzevz, this.mName, this.zzdxa, this.zzexr, String.valueOf(this.zzess)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzesn = this.zzess == null ? null : this.zzess.toString();
        Parcel parcel2 = parcel;
        MediaTrack mediaTrack = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)mediaTrack.getId());
        zzbgo.zzc((Parcel)parcel2, (int)3, (int)mediaTrack.getType());
        zzbgo.zza((Parcel)parcel2, (int)4, (String)mediaTrack.getContentId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)mediaTrack.getContentType(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)mediaTrack.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (String)mediaTrack.getLanguage(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)8, (int)mediaTrack.getSubtype());
        zzbgo.zza((Parcel)parcel2, (int)9, (String)mediaTrack.zzesn, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaTrack zzexs;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.zzexs = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.zzexs.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zzexs.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.zzexs.setName(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.zzexs.setLanguage(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzexs.setLanguage(zzbdw.zzb(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.zzexs.zzbb(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzexs.setCustomData(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.zzexs;
        }
    }
}

