/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzae;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaInfo
extends zzbgl
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    @Hide
    public static final Parcelable.Creator<MediaInfo> CREATOR = new zzae();
    private final String zzeso;
    private int zzevy;
    private String zzevz;
    private MediaMetadata zzewa;
    private long zzewb;
    private List<MediaTrack> zzewc;
    private TextTrackStyle zzewd;
    private String zzesn;
    private List<AdBreakInfo> zzewe;
    private List<AdBreakClipInfo> zzewf;
    private String zzewg;
    private JSONObject zzess;

    MediaInfo(@NonNull String string2, int n, String string3, MediaMetadata mediaMetadata, long l, List<MediaTrack> list, TextTrackStyle textTrackStyle, String string4, List<AdBreakInfo> list2, List<AdBreakClipInfo> list3, String string5) {
        this.zzeso = string2;
        this.zzevy = n;
        this.zzevz = string3;
        this.zzewa = mediaMetadata;
        this.zzewb = l;
        this.zzewc = list;
        this.zzewd = textTrackStyle;
        this.zzesn = string4;
        if (this.zzesn != null) {
            try {
                this.zzess = new JSONObject(this.zzesn);
            }
            catch (JSONException jSONException) {
                this.zzess = null;
                this.zzesn = null;
            }
        } else {
            this.zzess = null;
        }
        this.zzewe = list2;
        this.zzewf = list3;
        this.zzewg = string5;
    }

    MediaInfo(String string2) throws IllegalArgumentException {
        this(string2, -1, null, null, -1L, null, null, null, null, null, null);
        if (string2 == null) {
            throw new IllegalArgumentException("contentID cannot be null");
        }
    }

    MediaInfo(String string2, String string3) throws IllegalArgumentException {
        this(string2, -1, null, null, -1L, null, null, null, null, null, string3);
        if (string2 == null) {
            throw new IllegalArgumentException("contentID cannot be null");
        }
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(jSONObject.getString("contentId"), -1, null, null, -1L, null, null, null, null, null, null);
        double d;
        int n;
        JSONObject jSONObject2;
        String string2 = jSONObject.getString("streamType");
        this.zzevy = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzevz = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.zzewa = new MediaMetadata(n);
            this.zzewa.zzt(jSONObject2);
        }
        this.zzewb = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzewb = (long)(d * 1000.0);
        }
        if (jSONObject.has("tracks")) {
            this.zzewc = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject3);
                this.zzewc.add(mediaTrack);
            }
        } else {
            this.zzewc = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzt(jSONObject2);
            this.zzewd = textTrackStyle;
        } else {
            this.zzewd = null;
        }
        this.zzs(jSONObject);
        this.zzess = jSONObject.optJSONObject("customData");
        if (jSONObject.has("entity")) {
            this.zzewg = jSONObject.getString("entity");
        }
    }

    public String getContentId() {
        return this.zzeso;
    }

    final void setStreamType(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzevy = n;
    }

    public int getStreamType() {
        return this.zzevy;
    }

    final void setContentType(String string2) {
        this.zzevz = string2;
    }

    public String getContentType() {
        return this.zzevz;
    }

    final void zza(MediaMetadata mediaMetadata) {
        this.zzewa = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzewa;
    }

    final void zzw(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzewb = l;
    }

    public long getStreamDuration() {
        return this.zzewb;
    }

    final void zzz(List<MediaTrack> list) {
        this.zzewc = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzewc;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzewd = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzewd;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzess = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzess;
    }

    public List<AdBreakInfo> getAdBreaks() {
        if (this.zzewe == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzewe);
    }

    public List<AdBreakClipInfo> getAdBreakClips() {
        if (this.zzewf == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzewf);
    }

    @Hide
    public final void zzaa(List<AdBreakInfo> list) {
        this.zzewe = list;
    }

    @Hide
    final void zzab(List<AdBreakClipInfo> list) {
        this.zzewf = list;
    }

    final void zzs(JSONObject jSONObject) throws JSONException {
        zzbgl zzbgl2;
        int n;
        JSONArray jSONArray;
        if (jSONObject.has("breaks")) {
            jSONArray = jSONObject.getJSONArray("breaks");
            this.zzewe = new ArrayList<AdBreakInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zzbgl2 = AdBreakInfo.zzq(jSONArray.getJSONObject(n));
                if (zzbgl2 == null) {
                    this.zzewe.clear();
                    break;
                }
                this.zzewe.add((AdBreakInfo)zzbgl2);
            }
        }
        if (jSONObject.has("breakClips")) {
            jSONArray = jSONObject.getJSONArray("breakClips");
            this.zzewf = new ArrayList<AdBreakClipInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zzbgl2 = AdBreakClipInfo.zzp(jSONArray.getJSONObject(n));
                if (zzbgl2 == null) {
                    this.zzewf.clear();
                    return;
                }
                this.zzewf.add((AdBreakClipInfo)zzbgl2);
            }
        }
    }

    public String getEntity() {
        return this.zzewg;
    }

    @Hide
    public final void zzfk(String string2) {
        this.zzewg = string2;
    }

    @Hide
    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray;
            String string2;
            jSONObject.put("contentId", (Object)this.zzeso);
            switch (this.zzevy) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzevz != null) {
                jSONObject.put("contentType", (Object)this.zzevz);
            }
            if (this.zzewa != null) {
                jSONObject.put("metadata", (Object)this.zzewa.toJson());
            }
            if (this.zzewb <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", (double)this.zzewb / 1000.0);
            }
            if (this.zzewc != null) {
                jSONArray = new JSONArray();
                for (MediaTrack zzbgl2 : this.zzewc) {
                    jSONArray.put((Object)zzbgl2.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzewd != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzewd.toJson());
            }
            if (this.zzess != null) {
                jSONObject.put("customData", (Object)this.zzess);
            }
            if (this.zzewg != null) {
                jSONObject.put("entity", (Object)this.zzewg);
            }
            if (this.zzewe != null) {
                jSONArray = new JSONArray();
                for (AdBreakInfo adBreakInfo : this.zzewe) {
                    jSONArray.put((Object)adBreakInfo.toJson());
                }
                jSONObject.put("breaks", (Object)jSONArray);
            }
            if (this.zzewf != null) {
                jSONArray = new JSONArray();
                for (AdBreakClipInfo adBreakClipInfo : this.zzewf) {
                    jSONArray.put((Object)adBreakClipInfo.toJson());
                }
                jSONObject.put("breakClips", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)((Object)object);
        if (this.zzess == null != (mediaInfo.zzess == null)) {
            return false;
        }
        if (this.zzess != null && mediaInfo.zzess != null && !zzq.zzc((Object)this.zzess, (Object)mediaInfo.zzess)) {
            return false;
        }
        return zzbdw.zza(this.zzeso, mediaInfo.zzeso) && this.zzevy == mediaInfo.zzevy && zzbdw.zza(this.zzevz, mediaInfo.zzevz) && zzbdw.zza(this.zzewa, mediaInfo.zzewa) && this.zzewb == mediaInfo.zzewb && zzbdw.zza(this.zzewc, mediaInfo.zzewc) && zzbdw.zza(this.zzewd, mediaInfo.zzewd) && zzbdw.zza(this.zzewe, mediaInfo.zzewe) && zzbdw.zza(this.zzewf, mediaInfo.zzewf) && zzbdw.zza(this.zzewg, mediaInfo.zzewg);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzeso, this.zzevy, this.zzevz, this.zzewa, this.zzewb, String.valueOf(this.zzess), this.zzewc, this.zzewd, this.zzewe, this.zzewf, this.zzewg});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzesn = this.zzess == null ? null : this.zzess.toString();
        Parcel parcel2 = parcel;
        MediaInfo mediaInfo = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)mediaInfo.getContentId(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)3, (int)mediaInfo.getStreamType());
        zzbgo.zza((Parcel)parcel2, (int)4, (String)mediaInfo.getContentType(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)mediaInfo.getMetadata(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (long)mediaInfo.getStreamDuration());
        zzbgo.zzc((Parcel)parcel2, (int)7, mediaInfo.getMediaTracks(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)mediaInfo.getTextTrackStyle(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (String)mediaInfo.zzesn, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)10, mediaInfo.getAdBreaks(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)11, mediaInfo.getAdBreakClips(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (String)mediaInfo.getEntity(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaInfo zzewh;

        public Builder(String string2) throws IllegalArgumentException {
            this.zzewh = new MediaInfo(string2);
        }

        public Builder(String string2, String string3) throws IllegalArgumentException {
            this.zzewh = new MediaInfo(string2, string3);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.zzewh.setStreamType(n);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zzewh.setContentType(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.zzewh.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.zzewh.zzw(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzewh.setCustomData(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.zzewh.zzz(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzewh.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public Builder setEntity(String string2) {
            this.zzewh.zzfk(string2);
            return this;
        }

        public Builder setAdBreaks(List<AdBreakInfo> list) {
            this.zzewh.zzaa(list);
            return this;
        }

        public Builder setAdBreakClips(List<AdBreakClipInfo> list) {
            this.zzewh.zzab(list);
            return this;
        }

        public MediaInfo build() {
            return this.zzewh;
        }
    }
}

