/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.mediarouter.R;
import androidx.mediarouter.app.MediaRouteChooserDialog;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzac;
import com.google.android.gms.internal.cast.zzdy;
import com.google.android.gms.internal.cast.zzp;
import com.google.android.gms.internal.cast.zzs;
import com.google.android.gms.internal.cast.zzt;
import com.google.android.gms.internal.cast.zzu;
import com.google.android.gms.internal.cast.zzv;
import com.google.android.gms.internal.cast.zzw;
import com.google.android.gms.internal.cast.zzx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzy
extends MediaRouteChooserDialog
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final Logger zzh = new Logger("DeviceChooserDialog");
    private final zzw zzi;
    private final List zzj = new CopyOnWriteArrayList();
    private final long zzk;
    private final boolean zzl;
    private MediaRouter zzm;
    private zzdy zzn;
    private MediaRouteSelector zzo = MediaRouteSelector.EMPTY;
    private ArrayAdapter zzp;
    private boolean zzq;
    private Runnable zzr;
    private MediaRouter.RouteInfo zzs;
    @Nullable
    TextView zza;
    @Nullable
    ListView zzb;
    @Nullable
    View zzc;
    @Nullable
    LinearLayout zzd;
    @Nullable
    LinearLayout zze;
    @Nullable
    LinearLayout zzf;
    @Nullable
    RelativeLayout zzg;

    public final MediaRouteSelector getRouteSelector() {
        return this.zzo;
    }

    static /* bridge */ /* synthetic */ List zza(zzy zzy2) {
        return zzy2.zzj;
    }

    static /* bridge */ /* synthetic */ void zzb(zzy zzy2, MediaRouter.RouteInfo routeInfo) {
        zzy2.zzs = routeInfo;
    }

    static /* bridge */ /* synthetic */ void zzc(zzy zzy2) {
        zzy2.zzf();
    }

    public zzy(Context context, int n) {
        super(context, 0);
        this.zzi = new zzw(this);
        this.zzk = zzac.zza();
        this.zzl = zzac.zzc();
    }

    @CallSuper
    public final void dismiss() {
        super.dismiss();
        Object object = this.zzn;
        if (object != null) {
            object.removeCallbacks(this.zzr);
        }
        if ((object = this.zzc) != null) {
            object.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        object = this.zzj.iterator();
        while (object.hasNext()) {
            ((zzv)object.next()).zzb(this.zzs);
        }
        this.zzj.clear();
    }

    final /* synthetic */ void zzd() {
        ((zzy)((Object)iterator)).zzi(2);
        Iterator iterator = ((zzy)((Object)iterator)).zzj.iterator();
        while (iterator.hasNext()) {
            zzv cfr_ignored_0 = (zzv)iterator.next();
        }
    }

    private final void zzf() {
        MediaRouter mediaRouter = ((zzy)((Object)iterator)).zzm;
        if (mediaRouter != null) {
            ArrayList arrayList = new ArrayList(mediaRouter.getRoutes());
            iterator.onFilterRoutes(arrayList);
            Collections.sort(arrayList, zzx.zza);
            Iterator iterator = ((zzy)((Object)iterator)).zzj.iterator();
            while (iterator.hasNext()) {
                ((zzv)iterator.next()).zza(arrayList);
            }
        }
    }

    @CallSuper
    public final void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.zzq = true;
        this.zzg();
        this.zzf();
    }

    protected final void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        bundle = (ListView)super.findViewById(R.id.mr_chooser_list);
        if (bundle == null) {
            return;
        }
        this.setContentView(R.layout.cast_device_chooser_dialog);
        this.zzp = (ArrayAdapter)bundle.getAdapter();
        ListView listView = this.zzb = (ListView)this.findViewById(R.id.cast_device_chooser_list);
        if (listView != null) {
            listView.setAdapter((ListAdapter)this.zzp);
            this.zzb.setOnItemClickListener(bundle.getOnItemClickListener());
        }
        this.zza = (TextView)this.findViewById(R.id.cast_device_chooser_title);
        this.zzd = (LinearLayout)this.findViewById(R.id.cast_device_chooser_searching);
        this.zze = (LinearLayout)this.findViewById(R.id.cast_device_chooser_zero_devices);
        this.zzf = (LinearLayout)this.findViewById(R.id.cast_device_chooser_wifi_warning);
        this.zzg = (RelativeLayout)this.findViewById(R.id.footer);
        bundle = (TextView)this.findViewById(R.id.cast_device_chooser_learn_more);
        listView = (TextView)this.findViewById(R.id.cast_device_chooser_wifi_warning_description);
        zzt zzt2 = new zzt(this);
        if (bundle != null) {
            bundle.setMovementMethod(LinkMovementMethod.getInstance());
            bundle.setOnClickListener((View.OnClickListener)zzt2);
        }
        if (listView != null) {
            listView.setMovementMethod(LinkMovementMethod.getInstance());
            listView.setOnClickListener((View.OnClickListener)zzt2);
        }
        if ((bundle = (Button)this.findViewById(R.id.done_button)) != null) {
            bundle.setOnClickListener((View.OnClickListener)new zzu(this));
        }
        this.zzc = this.findViewById(16908292);
        if (this.zzb != null && (bundle = this.zzc) != null) {
            ((View)Preconditions.checkNotNull((Object)bundle)).getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            ((ListView)Preconditions.checkNotNull((Object)this.zzb)).setEmptyView((View)Preconditions.checkNotNull((Object)this.zzc));
        }
        this.zzr = new zzs(this);
    }

    @CallSuper
    public final void onDetachedFromWindow() {
        this.zzq = false;
        super.onDetachedFromWindow();
        this.zzh();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onGlobalLayout() {
        View view = this.zzc;
        if (view == null) {
            return;
        }
        Object object = view.getTag();
        int n = this.zzc.getVisibility();
        if (object != null && (Integer)object == n) {
            return;
        }
        if (n == 0) {
            this.zzi(1);
            zzdy zzdy2 = this.zzn;
            if (zzdy2 != null) {
                zzdy2.removeCallbacks(this.zzr);
                this.zzn.postDelayed(this.zzr, this.zzk);
            }
        } else {
            this.setTitle(R.string.cast_device_chooser_title);
        }
        ((View)Preconditions.checkNotNull((Object)this.zzc)).setTag((Object)n);
    }

    public final void refreshRoutes() {
        super.refreshRoutes();
        this.zzf();
    }

    public final void setRouteSelector(MediaRouteSelector mediaRouteSelector) {
        if (mediaRouteSelector == null) {
            throw new IllegalArgumentException("selector must not be null");
        }
        super.setRouteSelector(mediaRouteSelector);
        if (!this.zzo.equals((Object)mediaRouteSelector)) {
            this.zzo = mediaRouteSelector;
            this.zzh();
            if (this.zzq) {
                this.zzg();
            }
            this.zzf();
            return;
        }
    }

    public final void setTitle(int n) {
        zzy zzy2 = zzy2.zza;
        if (zzy2 != null) {
            zzy2.setText(n);
            return;
        }
    }

    public final void setTitle(@Nullable CharSequence charSequence) {
        zzy zzy2 = zzy2.zza;
        if (zzy2 != null) {
            zzy2.setText(charSequence);
            return;
        }
    }

    public final void zze() {
        this.zzm = MediaRouter.getInstance((Context)this.getContext());
        this.zzn = new zzdy(Looper.getMainLooper());
        zzv zzv2 = com.google.android.gms.internal.cast.zzp.zza();
        if (zzv2 != null) {
            this.zzj.add(zzv2);
            return;
        }
    }

    private final void zzg() {
        Object object;
        zzh.d("startDiscovery", new Object[0]);
        MediaRouter mediaRouter = ((zzy)((Object)object)).zzm;
        if (mediaRouter == null) {
            object = new Object[]{};
            zzh.d("Can't start discovery. setUpMediaRouter needs to be called first", (Object[])object);
            return;
        }
        mediaRouter.addCallback(((zzy)((Object)object)).zzo, (MediaRouter.Callback)((zzy)((Object)object)).zzi, 1);
        object = ((zzy)((Object)object)).zzj.iterator();
        while (object.hasNext()) {
            ((zzv)object.next()).zzc(1);
        }
    }

    private final void zzh() {
        Object object;
        zzh.d("stopDiscovery", new Object[0]);
        MediaRouter mediaRouter = ((zzy)((Object)object)).zzm;
        if (mediaRouter == null) {
            object = new Object[]{};
            zzh.d("Can't stop discovery. setUpMediaRouter needs to be called first", (Object[])object);
            return;
        }
        mediaRouter.removeCallback((MediaRouter.Callback)((zzy)((Object)object)).zzi);
        ((zzy)((Object)object)).zzm.addCallback(((zzy)((Object)object)).zzo, (MediaRouter.Callback)((zzy)((Object)object)).zzi, 0);
        object = ((zzy)((Object)object)).zzj.iterator();
        while (object.hasNext()) {
            ((zzv)object.next()).zzd();
        }
    }

    private final void zzi(int n) {
        if (this.zzd == null || this.zze == null || this.zzf == null || this.zzg == null) {
            return;
        }
        CastContext castContext = CastContext.getSharedInstance();
        if (this.zzl && castContext != null && !castContext.zzf().zza()) {
            n = 3;
        }
        switch (n + -1) {
            default: {
                this.setTitle(R.string.cast_wifi_warning_title);
                ((LinearLayout)Preconditions.checkNotNull((Object)this.zzd)).setVisibility(8);
                ((LinearLayout)Preconditions.checkNotNull((Object)this.zze)).setVisibility(8);
                ((LinearLayout)Preconditions.checkNotNull((Object)this.zzf)).setVisibility(0);
                ((RelativeLayout)Preconditions.checkNotNull((Object)this.zzg)).setVisibility(0);
                return;
            }
            case 0: {
                this.setTitle(R.string.cast_device_chooser_title);
                ((LinearLayout)Preconditions.checkNotNull((Object)this.zzd)).setVisibility(0);
                ((LinearLayout)Preconditions.checkNotNull((Object)this.zze)).setVisibility(8);
                ((LinearLayout)Preconditions.checkNotNull((Object)this.zzf)).setVisibility(8);
                ((RelativeLayout)Preconditions.checkNotNull((Object)this.zzg)).setVisibility(8);
                return;
            }
            case 1: 
        }
        this.setTitle(R.string.cast_device_chooser_title);
        ((LinearLayout)Preconditions.checkNotNull((Object)this.zzd)).setVisibility(8);
        ((LinearLayout)Preconditions.checkNotNull((Object)this.zze)).setVisibility(0);
        ((LinearLayout)Preconditions.checkNotNull((Object)this.zzf)).setVisibility(8);
        ((RelativeLayout)Preconditions.checkNotNull((Object)this.zzg)).setVisibility(0);
    }
}

