/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.cast.framework.media.widget.CastSeekBar;
import com.google.android.gms.cast.framework.media.widget.zzb;
import com.google.android.gms.cast.framework.media.widget.zzc;
import com.google.android.gms.cast.framework.media.widget.zze;
import java.util.ArrayList;
import java.util.List;

public final class zzbs
extends UIController
implements RemoteMediaClient.ProgressListener {
    private final CastSeekBar zza;
    private final long zzb;
    private final zza zzc;

    @Override
    @VisibleForTesting(otherwise=4)
    @Nullable
    public final RemoteMediaClient getRemoteMediaClient() {
        return super.getRemoteMediaClient();
    }

    public zzbs(CastSeekBar castSeekBar, long l, zza zza2) {
        this.zza = castSeekBar;
        this.zzb = l;
        this.zzc = zza2;
        castSeekBar.setEnabled(false);
        castSeekBar.zzd(null);
        castSeekBar.zzb = null;
        castSeekBar.postInvalidate();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzc();
    }

    @Override
    public final void onProgressUpdated(long l, long l2) {
        this.zzb();
        this.zza();
    }

    @Override
    public final void onSessionConnected(CastSession object) {
        super.onSessionConnected((CastSession)object);
        object = super.getRemoteMediaClient();
        if (object != null) {
            zzbs zzbs2 = this;
            ((RemoteMediaClient)object).addProgressListener(zzbs2, zzbs2.zzb);
        }
        this.zzc();
    }

    @Override
    public final void onSessionEnded() {
        RemoteMediaClient remoteMediaClient = super.getRemoteMediaClient();
        if (remoteMediaClient != null) {
            remoteMediaClient.removeProgressListener(this);
        }
        super.onSessionEnded();
        this.zzc();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final void zza() {
        RemoteMediaClient remoteMediaClient = super.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.isPlayingAd()) {
            this.zza.zzb = null;
            this.zza.postInvalidate();
            return;
        }
        int n = (int)remoteMediaClient.getApproximateAdBreakClipPositionMs();
        remoteMediaClient = (remoteMediaClient = remoteMediaClient.getMediaStatus()) != null ? remoteMediaClient.getCurrentAdBreakClip() : null;
        int n2 = remoteMediaClient != null ? (int)remoteMediaClient.getDurationInMs() : n;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 1;
        }
        CastSeekBar castSeekBar = this.zza;
        if (n > n2) {
            n2 = n;
        }
        castSeekBar.zzb = new zzc(n, n2);
        castSeekBar.postInvalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final void zzb() {
        RemoteMediaClient remoteMediaClient = super.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || remoteMediaClient.isPlayingAd()) {
            this.zza.setEnabled(false);
        } else {
            this.zza.setEnabled(true);
        }
        zze zze2 = new zze();
        zze2.zza = this.zzc.zza();
        zze2.zzb = this.zzc.zzb();
        zze2.zzc = (int)(-this.zzc.zze());
        remoteMediaClient = super.getRemoteMediaClient();
        int n = remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || !remoteMediaClient.zzv() ? this.zzc.zza() : this.zzc.zzd();
        zze2.zzd = n;
        RemoteMediaClient remoteMediaClient2 = super.getRemoteMediaClient();
        int n2 = remoteMediaClient2 == null || !remoteMediaClient2.hasMediaSession() || !remoteMediaClient2.zzv() ? this.zzc.zza() : this.zzc.zzc();
        zze2.zze = n2;
        RemoteMediaClient remoteMediaClient3 = super.getRemoteMediaClient();
        boolean bl = remoteMediaClient3 != null ? (remoteMediaClient3.hasMediaSession() ? remoteMediaClient3.zzv() : false) : false;
        zze2.zzf = bl;
        this.zza.zze(zze2);
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    final void zzc() {
        block7: {
            this.zzb();
            var2_1 = super.getRemoteMediaClient();
            if (var2_1 != null) break block7;
            var1_2 = null;
lbl5:
            // 2 sources

            while (true) {
                block8: {
                    if (var2_1 == null || !var2_1.hasMediaSession() || var2_1.isLoadingNextItem() || var1_2 == null) break block8;
                    var2_1 = this.zza;
                    if ((var1_2 = var1_2.getAdBreaks()) == null) {
                        var1_2 = null;
lbl10:
                        // 2 sources

                        while (true) {
                            var2_1.zzd((List)var1_2);
lbl12:
                            // 2 sources

                            while (true) {
                                this.zza();
                                return;
                            }
                            break;
                        }
                    }
                    var3_4 = new ArrayList<zzb>();
                    var4_5 = var1_2.iterator();
                    block3: while (var4_5.hasNext()) {
                        var5_6 = (AdBreakInfo)var4_5.next();
                        if (var5_6 == null) continue;
                        var6_7 = var5_6.getPlaybackPositionInMs();
                        if (var6_7 == -1000L) {
                            var1_3 = this.zzc.zzb();
lbl23:
                            // 2 sources

                            while (var1_3 >= 0) {
                                var3_4.add(new zzb(var1_3, (int)var5_6.getDurationInMs(), var5_6.isExpanded()));
                                continue block3;
                            }
                            continue;
                        }
                        var1_3 = this.zzc.zzb();
                        var1_3 = Math.min((int)(var6_7 - this.zzc.zze()), var1_3);
                        ** GOTO lbl23
                    }
                    var1_2 = var3_4;
                    ** continue;
                }
                this.zza.zzd(null);
                ** continue;
                break;
            }
        }
        var1_2 = var2_1.getMediaInfo();
        ** while (true)
    }
}

